<?php


	require "config.php";
	require "pdfparser.phar";

	$pdf= (object) $_FILES["pdf"];
	$pdf->size[0] or die("404");


	
	
	foreach( $pdf->name as $i => $name ) {
		$tmp= $pdf->tmp_name[ $i ];

		$file= "pdf/$name";
		move_uploaded_file( $tmp, $file );
		
		echo $name ."<br>";
		import( $file );
	}	
	echo "DONE <br><br>";
	
	
	
	
	function import( $file ) {

		// open pdf
		$parser= new Smalot\PdfParser\Parser();		
		$pdf= $parser->parseFile( $file );
		
		// get data
		$pages= array_map( "getDataTm", $pdf->getPages() );
		$head = array_intersect_assoc( $pages[0], $pages[1] );
		$data = parse( $pages, $head );

		// collect values
		$cjsz  = $data['1.']['Cégjegyzékszám'][0];
		list( $bid, $fid ) = explode( "-", $cjsz );
		$alapitva = datef( $data['1.']['Bejegyezve'][0] );
		$nev   = $data['2/1.'][0] ?: $data['2/2.'][0];
		$rovid = $data['3/1.'][0] ?: $data['3/2.'][0];
		$cim   = $data['5/1.'][0];
		$tev   = search_key( $data, "9/", "tev_map", [1] );
		$vezeto= search_key( $data, "13/", "user_map" );
		$sszj  = codef( $data['20/1.'][0] );
		$asz   = codef( $data['21/1.']['Adószám'][0] );
		$kasz  = codef( $data['21/1.']['Közösségi adószám'][0] );
		$email = array_filter( array_unique( [
			$data['45/1.']['A cég kézbesítési címe'][0],
			$data['45/1.']['A cég e-mail címe'][0],
		] ) );
		$euid  = $data['60/1.']['EUID'][0];
		$tag   = search_key( $data, "60/1.1/", "user_map" );
		$date  = date("Y-m-d");
		
		// delete rows
		delete_ceg( $asz );
		
		// insert ceg
		$id= insert_ceg( $nev, $rovid, $cim, $cjsz, $bid, $fid, $sszj, $asz, $kasz, $euid, $alapitva, $date );
		
		// insert others
		insert_email( $id, $email );
		insert_tev( $id, $tev );
		insert_tag( $id, $tag );
		insert_vezeto( $id, $vezeto );
		
		// log data
		$vars= compact( "nev", "rovid", "cim", "cjsz", "sszj", "asz", "kasz", "euid", "alapitva" );
		$vars= json_encode( $vars, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT );
		$data= json_encode( $data, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT );
		file_put_contents( "log/$id.txt", $vars. $data );
	}
	
	
	
	///////////////////
	// SQL functions //
	///////////////////	

	function delete_ceg( ...$arr ) {
		global $DB;
		
		$stmt= $DB->prepare("
			DELETE ceg, email, tev, tag, vezeto
			FROM ceg
			  LEFT JOIN email ON email.ceg= ceg.id
			  LEFT JOIN tev ON tev.ceg= ceg.id
			  LEFT JOIN tag ON tag.ceg= ceg.id
			  LEFT JOIN vezeto ON vezeto.ceg= ceg.id
			WHERE ceg.asz= ?
		");
		$stmt->execute( $arr );		
	}
	
	
	function insert_ceg( ...$arr ) {
		global $DB;
		
		$stmt= $DB->prepare("
			INSERT INTO ceg
			( nev, rovid, cim, cjsz, bid, fid, sszj, asz, kasz, euid, alapitva, importalva )
			VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? )
		");
		$stmt->execute( $arr );
		
		return $DB->lastInsertId();
	}
	
	
	function insert_email( $id, $arr ) {
		global $DB;
		
		$stmt= $DB->prepare("
			INSERT INTO email
			( ceg, email )
			VALUES ( ?, ? )
		");
		
		foreach( $arr as $email )
		  $stmt->execute([ $id, $email ]);
	}
	
	
	function insert_tev( $id, $arr ) {
		global $DB;
		
		$stmt= $DB->prepare("
			INSERT INTO tev
			( ceg, code, tevekenyseg, fo )
			VALUES ( ?, ?, ?, ? )
		");
		
		foreach( $arr as $tev )
		  $stmt->execute([ $id, ...$tev ]);
	}
	
	
	function insert_tag( $id, $arr ) {
		global $DB;
		
		$stmt= $DB->prepare("
			INSERT INTO tag
			( ceg, nev, an, szul )
			VALUES ( ?, ?, ?, ? )
		");
		
		foreach( $arr as $tag )
		  $stmt->execute([ $id, ...$tag ]);
	}
	
	
	function insert_vezeto( $id, $arr ) {
		global $DB;
		
		$stmt= $DB->prepare("
			INSERT INTO vezeto
			( ceg, nev, an, szul )
			VALUES ( ?, ?, ?, ? )
		");
		
		foreach( $arr as $vezeto )
		  $stmt->execute([ $id, ...$vezeto ]);
	}
	
	
	

	////////////////
	// Parse data //
	////////////////

	function getDataTm( $page ) {
		$page= $page->getDataTm();
		return array_map( "end", $page );
	}


	function iskey( $str ) {
		return preg_match( "@^([0-9/]+\.)$@", $str );
	}


	function par( $str ) {
		preg_match( "@^([A-z \-áéíóúöüőűÁÉÍÓÚÖÜŐŰ]+): ?(.*)$@", $str, $match );
		return array_slice( $match, 1 );
	}


	function bigger( $k1, $k2 ) {
		$k1= intval( $k1 );
		$k2= intval( $k2 );
		return $k1 >= $k2 || $k1 < $k2-100;
	}


	// analize data
	function parse( $pages, $head ) {
		
		foreach( $pages as $page ) {
			
			// remove head
			$page= array_diff_key( $page, $head );
			
			// trim rows
			$page= array_map( "trim", $page );
			
			// remove empty rows
			$page= array_filter( $page );

			foreach( $page as $item ) {
				
				// new key
				if( iskey($item) ) {
					if( bigger($item,$xkey) )
					  $key= $xkey= $item;
					else
					  $key= $xkey. $item;
					$par = null;
					continue;
				}
				
				// new parameter
				if( $p= par($item) ) {
					list( $par, $item )= $p;
					if( !$item )
					  continue;
				}
				
				// set value
				if( $key )
				  if( $par )
					$arr[ $key ][ $par ][]= $item;
				  else
					$arr[ $key ][]= $item;
				else
					$arr[]= $item;
			}
			
		}	
		return $arr;
	}


	// joins array
	function combine( $arr, $offs=0, $len=null ) {
		$arr= array_slice( $arr, $offs, $len );
		$arr= array_filter( $arr, "is_string" );
		return implode( " ", $arr );
	}
	
	
	// anyja neve
	function an( $str ) {
		preg_match( "@an.: ([A-z áéíóúöüőűÁÉÍÓÚÖÜŐŰ]+)@", $str, $match );
		return $match[1];
	}


	// search and map keys
	function search_key( $arr, $key, $map=0, ...$arg ) {
		
		$arr= array_filter( $arr, 
			function( $item ) use( $key ) {
			  return strpos( $item, $key ) === 0;
			}
		, ARRAY_FILTER_USE_KEY );
		
		if( $map )
		  $arr= array_map( $map, $arr, ...$arg );
		
		return $arr;
	}

	
	// callback
	function tev_map( $item, $fo=null ) {
		return [
		  $item[0],
		  combine( $item, 1, $fo ),
		  $fo,
		];
	}	


	// callback
	function user_map( $arr ) {
		return [
		  $arr[0],
		  an( $arr[1] ),
		  datef( $arr['Születési ideje'][0] ),
		];
	}


	// fix code
	function codef( $str ) {
		return trim( $str, "." );
	}
	
	
	// fix date
	function datef( $str ) {
		return str_replace( "/", "-", $str );
	}
	
	
	