<? 

	require "config.php";

	
	// get data
	$stmt= $DB->prepare("
		SELECT email, rovid, vezeto.nev, vezeto.szul, ceg.cim, alapitva, importalva
		FROM ceg
		  LEFT JOIN email ON email.ceg= ceg.id
		  LEFT JOIN vezeto ON vezeto.ceg= ceg.id
		WHERE importalva >= ?
		  AND importalva <= ?
		GROUP BY ceg.id
	");
	
	$stmt->execute([
		$post->min ?: date("Y-m-d"),
		$post->max ?: date("Y-m-d"),
	]);
	
	$data= $stmt->fetchAll( PDO::FETCH_ASSOC ) or die("404");
	$data= array_map( "data_map", $data );


	// brake it up for days
	$data= group_by( $data, "impdate" );
	$days= count( $data );

	// compress
	$zip= new_zip();	
	foreach( $data as $date => $group ) {
		$csv= get_csv( $group );
		$zip->addFromString( "$date.csv", $csv );
	}
	$zip= get_str( $zip );


	// output
	if( $days > 1 ) {
		header("Content-Type: application/zip");
		header("Content-Disposition: attachment; filename=\"mautic.zip\"");
		die( $zip );
	} else {
		header("Content-Type: text/csv");
		header("Content-Disposition: attachment; filename=\"$date.csv\"");
		die( $csv );
	}
	

	
	
	function data_map( $arr ) {
		extract( $arr );
		
		$pos= strrpos( $nev, " " );
		preg_match( "@(\d+) (.+), (.+)@", $cim, $cim );
	
		return [
		  'firstname' => substr( $nev, $pos+1 ),
		  'lastname' => substr( $nev, 0, $pos ),
		  'birthday' => $szul,
		  'email' => $email,
		  'companyemail' => $email,
		  'companyname' => $rovid,
		  'companycountry' => "Hungary",
		  'companyzipcode' => $cim[1],
		  'companycity' => $cim[2],
		  'companyaddress1' => $cim[3],
		  'timezone' => "Europe/Budapest",
		  'preferred_locale' => "hu_HU",
		  'regdate' => $alapitva,
		  'impdate' => $importalva,		
		];
	}

	
	function get_csv( $data ) {
		$fp= fopen( "php://memory", "w+" );
		
		$head= array_keys( $data[0] );
		  fputcsv( $fp, $head );
		
		foreach( $data as $row )
		  fputcsv( $fp, $row );
		  
		rewind( $fp );
		$csv= stream_get_contents( $fp );
		
		fclose( $fp );
		return $csv;
	}

	
	function group_by( $array, $key ) {
		foreach( $array as $item )
		  $out[ $item[$key] ][]= $item;
		return $out;
	}
	
	
	
	function new_zip() {
		$tmp= tmpfile();
		$uri= stream_get_meta_data( $tmp )['uri'];

		$zip= new ZipArchive;
		$zip->open( $uri, ZipArchive::CREATE );
		
		return $zip;
	}
	
	
	function get_str( $zip ) {
		$file= $zip->filename;
		
		$zip->close();
		$str= file_get_contents( $file );
		unlink( $file );
		
		return $str;
	}
	
	
	
	
