<?php


use WHMCS\Database\Capsule as DB;

include_once("aws.php");

	
class WC {


	static $error;
	
	
	function __construct() {
		$this->aws= new WC\AWS();
	}
	
	
	
	/////////////////////////
	//// ADMIN FUNCTIONS ////
	/////////////////////////
	
	
	// silent process
	function install( $hid, $tid ) {
		set_time_limit( 200 );

		$hst= $this->hosting_data( $hid, 1 ) or self::die("Access Denied");
		$tpl= $this->get_tpl( $tid ) or self::log("Template not Found");	
		$srv= $this->server_data( $hid ) or self::log("Server not Found");

		$this->aws->test_connection() or self::log("AWS connection failed");

		$this->connect( $hst->id, false ) or self::log("Could not connect to the database");
		$pass= $this->new_sql( $hst->username ) or self::log("Could not create database");

		$sql= $this->mysql_data( $hst->id );
		$yml= $this->yml( $tpl->image, $sql->host, $hst->username, $pass, $hst->domain );

		$this->new_stack( $srv, $hst->username, $yml ) or self::log("Failed to create stack");

		$uri = $this->aws->sql_uri( $tpl->sql );
		$dump= $this->download( $uri ) or self::log("Sql download error");
		$this->import_sql( $dump ) or self::log("Failed to import SQL");

		$this->api_template( $srv->ipaddress, $hst->username, $tpl->volume ) or self::log("Installer API Error");

		$this->aws->set_subdom( $hst->username, $srv->ipaddress ) or self::log("Failed to config subdomain");

		$this->set_cfv( $hst->id, $hst->packageid, "Template", $tpl->name );
		$this->set_cfv( $hst->id, $hst->packageid, "Yml", $yml );
		$this->import_res();

		return !self::$error;
	}
	
	
	// silent process
	function uninstall( $hid ) {
		
		$hst= $this->hosting_data( $hid, 1 ) or self::die("Access Denied");
		$srv= $this->server_data( $hid ) or self::log("Server not Found");
		
		$this->connect( $hst->id ) or self::log("Could not connect to the database");
		$this->del_sql( $hst->username ) or self::log("Could not delete database");
		
		$this->aws->set_subdom( $hst->username, $srv->ipaddress, "DELETE" ) or self::log("Failed to clear subdomain");
		
		$this->del_stack( $srv, $hst->username ) or self::log("Stack not found");	
		$this->del_cfv( $hst->id );

		return !self::$error;
	}



	//////////////////////////////
	//// LOCAL DATABASE FUNCS ////
	//////////////////////////////
	
	
	// add custom fields
	static function set_cfv( $host, $prod, $name, $value ) {
		$ml= substr_count( $value, "\n" );
		
		$id= DB::table("tblcustomfields")
		-> where( "type", "product" )
		-> where( "relid", $prod )
		-> where( "fieldname", $name )
		-> value( "id" )
		  ?:
		DB::table("tblcustomfields")
		-> insertGetId([
		  'type'      => "product",
		  'relid'     => $prod,
		  'fieldname' => $name,
		  'fieldtype' => $ml ? "textarea" : "text",
		  'adminonly' => "on",
		]);
		
		DB::table("tblcustomfieldsvalues")
		-> updateOrInsert([
		  'fieldid' => $id,
		  'relid'   => $host,
		],[
		  'value'   => $value,
		]);
	}
	
	
	// get custom field
	static function get_cfv( $host, $name="Template" ) {
	
		return DB::table("tblcustomfields AS n")
		-> join( "tblcustomfieldsvalues AS v", "v.fieldid", "n.id" )
		-> where( "v.relid", $host )
		-> where( "n.fieldname", $name )
		-> value( "value" );
	}


	// del custom fields
	static function del_cfv( $host ) {
		
		DB::table("tblcustomfieldsvalues")
		-> where( "relid", $host )
		-> delete();
	}

	
	// check access
	static function hosting_data( $hid, $admin=0 ) {
	  
		$hst= DB::table("tblhosting as h")
		-> join( "tblorders AS o", "o.id", "h.orderid" )
		-> join( "tblinvoices AS i", "i.id", "o.invoiceid" )
		-> where( "h.id", $hid )
		-> where( "i.status", "Paid" )
		-> select( "h.*" )
		-> first();

		$uid= WHMCS\Session::get("uid");
		if( $hst->userid==$uid || $admin )
		  return $hst;	
	}
	

	// template tags
	static function tag_list() {
		
		$arr= DB::select("
			SELECT
			  DISTINCT SUBSTRING_INDEX( SUBSTRING_INDEX( tags, ',' , n ), ',' , -1 ) AS tags
			FROM wc_templates JOIN
			  ( SELECT 1 n UNION ALL SELECT 2 UNION ALL SELECT 3 UNION ALL SELECT 4 UNION ALL SELECT 5 ) AS num
			  ON LENGTH(tags) - LENGTH( REPLACE( tags, ',' , '') ) >= n -1
			ORDER BY tags
		");		
		return array_column( $arr, "tags" );		
	}


	// template list
	static function tpl_list( $key=null, $active=1 ) {
		
		return DB::table("wc_templates")
		-> where( "id", $key )
		-> orWhere( "name", "like", "%$key%" )
		-> orWhere( "tags", "like", "%$key%" )
		-> having( "active", ">=", $active )
		-> get()
		-> toArray();
	}
	
	
	// get template data
	static function get_tpl( $id ) {
		
		return DB::table("wc_templates")
		-> where( "id", $id )
		-> first();
	}


	// plugin categs
	static function plu_categs() {
		
		$arr= DB::select("
			SELECT categ
			FROM wc_plugins
			GROUP BY categ 
		");
		return array_column( $arr, "categ" );
	}

	
	// plugin list
	static function plu_list( $active=1, $reo=0 ) {

		$query= DB::table("wc_plugins")
		-> where( "active", ">=", $active )
		-> orderBy( "categ" )
		-> orderBy( "recom", "desc" )
		-> orderBy( "name" );
		
		if( $reo )
		  $query= $query -> reorder( $reo );
		
		return $query -> get() -> toArray();
	}
	
	
	// get plugin data
	static function get_plu( $id ) {

		return DB::table("wc_plugins")
		-> where( "id", $id )
		-> first();
	}
	
	
	// get server data
	static function server_data( $hid ) {

		$srv= DB::table("tblhosting as h")
		-> join( "tblservers AS s", "s.id", "h.server" )
		-> where( "h.id", $hid )
		-> select( "s.secure", "s.hostname", "s.ipaddress", "s.port", "s.accesshash" )
		-> first();
		
		$srv->url= self::pUrl( $srv->ipaddress, $srv->port, $srv->secure );
		return $srv;
	}

	
	// portainer url
	static function pUrl( $url, $port, $sec ) {
		$port= $port ?: 9000;
		$prot= $sec ? "https" : "http";
		return "$prot://$url:$port";
	}
	
	
	// get mysql data
	function mysql_data( $hid ) {

		$srv= DB::table("tblhosting as h")
		-> join( "mysql_servers AS m", "m.id", "h.server" )
		-> where( "h.id", $hid )
		-> select( "m.host", "m.user", "m.pass", "h.username AS db" )
		-> first();
		
		$srv->pass= decrypt( $srv->pass );
		return $srv;
	}
	


	///////////////////////////////
	//// REMOTE DATABASE FUNCS ////
	///////////////////////////////
	
	
	// connect by hosting.id
	function connect( $hid, $select=1 ) {
		$d= $this->mysql_data( $hid );
		
		if( !$select )
		  $d->db= null;
	  
		return $this->connect_raw( $d->host, $d->user, $d->pass, $d->db );
	}
	

	// sql connect
	function connect_raw( $host, $username, $password, $database=null ) {
		
		$driver = "mysql";
		$charset= "utf8";
		$config = compact( "driver", "host", "database", "username", "password", "charset" );

		$capsule= new DB();
		$capsule->addConnection( $config );
		$this->db= $capsule->getConnection();

		try {
			$this->db->getPdo();
		} catch( Exception $e ) {
			return false;
		}
		
		if( class_exists("mysqli") )
		  $this->db->mysqli= new mysqli( $host, $username, $password, $database );
		
		return $this->db;
	}
	
	
	// check main WP tables
	function test_db() {
		$arr= $this->db->select("SHOW TABLES");
		$arr= array_map( "get_object_vars", $arr );
		$arr= array_map( "current", $arr );
		$arr= array_diff( ["wp_options","wp_posts","wp_terms","wp_users"], $arr );
		return !$arr;
	}
	
	
	// create db & user
	function new_sql( $name, $pass=null ) {

		$name= addslashes( $name );
		$pass= $pass ?: self::password( 24 );

		try {
			$this->db->unprepared("
			  CREATE DATABASE $name;
			  CREATE USER $name IDENTIFIED BY '$pass';
			  GRANT ALL PRIVILEGES ON $name.* TO $name;
			  USE $name;
			");
		} catch ( Exception $e ) {
			return false;
		}
		
		if( $this->db->mysqli )
			$this->db->mysqli->select_db( $name );
		
		return $pass;
	}
	
	
	// delete db & user
	function del_sql( $name ) {

		$name= addslashes( $name );
		
		try {
			$this->db->unprepared("
			  DROP USER IF EXISTS $name;
			  DROP DATABASE IF EXISTS $name;
			");
		} catch ( Exception $e ) {
			return false;
		}
		
		return true;
	}

	
	// import sql.gz
	function import_sql( $file ) {
		
		function_exists("gzfile")
		  or self::die("Zlib extension unavailable");

		$sql= gzfile( $file );
		$sql= implode( $sql );
		unlink( $file );

		// use mysqli if possible
		if( $this->db->mysqli )
			return $this->db->mysqli->multi_query( $sql )
			or self::log( $this->db->mysqli->error );
		
		// laravel (pdo) fallback
		try {
			$this->db->unprepared( $sql );
		} catch ( Exception $e ) {
			return false;
		}
		
		return true;
	}
	
	
	// import resoults
	function import_res() {
		
		// only for mysqli
		if( ! $sql= $this->db->mysqli )
		  return "?";
	  
		while( $sql->more_results() ) {
		  $sql->next_result();
		  $i+= $sql->affected_rows;
		  $e+= (int) $sql->error;
		}
		if( $e )
		  self::die("$e errors occurred during databse import");
		
		return $i;
	}
	
	
	// active plugin names (slug)
	function active_plugins() {

		if( ! $this->test_db() )
		  return [];
		
		$list= $this->db->table("wp_options")
		-> where( "option_name", "active_plugins" )
		-> value( "option_value" );
		
		$list= unserialize( $list );
		$list= array_map( "dirname", $list );

		return $list;
	}
	
	
	// set admin password
	function set_pass( $user, $pass ) {
		include_once("phpass.php");

		$hasher= new PasswordHash( 8, TRUE );
		$pass= $hasher->HashPassword( $pass );

		return $this->db->table("wp_users")
		-> where( "user_login", $user )
		-> update([
		  'user_pass' => $pass,
		]);
	}
	
	

	/////////////////////////
	//// PORTAINER FUNCS ////
	/////////////////////////
	
	
	static function new_stack( $srv, $name, $stackFileContent ) {
		
		$url= $srv->url ."/api/stacks?type=2&method=string&endpointId=2";
		
		$post= compact( "name", "stackFileContent" );
		$ret= self::port_request( $url, $srv->accesshash, "POST", $post );

		return $ret->Id;
	}
	
	
	static function get_stack( $srv, $name, $col=null ) {
	
		$url= $srv->url ."/api/stacks?endpointId=2";
		
		$ret= self::port_request( $url, $srv->accesshash, "GET" );
		$arr= @ array_column( $ret, $col, "Name" );
		
		return $arr[ $name ];
	}
	
	
	static function del_stack( $srv, $name ) {

		$id= self::get_stack( $srv, $name, "Id" );
		if( !$id )
		  return false;
		
		$url= $srv->url ."/api/stacks/$id?endpointId=2";
		$ret= self::port_request( $url, $srv->accesshash, "DELETE" );
		
		return $ret;
	}
	
	
	static function res_stack( $srv, $name, $stop=0 ) {

		$id= self::get_stack( $srv, $name, "Id" );
		if( !$id )
		  return false;

		$url= $srv->url ."/api/stacks/$id/stop?endpointId=2";
		$ret= self::port_request( $url, $srv->accesshash, "POST" );
		
		if( $stop )
		  return true;
	  
		$url= $srv->url ."/api/stacks/$id/start?endpointId=2";
		$ret= self::port_request( $url, $srv->accesshash, "POST" );
	  
		return $ret;
	}
	

	static function port_request( $url, $key, $method="GET", $post=null ) {
		
		$head=[
		  "X-API-Key: $key",
		  "Content-Type: application/json" 
		];
		$post= json_encode( $post );

		$opt= [
		  CURLOPT_RETURNTRANSFER => true,
		  CURLOPT_SSL_VERIFYPEER => false,
		  CURLOPT_FOLLOWLOCATION => false,
		  CURLOPT_CONNECTTIMEOUT => 10,
		  CURLOPT_HTTPHEADER     => $head,
		  CURLOPT_POSTFIELDS     => $post,
		  CURLOPT_CUSTOMREQUEST  => $method,
		];

		$ch= curl_init( $url );
		curl_setopt_array( $ch, $opt );

		$json= curl_exec( $ch );
		$code= curl_getinfo( $ch, CURLINFO_HTTP_CODE );
		curl_close( $ch );

		$json= json_decode( $json );
		if( $json===null )
		  return self::log("Portainer error: $code");
		
		if( $json->message  )
		  return self::log( $json->message );
		
		return $json;
	}
	
	
	// generate yaml	
	static function yml( $image, $sql, $name, $pass, $domain ) {
		$domain= $domain ?: "-";
		
		$yml= self::dir("templates/wc.yml");
		$yml= file_get_contents( $yml );
		foreach( get_defined_vars() as $n=>$v )
		  $yml= str_replace( "$$n", $v, $yml );
		
		return $yml;
	}

	
	
	//// API FUNCS ////
	
	// install volume
	static function api_template( $ip, $name, $template ) {
		$post= compact( "name", "template" );
		return self::api_request( $ip, $post, 5000 );
	}
	
	
	// installer api
	static function api_request( $url, $post=null, $port=null ) {
		$post= http_build_query( $post );

		$opt= [
		  CURLOPT_RETURNTRANSFER => true,
		  CURLOPT_SSL_VERIFYPEER => false,
		  CURLOPT_SSL_VERIFYHOST => 0,
		  CURLOPT_FOLLOWLOCATION => true,
		  CURLOPT_CONNECTTIMEOUT => 10,
		  CURLOPT_POSTFIELDS     => $post,
		  CURLOPT_PORT           => $port,
		];

		$ch= curl_init( $url );
		curl_setopt_array( $ch, $opt );

		$err = curl_exec( $ch );
		$code= curl_getinfo( $ch, CURLINFO_HTTP_CODE );
		curl_close( $ch );
		
		if( $code != 200 )
		  return self::log("API error: $code");
		
		if( $err )
		  return self::log( $err );
	  
		return true;
	}
	
	
	
	/////////////////////
	//// OTHER FUNCS ////
	/////////////////////
	
	
	// random base58 string
	static function password( $len=16 ) {
		$b58= "123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz";
		while( strlen( $pass ) < $len )
		  $pass.= $b58[ random_int( 0,57 ) ];
		return $pass;
	}
	
	
	// new temp file
	static function download( $url ) {
		$tmp= tempnam( "temp", "" );
		$ok= copy( $url, $tmp );
		return $ok ? $tmp : false;
	}
	
	
	// file path for module [sub]directory
	static function dir( $dir="" ) {
		$path = __DIR__;
		return $dir ? "$path/$dir" : $path;
	}
	
	
	// url path for module [sub]directory
	static function path( $dir="" ) {
		$path = $dir[0]=="/" ? $dir : self::dir( $dir );
		return strstr( $path, "/modules" );
	}
	
	
	// url path for image
	static function image( $sub, $id ) {
		$dir= self::dir("images/$sub");
		$img= glob("$dir/$id.*")[0];
		if( $img )
		  return self::path( $img );
	}
	

	// extend Lang catalogue
	static function lang_init() {
		global $_LANG;

		$name= WHMCS\Session::get("Language") ?: "english";
		$file= __DIR__ ."/lang/$name.php";
		
		if( is_file($file) )
		  Lang::addResource( "whmcs", $file, $name );
	  
		$_LANG= Lang::toArray();
	}
	
	
	// log error
	static function log( $msg ) {
		self::$error[]= $msg;
		
		extract( $_SERVER, EXTR_SKIP );
		$GET= $_GET;
		$POST= $_POST;
		
		$date= date("Y-m-d h:i:s");
		$user= WHMCS\Session::get("uid");
		$traceback= array_slice( debug_backtrace(), 1 );
		$arr= compact( "msg", "date", "user", "REMOTE_ADDR", "REQUEST_URI", "HTTP_REFERER", "GET", "POST", "traceback" );

		$dir = self::dir("log");
		$msg = substr( $msg, 0, 40 );
		$time= time();
		$json= json_encode( $arr, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT );
		file_put_contents( "$dir/$msg.$time", $json ); 

		return false;
	}
	
	
	// die with http code
	static function die( $msg, $code=500 ) {
		self::log( $msg );
		http_response_code( $code );
		die( $msg );
	}
	
	
	
}

