<?php


namespace WC;


class AWS extends \Aws\Sdk {

	
	
	// AWS config
	protected const conf=[
		'version' => "latest",
		'region'  => "eu-central-2",
		'credentials' => [
			'key'    => "AKIASYTRA6IFEPLLIBG4",
			'secret' => "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",
		],
	];
	
	
	// Route 53 config
	protected const HostedZoneId= "Z0129284252IB7TLT57KI";
	
	protected const reservedDomain= [
		"teszt.redratshop.io.",
	];

	const domainName= "redratshop.io";
	
	
	// S3 config
	protected const bucketName= "redratio-ch-s3";
	
	static function sql_uri( $name ) {
		return "s3://redratio-ch-s3/template/$name/database.sql.gz";
	}

	

	// Code starts here
	function __construct() {
		parent::__construct( self::conf );
		$this -> createS3() -> registerStreamWrapper();
	}
	
	
	// Test AWS connection
	function test_connection() {
		return $this->init();
	}
	
	
	// cache list
	function init() {
		$this->domain_list= $this->domain_list();
		return !! $this->domain_list;
	}
	

	// List bucket
	function s3_list( $dir="", $token=null ) {
	
		if( $dir )
		  $dir.= "/";
	
		// request
		$list= $this -> createS3() -> listObjectsV2([
			'Bucket' => self::bucketName,
			'Prefix' => $dir,
			'Delimiter' => "/",
			'ContinuationToken' => $token,
		]);

		// return foders only
		if( $arr= $list['CommonPrefixes'] ) {
			$arr= array_column( $arr, "Prefix" );
			$arr= array_map( "basename", $arr );
			return $arr;
		}

		// return file info
		if( $arr= $list['Contents'] ) {
			array_shift( $arr );
			$arr= array_map( "self::s3_info", $arr );
		}
		
		// more resoults
		if( $nt= $list['NextContinuationToken'] ) {
			$more= $this -> s3_list( $dir, $nt );
			$arr= array_merge( $arr, $more );
		}
		
		return $arr;
	}
	
	
	// Array mapping
	static function s3_info( $arr ) {
		extract( $arr );
		return [
			'name' => basename( $Key ),
			'size' => $Size,
			'date' => substr( $LastModified, 0, 10 ),
			'time' => strtotime( $LastModified ),
		];
	}
	
	
	// Download
	function s3_get( $url, $as=null ) {
		
		// request
		$res= $this -> createS3() -> getObject([
			'Bucket' => self::bucketName,
			'Key'    => $url,
			'SaveAs' => $as,
		]);
		
		return $as ?: (string) $res['Body'];
	}
	
	
	
	// Full domain list
	function domain_list() {
		
		$args= [
			'HostedZoneId' => self::HostedZoneId,
		];

		try {
			$result= $this->createRoute53()->listResourceRecordSets( $args );
		} catch( \Exception $e ) {
			return false;
		}
		
		$list= array_column( $result['ResourceRecordSets'], "Name" );
		return $list;
	}
	
	
	// Walk function
	static function drop_suffix( &$name, $key, $suffix ) {
		$name= basename( $name, $suffix );		
	}
	
	
	// Is it in use?	
	function domain_check( $name ) {
		$this->domain_list or $this->init();
		$list= array_merge( self::reservedDomain, $this->domain_list );
		return in_array( $name, $list );
	}
	
	
	// Add subdomain
	function set_subdom( $name, $ip, $act="CREATE" ) {
		$name= self::subdom( $name );
		
		$inuse= $this->domain_check( $name );
		if( $inuse )
			\WC::log("$name is in use or reserved");

		$ChangeBatch= [
			'Comment' => "Add subdomain",
			'Changes' => [[
				'Action' => $act,
				'ResourceRecordSet' => [
					'Name' => $name,
					'Type' => "A",
					'TTL'  => 300,
					'ResourceRecords' => [[
						'Value' => $ip
					]]
				]
			]]
		];
		
		$args= [
			'HostedZoneId' => self::HostedZoneId,
			'ChangeBatch'  => $ChangeBatch,
		];
		
		try {
			$this->createRoute53()->changeResourceRecordSets( $args );
		} catch( \Exception $e ) {
			return false;
		}
		
		return true;
	}
	
	
	// Return subdomain
	static function subdom( $sub ) {
		$domain= self::domainName;
		return "$sub.$domain";
	}
	
	
	
}




