<?php
use WHMCS\Database\Capsule;
function spanel_MetaData()
{
    return array( "DisplayName" => "SPanel", "APIVersion" => "1.2");
}

function spanel_ConfigOptions()
{
    return [
        "package" => [
            "FriendlyName" => "Select Package",
            "Type" => "text",
            "Loader" => "spanel_loadPackages",
			'SimpleMode' => true
        ],
    ];
}

function spanel_loadPackages($params){
	$postData = [
	  'action' => 'accounts/listpackages',
	];
	$responses = spanel_curl($postData, $params);
	if( !$responses['data'] ){ throw new Exception( $responses['message'] ); }
	$packages = [];
	foreach( $responses['data'] as $package ){
		$packages[$package['packagename']] = ucfirst($package['packagename']);
	}
	return $packages;
}

function spanel_curl($postData, $params = [])
{

	if( !$params ){
		$server = Capsule::table('tblservers')->where('type','spanel')->where('active', '1')->first();
		$params = [
			'serverhostname' => $server->hostname,
			'serverip' => $server->ipaddress,
			'serverusername' => $server->username,
			'serveraccesshash' => $server->accesshash,
			'serverhttpprefix' => ( $server->secure == 'on' ? 'https' : 'http' )
		];
	}

	$postData['token'] = $params['serveraccesshash'];

	// when secure is enabled, check if the hostname resolves and use the hostname. If the hostname doesnt resolve, fallback to http, as curl cant connect because of the SSL warning.

	$hostname = $params['serverip'];
	if( $params['serverhttpprefix'] == 'https' ){
		$hostnameIP = gethostbyname($params['serverhostname']);
		if( $hostnameIP == $params['serverip'] ){
			$hostname = $params['serverhostname'];
		}else{
			$params['serverhttpprefix'] = 'http';
			logModuleCall('spanel', 'warning', 'API connection reverted to HTTP instead of HTTPS', 'Reported hostname IP is '.$hostnameIP);
		}
	}

	$endpointUrl = $params['serverhttpprefix'].'://'.$hostname.'/'.$params['serverusername'].'/api.php';
	$ch = curl_init();
	curl_setopt( $ch, CURLOPT_URL, $endpointUrl);
	curl_setopt( $ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt( $ch, CURLOPT_POST, true);
	curl_setopt( $ch, CURLOPT_POSTFIELDS, http_build_query($postData));
	curl_setopt( $ch, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt( $ch, CURLOPT_SSL_VERIFYHOST, false);
	curl_setopt( $ch, CURLOPT_CONNECTTIMEOUT, 10);
	curl_setopt( $ch, CURLOPT_TIMEOUT, 120);
	curl_setopt( $ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1); // fallback to http 1.1 due to issues with http2 communication with some web servers
	$jsonOutput = curl_exec( $ch );
	$error = trim(curl_error($ch));

	$supportedErrors = [
		'HTTP/2 stream 0 was not closed cleanly: PROTOCOL_ERROR (err 1)',
		'Peer reports incompatible or unsupported protocol version.'
	];

	// http/2 fix.
	if( $error ){
		logModuleCall('spanel', $postData['action'], "Error:\n".$error, "CURL raw output:\n".$jsonOutput);
		if( in_array($error, $supportedErrors) ){
			switch($error){
				case $supportedErrors[0]:
					curl_setopt( $ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
					break;
				case $supportedErrors[1]:
					curl_setopt( $ch, CURLOPT_SSLVERSION, 7);
					break;
			}
			$jsonOutput = curl_exec( $ch );
			$error = trim(curl_error($ch));
		}
	}

	$output = json_decode($jsonOutput,true);
	$response = ( $error && !is_array($output) ? [ 'message' => $error ] : $output );

	curl_close($ch);
	logModuleCall('spanel', $postData['action'], [ $endpointUrl, $postData ], $jsonOutput, $response , [ $postData['token'] ]);
    return $response;
}

function spanel_prepareErrors( $errors ){
	return ( is_array($errors) ? implode(', ', $errors) : $errors );
}

function spanel_CreateAccount($params)
{
    $postData = [
      'action' => 'accounts/wwwacct',
      'domain' => $params['domain'],
      'username' => $params['username'],
      'password' => $params['password'],
      'package' => $params['configoption1'],
    ];
    $response = spanel_curl($postData,$params);
	return ( $response['result'] == 'success' ? 'success' : spanel_prepareErrors($response['message']) );
}

function spanel_TerminateAccount($params)
{
    $postData = [
      'action' => 'accounts/terminateaccount',
      'username' => $params['username'],
    ];
    $response = spanel_curl($postData,$params);
	return ( $response['result'] == 'success' ? 'success' : spanel_prepareErrors($response['message']) );
}

function spanel_SuspendAccount($params)
{
    $postData = [
      'action' => 'accounts/suspendaccount',
      'username' => $params['username'],
      'reason' => $params['suspendreason']
    ];
    $response = spanel_curl($postData,$params);
	return ( $response['result'] == 'success' ? 'success' : spanel_prepareErrors($response['message']) );
}

function spanel_UnsuspendAccount($params)
{
    $postData = [
      'action' => 'accounts/unsuspendaccount',
      'username' => $params['username'],
    ];
    $response = spanel_curl($postData,$params);
	return ( $response['result'] == 'success' ? 'success' : spanel_prepareErrors($response['message']) );
}


function spanel_ChangePackage(array $params)
{
    $postData = [
      'action' => 'accounts/changequota',
      'username' => $params['username'],
      'packages' => $params['configoption1'],
    ];
    $response = spanel_curl($postData,$params);
	return ( $response['result'] == 'success' ? 'success' : spanel_prepareErrors($response['message']) );
}

function spanel_ChangePassword(array $params)
{
    $postData = [
      'action' => 'accounts/changeuserpassword',
      'username' => $params['username'],
      'password' => $params['password'],
    ];
    $response = spanel_curl($postData,$params);
	return ( $response['result'] == 'success' ? 'success' : spanel_prepareErrors($response['message']) );
}

function spanel_TestConnection($params)
{
	$postData = [
		'action' => 'toolbox/apicheck',
	];
	$response = spanel_curl($postData,$params);
	return [ 'success' => ( $response['result'] == 'success' ), 'error' => spanel_prepareErrors($response['message']) ];
}

?>