<?php

	use WHMCS\Database\Capsule as DB;
	
	if( !defined("WHMCS") )
	  die("This file cannot be accessed directly");
	
	include("funcs.php");
	

	// module config
	function ppack_MetaData() {
		return [
		  "DisplayName" => "PluginPack",
		  "APIVersion" => "0.9",
		  "RequiresServer" => true,
		  "AutoGenerateUsernameAndPassword" => false,
		];
	}
	
	
	// hellopack link
	function ppack_AdminLink( $params ) {
		extract( $params );
		$url= PP::listUrl;
		return "<a href='$url' target='hp'> Api Creator </a>";
	}
	
	
	// product page hook
	function ppack_ClientArea( $params ) {
		extract( $params );
		
		$templatefile= "clientarea";
		$assets= PP::path("assets");
		
		$domain= $customfields['Domain'];
		$key= $customfields['API Key'];
		
		$dl= (array) $templatevars['downloads'][0];
		
		$vars= compact( "assets", "domain", "key", "dl" );
		return compact( "templatefile", "vars" );
	}
	
	
	// new service hook
	function ppack_CreateAccount( $params ) {
		extract( $params );
		
		$pp= new PP( $serverid );
		
		$key= $pp->add( $customfields['Domain'] );
		$pp->set_cfv( $serviceid, $packageid, "API Key", $key );
		
		return true;
	}
	
	
	// invoice long overdue
	function ppack_TerminateAccount( $params ) {
		extract( $params );
		
		$pp= new PP( $serverid );
		
		$key= $pp->del( $customfields['Domain'] );
		$pp->set_cfv( $serviceid, $packageid, "API Key" );
		
		return true;
	}
	
	
	// invoice overdue hook
	function ppack_SuspendAccount( $params ) {
		return ppack_TerminateAccount( $params );
	}


	// restart service
	function ppack_UnsuspendAccount( $params ) {
		return ppack_CreateAccount( $params );
	}
	
	
	// server config test
	function ppack_TestConnection( $params ) {
		extract( $params );
		extract( $_POST );
		
		$pp= new PP( $serverid );
		
		$pp->user= $username;		
		if( $password[0] != "*" )
		  $pp->pass= $password;

		$pp->test();
		
		$success= ! PP::$error;
		$error= PP::$error[0];
		
		return compact( "success", "error" );
	}
	
	
	
	// extend Lang catalogue
	PP::lang_init();
	
	
	// Dev-Only
	include_once ROOTDIR ."/includes/modulefunctions.php";
	rebuildModuleHookCache();
	
