<?php


use WHMCS\Database\Capsule as DB;

	
class PP {


	// make sure access is restricted!
	const cfile= __DIR__ ."/cookies";
	
	// web endpoints
	const loginUrl= "https://hellowp.io/hu/helloconsole/";
	const listUrl = "https://hellowp.io/hu/helloconsole/hellopack-kozpont/api-creator/";
	const addUrl  = "https://hellowp.io/hu/wp-json/ws-form/v1/submit";

	// local error log
	static $error= array();
	
	
	// main init
	function __construct( $id ) {
		
		// get username & pass
		$this->server_data( $id );
	}
	
	
	
	//////////////////////////////
	//// LOCAL DATABASE FUNCS ////
	//////////////////////////////
	
	
	// get server data
	function server_data( $id ) {

		$srv= DB::table("tblservers")
		-> where( "id", $id )
		-> first();
		
		$this->user= $srv->username;
		$this->pass= decrypt( $srv->password );
		
		return $srv;
	}
	
	
	// add custom fields
	static function set_cfv( $host, $prod, $name, $value="" ) {
		$ml= substr_count( $value, "\n" );
		
		$id= DB::table("tblcustomfields")
		-> where( "type", "product" )
		-> where( "relid", $prod )
		-> where( "fieldname", $name )
		-> value( "id" )
		  ?:
		DB::table("tblcustomfields")
		-> insertGetId([
		  'type'      => "product",
		  'relid'     => $prod,
		  'fieldname' => $name,
		  'fieldtype' => $ml ? "textarea" : "text",
		]);
		
		DB::table("tblcustomfieldsvalues")
		-> updateOrInsert([
		  'fieldid' => $id,
		  'relid'   => $host,
		],[
		  'value'   => $value,
		]);
	}
	
	
	
	/////////////////////////
	//// HELLOPACK FUNCS ////
	/////////////////////////

	
	// curl request
	function login( $nonce ) {
		
		$url= PP::loginUrl;
		$ref= parse_url( PP::listUrl, PHP_URL_PATH );
		
		$post= [
		  'username' => $this->user,
		  'password' => $this->pass,
		  'woocommerce-login-nonce' => $nonce,
		  '_wp_http_referer' => $ref,
		  'rememberme' => "forever",
		  'login' => "Bejelentkezés",
		];

		$opt= [
		  CURLOPT_RETURNTRANSFER => true,
		  CURLOPT_SSL_VERIFYPEER => false,
		  CURLOPT_SSL_VERIFYHOST => 0,
		  CURLOPT_FOLLOWLOCATION => true,
		  CURLOPT_CONNECTTIMEOUT => 20,
		  CURLOPT_POSTFIELDS     => http_build_query( $post ),
		  CURLOPT_COOKIEJAR      => PP::cfile,
		];

		$ch= curl_init( $url );
		curl_setopt_array( $ch, $opt );
		
		$html= curl_exec( $ch );

		$redir= curl_getinfo( $ch, CURLINFO_EFFECTIVE_URL );
		if( $redir == $url )
		  $this->log("Login Error");
	  
		curl_close( $ch );
		return $html;
	}
	
	
	// curl request
	function test() {
		// logout
		@ unlink( PP::cfile );
		
		$arr= $this->list( "", 1 );	
		return $arr;
	}
	
	
	// curl request
	function post( $url, $post=null ) {

		$opt= [
		  CURLOPT_RETURNTRANSFER => true,
		  CURLOPT_SSL_VERIFYPEER => false,
		  CURLOPT_SSL_VERIFYHOST => 0,
		  CURLOPT_FOLLOWLOCATION => false,
		  CURLOPT_CONNECTTIMEOUT => 10,
		  CURLOPT_POSTFIELDS     => $post,
		  CURLOPT_COOKIEFILE     => PP::cfile,
		];

		$ch= curl_init( $url );
		curl_setopt_array( $ch, $opt );

		$html= curl_exec( $ch );
		
		$code= curl_getinfo( $ch, CURLINFO_HTTP_CODE );
		if( $code<200 || $code>399 )
		  $this->log("Request error ($code)");
	  
		curl_close( $ch );
		return $html;
	}
	

	function list( $search, $all=0 ) {
	
		$url = PP::listUrl;
		$url.= "?per_page=100&search=" . urlencode( $search );
		
		// download
		$html= $this->post( $url );
		
		// parse html
		$doc= new DOMDocument();
		$doc->loadHTML( $html ) or $this->log("Html error");

		// Need to login?
		$login= $doc->getElementById("woocommerce-login-nonce");
		if( $login ) {
		  $nonce= $login->getAttribute("value");
		  $html= $this->login( $nonce );
		  $doc->loadHTML( $html ) or $this->log("Html error");
		}
		
		if( PP::$error )
		  return false;
		
		// parse script
		$script= $doc->getElementById("ws-form-form-common-js-extra") or $this->log("Form data not found");

		preg_match( "/var ws_form_settings = (.+);/is", $script->textContent, $js );
		$json= json_decode( $js[1] ) or $this->log("Nonce not found");
		
		if( PP::$error )
		  return false;

		$this->wsfn= $json->wsf_nonce;
		$this->xwpn= $json->x_wp_nonce;
		
		// parse list
		$tbl= $doc->getElementsByTagName("tbody")[0];
		$tr= PP::childNodes( $tbl );
		
		$list= array_map( [$this,"rowmap"], $tr );
		$list= array_column( $list, null, "domain" );
		
		return $all ? $list : $list[ $search ];
	}
	

	// parse list row
	function rowmap( $tr ) {
		$td= PP::childNodes( $tr );
		
		if( $td[7] == null )
		  return array();
		
		$arr= [
		  'id'     => $td[0]->textContent,
		  'domain' => $td[1]->textContent,
		  'date'   => $td[2]->textContent,
		  'expire' => $td[3]->textContent,
		  'lastuse' => $td[4]->textContent,
		  'key' => PP::firstChild( $td[5] ) -> getAttribute("data-clipboard-text"),
		  'status' => $td[6]->textContent,
		  'del' => PP::firstChild( $td[7] ) -> getAttribute("href"),
		];
		
		return array_map( "trim", $arr );
	}
	
	
	static function childNodes( $obj ) {
		foreach( $obj->childNodes as $node )
		  if( $node->nodeType == XML_ELEMENT_NODE )
			$arr[]= $node;		
		return $arr;
	}
	
	static function firstChild( $obj ) {
		return PP::childNodes( $obj )[0];
	}
	
	
	function add( $domain, $key="" ) {
		
		$list= $this->list( $domain );
		if( $list )
		  return $list['key'];
		
		// generate key
		if( !$key )
		  $key= bin2hex( random_bytes(21) );
		
		$this->post( PP::addUrl, [
			'field_431' => $domain,
			'field_432' => $key,
			'field_441' => ["Mindhez"],
			'wsf_form_id' => 31,
			'wsf_post_id' => 539,
			'wsf_post_mode' => "submit",
			'wsf_nonce' => $this->wsfn,
			'_wpnonce' => $this->xwpn,
		] );
		
		return $key;
	}
	
	
	function del( $domain ) {
		
		$list= $this->list( $domain );
		if( $list )
		  $this->post( $list['del'] );
	}
	
	
	
	/////////////////////
	//// OTHER FUNCS ////
	/////////////////////
	
	
	// file path for module [sub]directory
	static function dir( $dir="" ) {
		$path = __DIR__;
		return $dir ? "$path/$dir" : $path;
	}
	
	
	// url path for module [sub]directory
	static function path( $dir="" ) {
		$path = $dir[0]=="/" ? $dir : self::dir( $dir );
		return strstr( $path, "/modules" );
	}
	
	
	// log error
	static function log( $msg ) {
		self::$error[]= $msg;
		
		extract( $_SERVER, EXTR_SKIP );
		$GET= $_GET;
		$POST= $_POST;
		
		$date= date("Y-m-d h:i:s");
		$user= WHMCS\Session::get("uid");
		$traceback= array_slice( debug_backtrace(), 1 );
		$arr= compact( "msg", "date", "user", "REMOTE_ADDR", "REQUEST_URI", "HTTP_REFERER", "GET", "POST", "traceback" );

		$dir = self::dir("log");
		$msg = substr( $msg, 0, 40 );
		$time= time();
		$json= json_encode( $arr, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT );
		file_put_contents( "$dir/$msg.$time", $json ); 

		return false;
	}
	
	
	// die with http code
	static function die( $msg, $code=500 ) {
		self::log( $msg );
		http_response_code( $code );
		die( $msg );
	}	
	
	
	// extend Lang catalogue
	static function lang_init() {
		global $_LANG;

		$name= WHMCS\Session::get("Language") ?: "english";
		$file= __DIR__ ."/lang/$name.php";
		
		if( is_file($file) )
		  Lang::addResource( "whmcs", $file, $name );
	  
		$_LANG= Lang::toArray();
	}
	
	
}

