<?php


	use WHMCS\Database\Capsule as DB;

	if( !defined("WHMCS") )
		die("This file cannot be accessed directly");
	
	

	// Define module related meta data.
	function chbc_config() {
		return [
			"name" => "Change Billing Cycle",
			"description" => "Option for the user to change the billing cycle",
			"version" => "0.1",
			"author" => "Richárd",
		];
	}
	
	
	function chbc_trans( $text ) {
		global $_LANG;
		return $_LANG['chbc'][ $text ];
	}
	
	
	// client page
	function chbc_clientarea( $vars ) {
		
		include_once ROOTDIR. "/includes/clientfunctions.php";
		
		// find data
		$id= $_GET['id'];
		$service= WHMCS\Service\Service::find( $id );
		$product= WHMCS\Product\Product::find( $service->packageid );
		
		// test access
		$uid= WHMCS\Session::get("uid");
		if( $uid != $service->clientId )
		  redir( "", "clientarea.php" );

		// change cycle
		$cycle= $_POST['cycle'];
		if( $cycle )
		  chbc_set( $service, $cycle );

		// get offers
		$cycles= [ "Monthly", "Quarterly", "Semi-Annually", "Annually", "Biennially", "Triennially"	];
		foreach( $cycles as $cycle )
		  $offer[]= chbc_offer( $service, $cycle );

		// collect vars
		$offer= array_filter( $offer );
		$rdate= fromMySQLDate( $service->regdate, 0, 1 );
		$ddate= fromMySQLDate( $service->nextduedate, 0, 1 );

		$assets= chbc_path("assets");
		$vars= compact( "service", "product", "offer", "rdate", "ddate", "assets" );
	
		// display tpl
		return [
			'requirelogin' => true,
			'pagetitle' => Lang::trans("chbc.title"),
			'breadcrumb' => [
				'clientarea.php?action=products' => Lang::trans("clientareaproducts"),
				'clientarea.php?action=productdetails&id='.$id => $product->name,
				'#' => Lang::trans("chbc.title"),
			],
			'templatefile' => 'setup',
			'vars' => $vars,
		];	 
	}
	
	
	// get offer data
	function chbc_offer( $service, $cycle ) {
	
		// check if coupon is valid
		$promo= chbc_promo( $service->promoid, $cycle );
		
		// recalculate
		$price= recalcRecurringProductPrice( $service->id, $service->userid, $service->packageid, $cycle, "empty", $promo->id );
		
		// not valid
		if( $price==0 )
		  return;
		
		// is active
		$checked= $cycle == $service->billingcycle ? "CHECKED" : null;
		
		return compact( "cycle", "price", "promo", "checked" );
	}	
	
	
	// check if coupon is valid
	function chbc_promo( $id, $cycle ) {
		
		return DB::table("tblpromotions")
		-> where( "id", $id )
		-> where( "recurring", 1 )
		-> whereRaw(" 
		  find_in_set( '$cycle', cycles ) 
		")
		-> first();
	}


	// change cycle
	function chbc_set( $service, $cycle ) {
	
		$offer= chbc_offer( $service, $cycle );
		extract( $offer );
		
		if( $price==0 )
		  return;
		  
		// Update the service
		DB::table("tblhosting")
		-> where( "id", $service->id )
		-> update([
			'billingcycle' => $cycle,
			'amount'       => $price,
			'promoid'      => $promo->id,
		]);
		
		redir( "action=services", "clientarea.php" );		
	}
	

	// path for module directory
	function chbc_path( $dir="" ) {
		$path= __DIR__;
		$path= $dir ? "$path/$dir" : $path;
		return strstr( $path, "/modules" );
	}
	
	
	
