<?php

	use WHMCS\Database\Capsule;


	if( !defined('WHMCS') )
		die('You cannot access this file directly.');



	function red_user( $arr ) {
		$user= red_user_data( $arr );
		red_curl( compact("user") );
	}

	add_hook( "UserAdd", 1, "red_user" );
	add_hook( "UserEdit", 1, "red_user" );
	add_hook( "UserChangePassword", 1, "red_user" );



	function red_orders_old( $vars ) {
		extract( $vars );
		
		$arr= localAPI( "GetOrders", [
			'id' => $orderid,
			'userid' => $userid,
			'limitnum' => 0,			
		] );
		
		$order= array_map( "red_order_data", $arr['orders']['order'] );
		$order= array_merge( ...$order );
		
		red_curl( compact("order") );
	}
	
	
	function red_orders( $vars ) {
		extract( $vars );

		$query= Capsule::table("tblorders AS o")
		  -> join( "tblhosting AS h", "h.orderid", "=", "o.id" )
		  -> join( "tblinvoices AS i", "i.id", "=", "o.invoiceid" )
		  -> join( "tblusers_clients AS u", "u.client_id", "=", "o.userid" )
		  -> select( "h.id", "auth_user_id AS user", "packageid AS app", "domain", "regdate AS date1", "nextduedate AS date2", "domainstatus AS state" )
		  -> selectRaw( "i.status = 'Paid' AS active" );
		  
		if( $serviceid )
		  $query -> where( "h.id", "=", $serviceid );
	  
		if( $orderid )
		  $query -> where( "o.id", "=", $orderid );
		  
		$order= $query -> get() -> toArray();
		red_curl( compact("order") );
	}	

	add_hook( "ShoppingCartCheckoutCompletePage", 1, "red_orders" );
	add_hook( "DailyCronJob", 1, "red_orders" );
	add_hook( "ServiceEdit", 1, "red_orders" );
	
	
	
	// data mapping
	function red_user_data( $user ) {
		extract( $user );
		return [
		  'id'    => $user_id ?: $userid,
		  'user'  => $lastname,
		  'pass'  => $password,
		  'name'  => $firstname ? "$firstname $lastname" : null,
		  'email' => $email,
		];
	}
	

	// data mapping	
	function red_order_data( $order ) {
		extract( $order );
		
		foreach( $lineitems['lineitem'] as $item ) {
			extract( $item );
			
			if( $type != "product" )
			  continue;
		  
			$out[]= [
			  'id'     => $relid,
			  'user'   => $userid,
			  'app'    => red_product_id( $product ),
			  'domain' => $domain,
			  'date'   => $date,
			  'cycle'  => $billingcycle,
			  'state'  => $status,
			  'active' => $paymentstatus=="Paid",
			];
		}		
		return $out;
	}
	
	
	// get Id by Name
	function red_product_id( $name ) {
		global $product_array;
		
		if( !$product_array ) {
			$arr= localAPI( "GetProducts" );
			$product_array= array_column( $arr['products']['product'], "pid", "name" );
		}
		
		$name= explode( " - ", $name, 2 )[ 1 ];
		return $product_array[ $name ];
	}


	// send post
	function red_curl( $post=null ) {
		$url = "https://dashboard.redrat.io/whmcs/";
		$post= http_build_query( $post );

		$opt= [
		  CURLOPT_RETURNTRANSFER => true,
		  CURLOPT_SSL_VERIFYPEER => false,
		  CURLOPT_SSL_VERIFYHOST => 0,
		  CURLOPT_FOLLOWLOCATION => true,
		  CURLOPT_CONNECTTIMEOUT => 10,
		  CURLOPT_POSTFIELDS     => $post,
		];

		$ch= curl_init( $url );
		curl_setopt_array( $ch, $opt );

		$err= curl_exec( $ch );
		if( $err )
		  die( $err );
		
		curl_close( $ch );
	}

	
	
	