<?php


use WHMCS\Carbon;
use WHMCS\Database\Capsule;


function free_trial_for_product($vars) {

    $promoCode = 'FREETRIAL'; // The exact promo code that you use for the free trial (must be 100% and best to be only applicable to the relevant products and set to one time use per client and order)

	# Grab order details and a list of related services
    $orderDetails = Capsule::table('tblorders')->where('id', $vars['orderid'])->first();
    $services = Capsule::table('tblhosting')->where('orderid', $orderDetails->id)->get();

	# Loop through each service
    foreach( $services as $service ) {

		# Only run the code below if the code matches the one specified above
		if( $orderDetails->promocode == $promoCode ) {

			# Grab the pricing for the product
			$getPricing= Capsule::table('tblpricing')
			-> where( 'type', 'product' )
			-> where( 'relid', $service->packageid )
			-> first();

			# Update the service so its set to the new billing cycle, amount and the next due date is correct (as WHMCS updates this to a year from the date automatically)
			Capsule::table('tblhosting')
			-> where( 'id', $service->id )
			-> update([
				'billingcycle' => 'Annually',
				'amount'       => $getPricing->annually,
				'nextduedate'  => Carbon::now()->addMonth()->format('Y-m-d'),
			]);

		}

    }

}

add_hook( 'ShoppingCartCheckoutCompletePage', 1, 'free_trial_for_product' );


