/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jcterm;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.util.Hashtable;

public class JSchSession {
    private static JSch jsch = null;
    private static SessionFactory sessionFactory = null;
    private static Hashtable pool = new Hashtable();
    private String key = null;
    private Session session = null;

    public static JSchSession getSession(String username, String password, String hostname, int port, UserInfo userinfo, Proxy proxy) throws JSchException {
        String key = JSchSession.getPoolKey(username, hostname, port);
        try {
            JSchSession jschSession = (JSchSession)pool.get(key);
            if (jschSession != null && !jschSession.getSession().isConnected()) {
                pool.remove(key);
                jschSession = null;
            }
            if (jschSession == null) {
                Session session = null;
                try {
                    session = JSchSession.createSession(username, password, hostname, port, userinfo, proxy);
                }
                catch (JSchException e) {
                    if (JSchSession.isAuthenticationFailure(e)) {
                        session = JSchSession.createSession(username, password, hostname, port, userinfo, proxy);
                    }
                    throw e;
                }
                if (session == null) {
                    throw new JSchException("The JSch service is not available");
                }
                JSchSession schSession = new JSchSession(session, key);
                pool.put(key, schSession);
                return schSession;
            }
            return jschSession;
        }
        catch (JSchException e) {
            pool.remove(key);
            throw e;
        }
    }

    private static synchronized JSch getJSch() {
        if (jsch == null) {
            jsch = new JSch();
        }
        return jsch;
    }

    private static Session createSession(String username, String password, String hostname, int port, UserInfo userinfo, Proxy proxy) throws JSchException {
        Session session = null;
        session = sessionFactory == null ? JSchSession.getJSch().getSession(username, hostname, port) : sessionFactory.getSession(username, hostname, port);
        session.setTimeout(60000);
        if (password != null) {
            session.setPassword(password);
        }
        session.setUserInfo(userinfo);
        if (proxy != null) {
            session.setProxy(proxy);
        }
        session.connect(60000);
        session.setServerAliveInterval(60000);
        return session;
    }

    private static String getPoolKey(String username, String hostname, int port) {
        return username + "@" + hostname + ":" + port;
    }

    private JSchSession(Session session, String key) {
        this.session = session;
        this.key = key;
    }

    public Session getSession() {
        return this.session;
    }

    public void dispose() {
        if (this.session.isConnected()) {
            this.session.disconnect();
        }
        pool.remove(this.key);
    }

    public static boolean isAuthenticationFailure(JSchException ee) {
        return ee.getMessage().equals("Auth fail");
    }

    public static void setSessionFactory(SessionFactory sf) {
        sessionFactory = sf;
    }

    public static interface SessionFactory {
        public Session getSession(String var1, String var2, int var3) throws JSchException;
    }
}

