<?php

	if( WHMCS !== true )
	  die("This file cannot be accessed directly");

	include("funcs.php");
	
	
	
	function wc_clinet_page() {
		global $smarty;
	
		$smarty->unregister_function( "templates" );
		$smarty->register_function( "templates", "wc_shortcode_templates" );
	}

	add_hook( "ClientAreaPage", 1, "wc_clinet_page" );
	add_hook( "ClientAreaProductDetailsPreModuleTemplate", 1, "wc_clinet_page" );


	
	// shortcode (smarty plugin)
	function wc_shortcode_templates( $params, $smarty ) {
		$GET= array_merge( $_GET, $params );
		
		$smarty->assign( "get", $GET );
		$smarty->assign( "tags", WC::tag_list() );
		$smarty->assign( "assets", WC::path("assets") );
		
		$tpl= WC::dir("templates/list.tpl");
		$smarty->display( $tpl );
	}
	
	
	// fix sidebar icons
	function wc_SidebarIcons( $sbar ) {
	
		$menu= $sbar->getChild("Service Details Actions");
		if( !$menu )
			return;

		$name= Lang::trans("wc.shutdown");
		$name= "Custom Module Button $name";
		if( $btn= $menu->getChild($name) )
			$btn->setIcon("fa-power-off");

		$name= Lang::trans("wc.reboot");
		$name= "Custom Module Button $name";
		if( $btn= $menu->getChild($name) )
			$btn->setIcon("fa-rotate-right");
		
		$name= Lang::trans("wc.uninstall");
		$name= "Custom Module Button $name";
		if( $btn= $menu->getChild($name) )
			$btn->setIcon("fa-trash");
	}
	
	add_hook( "ClientAreaPrimarySidebar", 1, "wc_SidebarIcons" );

	
	
	// extend Lang catalogue
	WC::lang_init();
	


