

	
	tpl= {};
	
	
	tpl.init= function() {
		form= document.querySelector('form.tpl');
		tpl= Object.assign( form, tpl );
	
		tpl.lightbox= GLightbox();
		tpl.grid= tpl.querySelector('div.grid');
		tpl.lightbox.on( 'slide_after_load', tpl.events );
		
		tpl.prev= document.querySelector('button.prev');
		tpl.next= document.querySelector('button.next');
		tpl.prev.onclick= e => tpl.display( -1 );
		tpl.next.onclick= e => tpl.display( +1 );
		
		if( tpl.clientarea() )
		  tpl.restore();

		tpl.key.onkeyup= tpl.timer;
		tpl.onreset= tpl.timer;
		
		tpl.load();
	}
	
	
	tpl.timer= function() {
		clearTimeout( tpl.to );
		tpl.to= setTimeout( tpl.load, 1000 );
	}
	
	
	tpl.load= async function() {
		var url= wc.path('list.php?key=') + tpl.key.value;
		
		tpl.list= await fetch( url ).then( r=>r.json() );
		tpl.lightbox.setElements( tpl.list );
		
		tpl.page=0;
		tpl.display();		

		if( tpl.list.length==1 ) {
		  tpl.tid.value= tpl.list[0].id;
		  tpl.key.setCustomValidity('');
		} else {
		  tpl.tid.value= null;
		  tpl.key.setCustomValidity( msg.text(0) );
		}
		if( tpl.list.length==0 )
		  tpl.grid.innerHTML= msg.text(1);
	}
	
	
	tpl.display= function( i=0 ) {
		tpl.page+= i;
	
		var ppp= 10;
		var i1= tpl.page * ppp;
		var i2= i1 + ppp;
		var list= tpl.list.slice( i1, i2 );

		tpl.grid.innerHTML= null;
		list.forEach( tpl.add );
		
		tpl.prev.disabled= tpl.page==0
		tpl.next.disabled= !tpl.list[ i2 ];

	}
	
	
	tpl.add= function( obj,i ) {
		var a= document.createElement('a');
		var src= obj.href.replace( 'template', 'template/tn' );
		Object.assign( a, obj );
		a.onclick= tpl.open;
		a.style.backgroundImage= 'url(' + src + ')';
		tpl.grid.appendChild( a );
	}
	
	
	tpl.open= function() {
		tpl.lightbox.openAt( this.index );
		return false;
	}

	
	tpl.events= function() {
		var arr= document.querySelectorAll('div.gslide-desc nav');
		
		for( nav of arr ) {
		  nav.firstChild.target= 'demo';		  
		  nav.lastChild.onclick= tpl.select;
		}	  
	}
	
	
	tpl.select= function() {
		var obj= tpl.list[ tpl.lightbox.index ];
		tpl.key.value= obj.name;
		tpl.order( obj.name );		

		tpl.lightbox.close();
		setTimeout( tpl.load, 500 );
	}
	
	
	tpl.clientarea= function() {
		return location.href.includes('clientarea');
	}
	
	
	tpl.order= function( key ) {
		if( tpl.clientarea() )
		  return;
		if( key )
  		  localStorage.tplkey= key;
		location.href= '/index.php?rp=/store/woocommerce-rental';
	}
	
	
	tpl.restore= function() {
		if( localStorage.tplkey )
		  tpl.key.value= localStorage.tplkey;
		localStorage.removeItem('tplkey');
	}
	
	
	$( tpl.init );
	


