<?php

	// AJAX call to check shop status
	
	require "../../../../init.php";
	session_write_close();

	define( "red", "#f00" );
	define( "green", "#0f0" );
	define( "orange", "#fd2" );


	$test= key( $_GET );
	$id= reset( $_GET ) or led();

	$wc= new WC();

	// get data
	$hst= $wc->hosting_data( $id ) or led();
	$srv= $wc->server_data( $id ) or led();


	if( $test=="sql" ) {
		$ok= $wc->connect( $id );
		if( $ok )
		  led( $wc->test_db() ? green : orange );
		else
		  led( red );
	}
	
	if( $test=="serv" ) {
		$st= $wc->get_stack( $srv, $hst->username, "Status" );
		if( $st )
		  led( $st==1 ? green : orange );
		else
		  led( red );
	}
	
	if( $test=="subd" ) {
		$url= $wc->aws->subdom( $hst->username );
		$wp= test_url( $url );
		if( $wp )
		  led( $wp>1 ? green : orange );
		else
		  led( red );
	}
	
	if( $test=="domain" ) {
		$url= $hst->domain;
		$wp= test_url( $url );
		if( $wp )
		  led( $wp>1 ? green : orange );
		else
		  led( red );
	}

	led();



	function test_url( $url ) {
		$opt= [
		  CURLOPT_RETURNTRANSFER => true,
		  CURLOPT_SSL_VERIFYPEER => false,
		  CURLOPT_SSL_VERIFYHOST => 0,
		  CURLOPT_FOLLOWLOCATION => true,
		  CURLOPT_CONNECTTIMEOUT => 10,
		];

		$ch= curl_init( $url );
		curl_setopt_array( $ch, $opt );

		$html= curl_exec( $ch );
		$code= curl_getinfo( $ch, CURLINFO_HTTP_CODE );
		curl_close( $ch );
		
		if( $code != 200 )
		  return false;
		
		return strpos( $html, "wordpress" )+1;
	}
	


	function led( $color=null ) {
		header("Content-type: image/svg+xml");
		die( $color ? "

			<svg width='200' height='200' xmlns='http://www.w3.org/2000/svg'>
				<defs>
				  <linearGradient id='g1' x1='0' y1='0' x2='1' y2='1'>
				   <stop stop-color='$color' stop-opacity='0.9' offset='0'/>
				   <stop stop-color='$color' stop-opacity='0.6' offset='1'/>
				  </linearGradient>
				  <linearGradient id='g2' x1='0' y1='0' x2='1' y2='1'>
				   <stop stop-color='#ffff' offset='0'/>
				   <stop stop-color='#fff1' offset='0.7'/>
				  </linearGradient>
				</defs>
				<circle fill='#000' cx='100' cy='100' r='65' stroke='#0005' stroke-width='70' />
				<circle fill='url(#g1)' cx='100' cy='100' r='65'/>
				<ellipse fill='url(#g2)' cx='0' cy='85' rx='40' ry='24' transform='rotate(-47)'/>
			</svg>
			
		" : "

			<svg height='200' width='200' xmlns='http://www.w3.org/2000/svg'>
			  <circle r='80' cx='100' cy='100' fill='none' stroke='#0004' stroke-width='40'/>
			  <path d='M100,20,A80,80,90,0,1,180,100' stroke='#0003' fill='none' stroke-width='40'/>
			  <animateTransform attributeName='transform' type='rotate' dur='0.75s' values='0 0 0;360 0 0' repeatCount='indefinite'/>
			</svg>

		" );
	}



