<?php


	use WHMCS\User\Client;
	use WHMCS\Billing\Tax\Vat;


	$root= "../../..";

	require "$root/init.php";
	require "$root/includes/orderfunctions.php";
	
	
	$CONFIG['TaxEnabled']= ! taxExempt();
	totals_json();
	


	// exempt status
	function taxExempt() {
		$uid= $_POST['account_id'];

		if( $uid > 0) {
			// get client data
			$client= Client::find( $uid );	
		} else {
			// temp client
			$client= new Client();
			$client->taxId=   $_POST['tax_id'];  // GB731331179;
			$client->country= $_POST['country']; // HU
			Vat::setTaxExempt( $client );
		}
		
		return $client->taxExempt;
	}


	// cart totals 
	function totals_json() {
		$uid= $_POST['account_id'];
	
		// new user
		if( $uid == 0 ) {
			session_write_close();
			$_SESSION['uid']= 0;
			$_SESSION['cart']['user']['state']= $_POST['state'];
			$_SESSION['cart']['user']['country']= $_POST['country'];
		}
	
		// get data
		$cart= calcCartTotals();
		$cart['products']= null;
		$cart['taxname'] = $cart['taxname'] ?: Lang::trans("TaxExempt");

		// output json
		$response = new WHMCS\Http\JsonResponse();
		$response->setData( $cart );
		$response->send();
	}

	
	