

	tax= {};
	
	tax.script= document.currentScript.src;
	tax.php= tax.script.replace( 'js', 'php' );
	
	
	tax.init= function() {
		$('#inputCountry, .account-select').change( tax.timer );
		$('#inputTaxId, #stateinput').keyup( tax.timer );
		tax.timer();
	}
	
	
	tax.timer= function() {
		tax.to && clearTimeout( tax.to );
		tax.to= setTimeout( tax.recalc, 1000 );
	}
	
	tax.recalc= async function() {
		var loader = $('#orderSummaryLoader');

		if( loader.not(':visible') )
			loader.fadeIn('fast');

		var form= document.getElementById('frmCheckout');
		var body= new FormData( form );
		var conf= {
			method: 'post',
			body
		};

		var json= await fetch( tax.php, conf ).then( r=>r.json() );
		tax.redraw( json );

		loader.delay( 500 ).fadeOut('slow');
	}
	
	
	tax.redraw= function( data ) {
		tax.name('#taxTotal1', data.taxname, data.taxrate );
		tax.name('#taxTotal2', data.taxname2, data.taxrate2, true );
		$('#subtotal').html( data.subtotal );
		$('#taxTotal1').html( data.taxtotal );
		$('#taxTotal2').html( data.taxtotal2 );
		$('#recurringAnnually .cost').html( data.totalrecurringannually );
		$('#recurringBiennially .cost').html( data.totalrecurringbiennially );
		$('#recurringMonthly .cost').html( data.totalrecurringmonthly );
		$('#recurringQuarterly .cost').html( data.totalrecurringquarterly );
		$('#recurringSemiAnnually .cost').html( data.totalrecurringsemiannually );
		$('#recurringTriennially .cost').html( data.totalrecurringtriennially );
		$('#totalDueToday').html( data.total );
	}	
	
	tax.name= function( sel, name, rate, hide=0 ) {
		var txt= name +' @ '+ rate +'%';
		$( sel ).prev('span').html( txt );
		var row= $( sel ).parent('div');
		if( hide )
		  name ? row.show() : row.hide();		
	}
	
	
	$( tax.init );


