<?php



	function bars_head( $vars ) {
		global $smarty;
		$smarty->register_function( "bars", "bars_shortcode" );
		$file= bars_path("bars.css");
		return "
		  <link href='$file' rel='stylesheet'>
		";
	}

	add_hook( "ClientAreaHeadOutput", 1, "bars_head" );
	
	
	
	function bars_shortcode( $bars, $smarty ) {
		extract( $bars, EXTR_SKIP );
		$bars= array_filter( $bars, "is_numeric" );

		if( !$pre && !$post )
		  $pre= "&euro;";
	  
		$title= $title ?: "bars.title";
		$title= Lang::trans( $title );
		
		$x= max( $bars ) - min( $bars );
		$o= min( $bars );

		$o-= $x * 0.2;
		$x*= 1.2;
		
		echo "<section data-aos class='bars $class aos-init'>";
		echo "<h4> $title </h4>";
		
		foreach( $bars as $name => $value ) {
			$name= Lang::trans( $name );
			$w= ( $value - $o ) / $x * 100;
			echo "
				<p> $name </p>
				<ol>
					<ul><li style='width:$w%'>
					  <i> $pre $value $post </i>
					</li></ul>
				</ol>
			";
		}
		
		echo "</section>";		
	}
	
	

	function bars_path( $dir="" ) {
		$path = __DIR__;
		$path.= $dir ? "/$dir" : "";
		return strstr( $path, "/modules" );
	}
	
	
	