{include file="$template/includes/flashmessage.tpl"}
<div class="row mt-50">
    <div class="col-md-6">
        <div class="bg-seccolorstyle bg-white br-12 border-0 mergecolor p-50 p-relative noshadow">
            <div class="text-center">
                <h3 class="mergecolor border-0">{$LANG.userProfile.profile}</h3>
            </div>

            <form method="post" action="{routePath('user-profile-save')}">
                <div class="row">
                    <div class="col-sm-6">
                        <div class="form-group">
                            <label for="inputFirstName" class="control-label">
                                {$LANG.clientareafirstname}
                            </label>
                            <input
                                type="text"
                                name="firstname"
                                id="inputFirstName"
                                value="{$user->firstName}"
                                class="form-control"
                                {if in_array('firstname', $uneditableFields)}disabled="disabled"{/if}/>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="form-group">
                            <label for="inputLastName" class="control-label">
                                {$LANG.clientarealastname}
                            </label>
                            <input
                                type="text"
                                name="lastname"
                                id="inputLastName"
                                value="{$user->lastName}"
                                class="form-control"
                                {if in_array('lastname', $uneditableFields)}disabled="disabled"{/if}/>
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <input class="btn btn-primary" type="submit" name="save" value="{$LANG.clientareasavechanges}" />
                    <input class="btn btn-default" type="reset" value="{$LANG.cancel}" />
                </div>
            </form>
        </div>
    </div>

    <div class="col-md-6">
        <div class="bg-seccolorstyle bg-white br-12 border-0 noshadow mergecolor p-relative p-50">
            <div class="text-center">
                <h3 class="mergecolor border-0">{$LANG.userProfile.changeEmail}</h3>
            </div>
            <p>
                {if $user->needsToCompleteEmailVerification()}
                    <span class="plans badge feat bg-default">{$LANG.userProfile.notVerified}</span>
                {elseif $user->emailVerified()}
                    <span class="plans badge feat bg-success">{$LANG.userProfile.verified}</span>
                {/if}
            </p>
            <form method="post" action="{routePath('user-profile-email-save')}">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="form-group">
                            <label for="inputEmail" class="control-label">
                                {$LANG.clientareaemail}
                            </label>
                            <input
                                type="email"
                                name="email"
                                id="inputEmail"
                                value="{$user->email}"
                                class="form-control"
                                {if in_array('email', $uneditableFields)}disabled="disabled"{/if} />
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <input class="btn btn-primary" type="submit" name="save" value="{$LANG.clientareasavechanges}" />
                    <input class="btn btn-default" type="reset" value="{$LANG.cancel}" />
                </div>
            </form>
        </div>
    </div>
</div>
