<?php

	use WHMCS\Database\Capsule as DB;
	
	if( !defined("WHMCS") )
	  die("This file cannot be accessed directly");
	

	// module config
	function wc_MetaData() {
		return [
		  "DisplayName" => "WooCommerce",
		  "APIVersion" => "0.9",
		  "DefaultNonSSLPort" => "9000",
		  "DefaultSSLPort" => "9443",
		  "RequiresServer" => true,
		  "AutoGenerateUsernameAndPassword" => true,
		];
	}
	
	
	// hack extra fields to the server page
	function wc_server_page() {
		extract( $_SERVER );
		extract( $_GET, EXTR_SKIP );
		
		$file= basename( $PHP_SELF );
		
		if( $file!="configservers.php" || $action!="manage" )
		  return;
		
		include("mysql.php");
	}
	wc_server_page();
	
	

	// new service hook
	function wc_CreateAccount( $params ) {
		return true;
	}

	
	
	// portainer login link
	function wc_AdminLink( $params ) {
		extract( $params );
		$url = $serverhttpprefix ."://";
		$url.= $serverhostname ?: $serverip;
		$url.= ":". $serverport;
		return "<a href='$url' target='po'> Portainer Admin </a>";
	}
	


	// invoice overdue hook
	function wc_SuspendAccount( $params ) {
		wc_reboot( $params, 1, 1 );
		return true;
	}


	// restart service
	function wc_UnsuspendAccount( $params ) {
		wc_reboot( $params, 0, 1 );
		return true;
	}
	

	// invoice long overdue
	function wc_TerminateAccount( $params ) {
		$id= $params['serviceid'];
		$wc= new WC();
		$wc->uninstall( $id, 1 );
		return true;
	}



	// server config test
	function wc_TestConnection( $params ) {
		extract( $params );
		extract( $_POST, EXTR_SKIP );

		$url = $serverhttpprefix ."://";
		$url.= $serverhostname ?: $serverip;
		$url.= ":". $serverport;
		$url.= "/api/endpoints/2";

		$success= WC::port_request( $url, $serveraccesshash, "GET" );
		$error= WC::$error;
		
		if( !$success || !$mysql_host )
		  return compact( "success", "error" );
	  
		$success= new PDO( "mysql:host=$mysql_host", $mysql_user, $mysql_pass );
		return compact( "success" );
	}
	
	
	// product page hook
	function wc_ClientArea( $params ) {
		$hid= $params['serviceid'];
		$tpl= $params['customfields']['Template'];
		$act= $_GET['a'];
		
		if( $tpl )
		  include("setup.php");
		  
		$templatefile= $tpl ? "setup" : "install";
		
		if( $act=="uninstall" )
		  $templatefile= "uninst";

		$assets= WC::path("assets");
		$domain= $params['domain'];
		
		$vars= compact( "assets", "domain", "plu_list" );
		return compact( "templatefile", "vars" );
	}
	
	
	// action menu hook
	function wc_ClientAreaCustomButtonArray( $params ) {
		$hid= $params['serviceid'];
		$tpl= $params['customfields']['Template'];

		return $tpl ?
		[
		  Lang::trans("wc.shutdown")  => "shutdown",
		  Lang::trans("wc.reboot")    => "reboot",
		  Lang::trans("wc.uninstall") => "uninstall",
		] : [
		
		];
	}
	
	
	// menu callback
	function wc_reboot( $params, $stop=0, $admin=0 ) {
		$hid= $params['serviceid'];
		
		$wc = new WC();
		$hst= $wc->hosting_data( $hid, $admin ) or WC::die("Access Denied");
		$srv= $wc->server_data( $hid ) or WC::die("Server not Found");

		$ok= $wc->res_stack( $srv, $hst->username, $stop );
		
		if( $admin )
		  return true;
		
		if( $ok )
		  redir("action=productdetails&id=$hid");

		return "API error";
	}


	// menu callback
	function wc_shutdown( $params ) {
		return wc_reboot( $params, 1 );
	}
	

	// menu callback
	function wc_uninstall( $params ) {
		return [];
	}

	
	// built in callback
	function wc_ChangePassword( $params ) {
		$hid= $params['serviceid'];
		$pass= $params['password'];

		$wc= new WC();
		$wc->hosting_data( $hid ) or WC::die("Access Denied");
		$wc->connect( $hid ) or WC::die("Could not connect to DB");
		
		$ok= $wc->set_pass( "admin", $pass );
		return $ok ? "success" : "user not found";
	}
	
	
	
	
	// server admin save
	function wc_ServerEdit( $params ) {
		extract( $params );
		extract( $_POST, EXTR_SKIP );
		
		DB::table("mysql_servers")
		-> where( "id", $serverid )
		-> delete();

		if( !$mysql_host )
		  return;
		
		DB::table("mysql_servers")
		-> insert([
			'id'   => $serverid,
			'host' => $mysql_host,
			'user' => $mysql_user,
			'pass' => encrypt( $mysql_pass )
		]);
	}

	add_hook( "ServerDelete", 1, "wc_ServerEdit" );
	add_hook( "ServerEdit", 1, "wc_ServerEdit" );

	
	
	

	// Dev-Only
	include_once ROOTDIR ."/includes/modulefunctions.php";
	rebuildModuleHookCache();
	
	

	