<?php


use WHMCS\Database\Capsule as DB;


class WCA {
	
	
	
	// fetch template
	static function template( $file, $vars=[] ) {
		$file= self::dir("templates/$file.tpl");
		$smarty= new Smarty();
		
		foreach( $vars as $name => $val )
		  $smarty->assign( $name, $val );
		
		return $smarty->fetch( $file );
	}
	
	
	
	// services list
	static function service( $id=0 ) {
		$list= DB::table("tblhosting as h")
		-> join( "tblorders AS o", "o.id", "h.orderid" )
		-> join( "tblinvoices AS i", "i.id", "o.invoiceid" )
		-> join( "tblclients AS u", "u.id", "h.userid" )
		-> join( "tblservers AS s", "s.id", "h.server" )
		-> join( "mysql_servers AS m", "m.id", "s.id" )
		-> leftJoin( "tblcustomfieldsvalues AS v", function($j){$j
			-> on( "v.relid", "h.id" )
			-> join( "tblcustomfields AS n", "n.id", "v.fieldid" )
            -> where( "fieldname", "Template" );
		})
		-> where( "s.type", "wc" )
		-> select( "h.id", "h.userid", "u.email", "h.username", "domain", "orderid", "s.ipaddress", "m.host", "value", "i.status", "domainstatus" )
		-> get()
		-> toArray();
		
		$list= array_column( $list, null, "id" );
		return $id ? $list[$id] : $list;
	}
	
	
	
	// clients list
	static function clients( $all=0 ) {
		$query= DB::table("tblhosting as h")
		-> join( "tblclients AS u", "u.id", "h.userid" )
		-> join( "tblservers AS s", "s.id", "h.server" )
		-> select( "h.id", "h.userid", "u.email", "firstname", "lastname", "domain", "u.ip", "s.type" );
		
		if( !$all )
		  $query= $query -> where( "s.type", "wc" );
	  
		$list= $query -> get() -> toArray();
		return array_column( $list, null, "userid" );
	}	
	
	
	// client login
	static function login( $id ) {
		$sid= DB::table("tblhosting as h")
		-> join( "tblclients AS u", "u.id", "h.userid" )
		-> where( "u.id", $id )
		-> value( "h.id" );
		
		$args= [
		  'client_id' => $id,
		  'destination' => "clientarea:product_details",
		  'service_id' => $sid,
		];
		$url= localAPI( "CreateSsoToken", $args )['redirect_url'];
		self::redir( $url );
	}
	
	
	
	// log files
	static function logs() {
		$dir= WC::dir("log");
		$files= glob( "$dir/*", GLOB_NOSORT );
		usort( $files, "self::byext" );
		return $files;
	}
	
	
	// log sort callback
	static function byext( $a, $b ) {
		$a= pathinfo( $a, PATHINFO_EXTENSION );
		$b= pathinfo( $b, PATHINFO_EXTENSION );
		return $a - $b;
	}
	
	
	// log map callback
	static function maplog( $file ) {
		$data= file_get_contents( $file );
		$data= json_decode( $data );
		$tb= $data->traceback[0];
		return [
		  'msg' => $data->msg,
		  'date' => $data->date,
		  'user' => $data->user,
		  'uri' => basename( $data->REQUEST_URI ),
		  'php' => basename( $tb->file ),
		  'line' => $tb->line,
		  'function' => $tb->function,	
		];
	}
	
	
	// log list
	static function log_list() {
		$files= self::logs();
		return array_map( "self::maplog", $files );
	}
	
	
	// open log
	static function get_log( $id=null ) {
		if( $id===null ) {
		  $arr= self::logs();
		  header("Content-Type: application/zip");
		  echo self::zip( $arr );
		} else {
		  $file= self::logs()[ $id ];
		  header("Content-Type: application/json");
		  readfile( $file );
		}
		exit;
	}
	
	
	// compress files
	static function zip( $arr ) {
		$tmp= tmpfile();
		$tmp= stream_get_meta_data( $tmp )['uri'];

		$zip= new ZipArchive;
		$zip->open( $tmp, ZipArchive::CREATE );

		foreach( $arr as $file )
		  $zip->addFile( $file, basename($file) );

		$zip->close();
		$str= file_get_contents( $tmp );
		
		unlink( $tmp );
		return $str;
	}
	
	
	
	// file path for module [sub]directory
	static function dir( $dir="" ) {
		$path = __DIR__;
		return $dir ? "$path/$dir" : $path;
	}
	
	
	// url path for module [sub]directory
	static function path( $dir="" ) {
		$path = $dir[0]=="/" ? $dir : self::dir( $dir );
		return strstr( $path, "/modules" );
	}
	
	
	
	// save image
	static function upload_image( $sub, $id ) {
		$dir= WC::dir("images/$sub");

		$arr= glob("$dir/$id.*")[0];
		unlink( $img );
		$img= str_replace( $sub, "$sub/tn", $img );
		unlink( $img );
		
		if( !$file= $_FILES['img'] )
		  return;
	  
		extract( $file );
		$ext= pathinfo( $name, PATHINFO_EXTENSION );
		move_uploaded_file( $tmp_name, "$dir/$id.$ext" );
	}
	
	
	
	// page link
	static function link( ...$keep ) {
		$keep= array_flip([ "module", "pg", ...$keep ]);
		$pars= array_intersect_key( $_GET, $keep );
		$pars= http_build_query( $pars );
		return "?$pars";
	}
	
	
	// redirect
	static function redir( $url="" ) {
		$url= $url ?: self::link();
		header("Location: $url");
		exit;
	}
	

	// refresh
	static function reload( $t=0 ) {
		header("Refresh: $t");
		exit;
	}
	
	
	
}

