<?php

	// AJAX call to check shop status
	
	require "../../../../init.php";
	session_write_close();

	define( "red", "#f00" );
	define( "green", "#0f0" );
	define( "orange", "#fd2" );
	define( "gray", "#aaa" );


	$test= key( $_GET );
	$id= reset( $_GET ) or led();

	$wc= new WC();

	// get data
	$hst= $wc->hosting_data( $id, 1 ) or die();
	$srv= $wc->server_data( $id ) or die();


	if( $test=="sql" ) {
		$ok= $wc->connect( $id );
		if( $ok )
		  led( $wc->test_db() ? green : orange );
		else
		  led( red );
	}
	
	if( $test=="serv" ) {
		$st= $wc->get_stack( $srv, $hst->username, "Status" );
		if( $st )
		  led( $st==1 ? green : orange );
		else
		  led( red );
	}
	
	if( $test=="subd" ) {
		$url= $wc->aws->subdom( $hst->username );
		$wp= test_url( $url );
		if( $wp )
		  led( $wp>1 ? green : orange );
		else
		  led( red );
	}
	
	if( $test=="domain" ) {
		$url= $hst->domain;
		$wp= test_url( $url );
		if( $wp )
		  led( $wp>1 ? green : orange );
		else
		  led( red );
	}

	led();



	function test_url( $url ) {
		$opt= [
		  CURLOPT_RETURNTRANSFER => true,
		  CURLOPT_SSL_VERIFYPEER => false,
		  CURLOPT_SSL_VERIFYHOST => 0,
		  CURLOPT_FOLLOWLOCATION => true,
		  CURLOPT_CONNECTTIMEOUT => 10,
		];

		$ch= curl_init( $url );
		curl_setopt_array( $ch, $opt );

		$html= curl_exec( $ch );
		$code= curl_getinfo( $ch, CURLINFO_HTTP_CODE );
		curl_close( $ch );
		
		if( $code != 200 )
		  return false;
		
		return strpos( $html, "wordpress" )+1;
	}
	


	function led( $color=gray ) {
		header("Content-type: image/svg+xml");
		die("

			<svg width='100' height='100' xmlns='http://www.w3.org/2000/svg'>
				<defs>
				  <linearGradient id='g1' x1='0' y1='0' x2='1' y2='1'>
				   <stop stop-color='$color' stop-opacity='1.0' offset='0'/>
				   <stop stop-color='$color' stop-opacity='0.7' offset='1'/>
				  </linearGradient>
				</defs>
				<circle fill='#000' cx='50' cy='50' r='32' stroke='#0005' stroke-width='30' />
				<circle fill='url(#g1)' cx='50' cy='50' r='32'/>
			</svg>
			
		");
	}



