<?php

	use WHMCS\Database\Capsule as DB;


	// Add shortcode
	function sp_init( $vars ) {
		global $smarty;
		$smarty->register_function( "sitepad", "sp_shortcode" );
	}

	add_hook( "ClientAreaHeadOutput", 1, "sp_init" );


	// Shortcode content
	function sp_shortcode( $pars, $smarty ) {
		$file= sp_dir("list.tpl");
		$smarty->assign( "assets", sp_path("assets") );
		$smarty->display( $file );
	}


	// Cart page
	function sp_cart( $vars ) {
		global $sitepad_conf;
		
		// SitePad field ids
		$fid= DB::table("tblcustomfields")
		-> whereIn( "relid", $sitepad_conf['pid'] )
		-> where( "fieldname", "Template" )
		-> where( "required", "on" )
		-> pluck( "id" )
		-> toArray();
		
		$cf= $vars['customfields'];
		array_walk( $cf, "sp_fields", $fid );
		
		return [ 'customfields' => $cf ];
	}

	add_hook( "ClientAreaPageCart", 1, "sp_cart" );
	
	
	// Cart field
	function sp_fields( &$field, $key, $fid ) {
		extract( $field );
		
		// not 4 SitePad
		if( !in_array($id,$fid) )
		  return;
	
		// modify
		$tpl= $_COOKIE['tpl'];
		$field['input']= str_replace( "value", "value=\"$tpl\" readonly", $input );
	}
	
	
	// file path for module file
	function sp_dir( $file ) {
		$dir = __DIR__;
		return "$dir/$file";
	}
	
	
	// url path for module file
	function sp_path( $file ) {
		$path = sp_dir( $file );
		return strstr( $path, "/modules" );
	}
	
	
	