<?php

//////////////////////////////////////////////////////////////
//===========================================================
// sitepad.php
//===========================================================
// SOFTACULOUS 
// Version : 1.1
// Inspired by the DESIRE to be the BEST OF ALL
// ----------------------------------------------------------
// Started by: Alons
// Date:       10th Jan 2009
// Time:       21:00 hrs
// Site:       http://www.softaculous.com/ (SOFTACULOUS)
// ----------------------------------------------------------
// Please Read the Terms of use at http://www.softaculous.com
// ----------------------------------------------------------
//===========================================================
// (c)Softaculous Inc.
//===========================================================
//////////////////////////////////////////////////////////////

function sitepad_cpanel($vars){
	
	// Make the Login system
	$server_ip = (!empty($vars['serverdata']['ipaddress']) ? $vars['serverdata']['ipaddress'] : $vars['serverdata']['hostname']);
	$sitepad_login = 'https://'.rawurlencode($vars['username']).':'.rawurlencode($vars['password']).'@'.$server_ip.':2083/3rdparty/sitepad/index.live.php?act=sitemush&api=serialize&goto_cp='.rawurlencode(sitepad_get_current_url());
	
	sitepad_redirect($sitepad_login);
	
}

function sitepad_directadmin($vars){
	
	global $sitepad_conf;
		
	$protocol = (empty($sitepad_conf['da_proto']) ? 'http://' : $sitepad_conf['da_proto']);
	$da_port = (empty($sitepad_conf['da_port']) ? '2222' : $sitepad_conf['da_port']);
	
	$sitepad_login = $protocol.$vars['serverdata']['ipaddress'].':'.$da_port.'/CMD_PLUGINS/sitepad/index.raw?act=sitemush&api=serialize';
	
	// Login and get the cookies
	$ch = curl_init();
	curl_setopt($ch, CURLOPT_URL, $protocol.$vars['serverdata']['ipaddress'].':'.$da_port.'/CMD_LOGIN');
	curl_setopt($ch, CURLOPT_VERBOSE, 1);

	// Turn off the server and peer verification (TrustManager Concept).
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
	
	$post = array('username' => $vars['username'],
			'password' => $vars['password'],
			'referer' => '/');
	
	curl_setopt($ch, CURLOPT_POST, 1);
	$nvpreq = http_build_query($post);
	curl_setopt($ch, CURLOPT_POSTFIELDS, $nvpreq);
	
	// Check the Header
	curl_setopt($ch, CURLOPT_HEADER, 1);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	
	// Get response from the server.
	$resp = curl_exec($ch);
	
	// Did we login ?
	if($resp === false){
		report_sitepad_error('Could not login to the remote server. cURL Error : '.curl_error($ch));
		return false;
	}
	
	curl_close($ch);
	
	$resp = explode("\n", $resp);
	
	// Find the cookies
	foreach($resp as $k => $v){
		if(preg_match('/^'.preg_quote('set-cookie:', '/').'(.*?)$/is', $v, $mat)){
			$sitepad_cookie = trim($mat[1]);
		}
	}
	
	sitepad_redirect($sitepad_login, $sitepad_cookie);
	
}

function sitepad_redirect($url, $cookie = ''){
	
	// Set the curl parameters.
	$ch = curl_init();
	curl_setopt($ch, CURLOPT_URL, $url);

	// Turn off the server and peer verification (TrustManager Concept).
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
	curl_setopt($ch, CURLOPT_HEADER, FALSE);
	
	// Is there a Cookie
	if(!empty($cookie)){
		curl_setopt($ch, CURLOPT_COOKIESESSION, true);
		curl_setopt($ch, CURLOPT_COOKIE, $cookie);
	}

	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

	// Get response from the server.
	$resp = curl_exec($ch);
	
	// Did we reach out to that place ?
	if($resp === false){
		report_sitepad_error('No response received from SitePad. cURL Error : '.curl_error($ch));
	}
	
	curl_close($ch);
	
	$res_data = @unserialize($resp);
	
	if(!empty($res_data['redirect_url'])){
		echo '<meta http-equiv="Refresh" content="0;url='.$res_data['redirect_url'].'">';
		exit;
	}else{
		report_sitepad_error('Unable to fetch SitePad URL to redirect. Error : '.(!empty($res_data['error']) ? implode(',', $res_data['error']) : ''));
	}
	
}

function sitepad_login($vars){
	
	if(empty($_REQUEST['sm_login'])){
		return true;
	}
	
	if(!empty($GLOBALS['sitepad_conf']['pid']) && !in_array($vars['pid'], $GLOBALS['sitepad_conf']['pid'])){
		return true;
	}
	
	$moduletype = strtolower($GLOBALS['moduleparams']['moduletype']);
	
	// Is it a cPanel server ?
	if($moduletype == 'cpanel' || $moduletype == 'cpanel_extended' || $moduletype == 'cpanelextended'){
		sitepad_cpanel($vars);
		return true;
	}
	
	if($moduletype == 'directadmin' || $moduletype == 'directadmin_extended' || $moduletype == 'directadminextended'){
		sitepad_directadmin($vars);
		return true;
	}
	
} 

function sitepad_primarySidebar($primarySidebar){
		
	if(!empty($GLOBALS['sitepad_conf']['pid']) && !in_array($GLOBALS['moduleparams']['pid'], $GLOBALS['sitepad_conf']['pid'])){
		return true;
	}
	
	// Check if we should show SitePad link
	$allowed_modules = array('cpanel', 'cpanel_extended', 'cpanelextended',
						'directadmin', 'directadmin_extended', 'directadminextended');
	
	$check_module = strtolower($GLOBALS['moduleparams']['moduletype']);

	if(in_array($check_module, $allowed_modules)){
		
		//@var \WHMCS\View\Menu\Item $primarySidebar
		$newMenu = $primarySidebar->addChild(
			'WebsiteBuilder',
			array(
				'name' => 'Website Builder',
				'label' => 'Website Builder',
				'order' => 99,
				'icon' => 'fa-paint-brush',
			)
		);
		$newMenu->addChild(
			'SitePad',
			array(
				'name' => 'SitePad Website Builder',
				'label' => 'SitePad Website Builder',
				'uri' => 'clientarea.php?action=productdetails&id='.$_GET['id'].'&sm_login='.md5(uniqid(rand(), true)),
				'order' => 10,
				'icon' => 'fa-magic',
				'attributes' => array(
					'target' => '_blank'
				)
			)
		);
		
	}
}

// Reports the error
function report_sitepad_error($err){
	global $sitepad_conf;
	
	$err = 'SitePad : '.$err;
	
	if(!empty($sitepad_conf['debug_echo'])){
		echo $err.'<br>';
	}
	
	// Write to the file
	if(!empty($sitepad_conf['debug_file'])){
		$fp = @fopen($sitepad_conf['debug_file'], 'a');
		if($fp){
			@fwrite($fp, $err."\n");
			@fclose($fp);
		}
	}
	
	if(!empty($sitepad_conf['log_error'])){
		error_log($err);
	}
	
	// Log Activity in WHMCS	
	if(!empty($sitepad_conf['logActivity'])){
		logActivity($err);
	}
}

function sitepad_get_current_url(){
	
	$protocol = (!empty($_SERVER['HTTPS']) ? "https://" : "http://");
	$server_port = ((!empty($_SERVER['SERVER_PORT']) && $_SERVER['SERVER_PORT'] != 80 && $_SERVER['SERVER_PORT'] != 443) ? ':'.$_SERVER['SERVER_PORT'] : '');
	
	$parse = parse_url($_SERVER['HTTP_HOST']);
	if(empty($parse['port'])){
		$full_url = $protocol.$_SERVER['HTTP_HOST'].$server_port.$_SERVER['REQUEST_URI'];
	}else{
		$full_url = $protocol.$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'];
	}
	
	$strpos = strpos($full_url, 'sm_login');
	$full_url = substr($full_url, 0, $strpos);
	$full_url = str_replace('&amp;', '&', $full_url);
	$full_url = rtrim($full_url, '&');
	
	return $full_url;
}

add_hook('ClientAreaPage', 1, 'sitepad_login');
add_hook('ClientAreaPrimarySidebar', 1, 'sitepad_primarySidebar');