$(document).ready(function() {

    var module_name = 'realtimeregister';

    // Container
    var config_container_class = '#' + module_name + 'config',
        config_container = $(config_container_class);

    // Credentials
    var handleField = config_container.find('[name="customer_handle"]');
    var userField = config_container.find('[name="login"]');
    var passwordField = config_container.find('[name="rtr_password"]');
    var apiField = config_container.find('[name="rtr_api_key"]');
    var oteField = config_container.find('[type="checkbox"][name="test_mode"]');
    var ignoreSslField = config_container.find('[type="checkbox"][name="ignore_ssl"]');

    // Do not edit below
    //.credentialsCheckButton
    config_container.on('click', '.credentialsCheckButton', function (e) {
        e.preventDefault();

        var btn = $(this),
            text = btn.html(),
            result = config_container.find('.credentialsResult');

        btn.css({'width': btn.outerWidth()});
        btn.html("<i class=\"fa fa-spin fa-spinner\"></i>");
        btn.addClass("disabled");
        btn.attr("disabled", "disabled");
        $.post(
            window.location.href,
            {
                action: 'checkConnection',
                module: module_name,
                handle: handleField.val(),
                user: userField.val(),
                pass: passwordField.val(),
                api: apiField.val(),
                ote: oteField.is(":checked"),
                ignore_ssl: ignoreSslField.is(":checked"),
            }, function (response) {
                btn.html(text);
                btn.removeClass("disabled");
                if(response.connection === "true") {
                    result.html('<span class="status success">SUCCESSFUL</span>');
                } else {
                    result.html('<span class="status error"><strong>FAILED:</strong> ' + response.msg + '</span>');
                }
                btn.attr("disabled", false);
            }, "json"
        ).fail(function(e) {
            btn.html(text);
            btn.removeClass("disabled");
            btn.attr("disabled", false);
            result.html('<span class="status error"><strong>FAILED:</strong> Something went wrong!</span>');
        });
    });
});
