{if $type == 'new'}
	<div class="col col-xs-12 col-sm-6 col-md-4 col-lg-3">
{else}
	<div class="container">
{/if}
	<div class="module type-{$type}">
		<div class="module__icon">
			{if $image}
				<img src="{$image}">
			{/if}
		</div>
		<div class="badges hidden-xs pull-right">
			{if !$newest_version}
				{if $type != 'new'}
					<span class="badges__badge">Current version: {$current_version}</span>
				{/if}
			{else}
				<span class="badges__badge badges__badge--orange">Current version: {$current_version}</span>
				<span class="badges__badge">Newest version: {$newest_version}</span>
			{/if}
		</div>

		<h2 class="module__title">{$name}</h2>
		<h4 class="module__date">Updated: {$created}</h4>

		<div class="module__description">{$description}</div>

		<div class="module__extra">
			<ul class="module__usps pull-right">
				{foreach from=$usps item=usp}
					<li class="module__usp">
						<i class="{$usp->icon_class}"></i> {$usp->usp}
					</li>
				{/foreach}
			</ul>

			<div class="module__downloads">
				{if $download_url}
					{if $type == 'new'}
						<a href="{$download_url}" class="btn btn-success">
							<i class="fa fa-download"></i> Install module
						</a>
					{else}
					<a href="{$download_url}" class="btn btn-success">
						<i class="fa fa-refresh"></i> Download update
					</a>
					{/if}
				{/if}
				{if $detail_url}
				<a href="{$detail_url}" target="_blank" class="btn btn-info">
					<i class="fa fa-info-circle"></i> View details
				</a>
				{/if}
			</div>
		</div>
	</div>
</div>