<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package rozer
 */
$blog_archive_items = rdt_get_option('blog_archive_items', 1);
$class = 'col-xl-'.(12/$blog_archive_items).' col-12';
$post_content = rdt_get_option('blog_archive_excerpt', 'excerpt');
$post_archive_design = rdt_get_option('blog_archive_design', 'design-1');
//Start demo
if(isset($_GET['blog_style']) && $_GET['blog_style'] != '') {
	$post_archive_design = $_GET['blog_style'];
}
if(isset($_GET['columns']) && $_GET['columns'] != '') {
	$blog_archive_items = $_GET['columns'];
	$class = 'col-xl-'.(12/$blog_archive_items).' col-12';
}
//End demo
$class .= ' post-'.$post_archive_design;
?>
<?php if($post_archive_design == 'design-1') : ?>
	<article id="post-<?php the_ID(); ?>" <?php post_class($class); ?>>
		<div class="post-wrapper">
			<?php if (has_post_thumbnail()) { ?>	
				<div class="post-thumbnail">
					<?php rozer_post_thumbnail(); ?>
				</div>
			<?php } ?>
			<div class="post-content">
				<div class="post-categories-parent">
					<?php
					echo get_the_category_list( esc_html__( ', ', 'rozer' ) );
					?>
				</div>	
				<?php
				the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
				?>
				<div class="post-excerpt">
					<?php 
					if($post_content == 'excerpt') {
						echo do_shortcode(get_the_excerpt()); 
					}else{
						the_content(
							sprintf(
								wp_kses(
									/* translators: %s: Name of current post. Only visible to screen readers */
									__( 'Continue reading<span class="screen-reader-text"> "%s"</span>', 'rozer' ),
									array(
										'span' => array(
											'class' => array(),
										),
									)
								),
								get_the_title()
							)
						);
					}		
					?>
				</div>
				<div class="post-link">
					<?php do_action('archive_post_footer'); ?>
				</div>
			</div><!-- .entry-content -->
		</div>
	</article><!-- #post-<?php the_ID(); ?> -->
<?php elseif($post_archive_design == 'design-2') : ?>
	<article id="post-<?php the_ID(); ?>" <?php post_class($class); ?>>
		<div class="post-wrapper">
			<div class="row">
				<?php if (has_post_thumbnail()) { ?>
					<div class="col-4">
						<div class="post-thumbnail">
							<?php rozer_post_thumbnail(); ?>
						</div>
					</div>
				<?php } ?>
				<?php if (has_post_thumbnail()) { ?>
					<div class="col-8">
				<?php }else{ ?>
					<div class="col-12">
				<?php } ?>
					<div class="post-content">
						<div class="inner">
							<div class="post-categories-parent">
								<?php
								echo get_the_category_list( esc_html__( ', ', 'rozer' ) );
								?>
							</div>	
							<?php
							the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
							?>	
							<div class="post-excerpt">
								<?php 
								if($post_content == 'excerpt') {
									echo do_shortcode(get_the_excerpt()); 
								}else{
									the_content(
										sprintf(
											wp_kses(
												/* translators: %s: Name of current post. Only visible to screen readers */
												__( 'Continue reading<span class="screen-reader-text"> "%s"</span>', 'rozer' ),
												array(
													'span' => array(
														'class' => array(),
													),
												)
											),
											wp_kses_post( get_the_title() )
										)
									);
								}		
								?>
							</div>
							<div class="post-link">
								<?php do_action('archive_post_footer'); ?>
							</div>
						</div>
						<?php 
						if ( 'post' === get_post_type() ) :
							?>
							<div class="entry-meta">
								<?php
								rozer_posted_date();
								?>
							</div><!-- .entry-meta -->
						<?php endif; ?>	
					</div>
					<!-- .entry-content -->
				</div>
			</div>
		</div>
	</article><!-- #post-<?php the_ID(); ?> -->
<?php else : ?>
	<article id="post-<?php the_ID(); ?>" <?php post_class($class); ?>>
		<div class="post-wrapper">
			<?php if (has_post_thumbnail()) { ?>	
				<div class="post-thumbnail">
					<?php rozer_post_thumbnail(); ?>
				</div>
			<?php } ?>
			<div class="post-content">
				<div class="inner">
					<div class="post-categories-parent">
						<?php
						echo get_the_category_list( esc_html__( ', ', 'rozer' ) );
						?>
					</div>	
					<?php
						the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
					?>	
					<div class="post-link">
						<?php do_action('archive_post_footer'); ?>
					</div>
				</div>
			</div><!-- .entry-content -->
		</div>
	</article><!-- #post-<?php the_ID(); ?> -->
<?php endif; ?>