<?php
/**
 * The template for displaying all pages
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package rozer
 */
get_header();
$disable_the_title =  get_post_meta( $post->ID, 'page_custom_title', false );
$disable_breadcrumb =  get_post_meta( $post->ID, 'page_custom_breadcrumb', false );
$page_title_design = rdt_get_option('page_title_design' , '2');
$page_title_align = rdt_get_option('page_title_align' , 'left');
$page_title_size = rdt_get_option('page_title_size' , 'large');
$page_title_color = rdt_get_option('page_title_color' , 'dark');
if(!$disable_the_title && $page_title_design == '1') : ?>
	<div class="page-title-section text-<?php echo esc_attr($page_title_align); ?> page-title-<?php echo esc_attr($page_title_size); ?> text-<?php echo esc_attr($page_title_color); ?>"
	<?php if($custom_page_title_bground) : ?> style="background-image: url('<?php echo esc_url($custom_page_title_bground[0]); ?>');" <?php endif; ?>
	>
		<div class="container">
		<?php if ( ! is_front_page() ) :
			?>
			<header>
				<?php the_title( '<h1 class="entry-title">', '</h1>' ); ?>
			</header>
			<?php
			if( !$disable_breadcrumb ) echo rozer_breadcrumb();
		endif; ?>
		</div>
	</div>
<?php endif;
if( $page_title_design == '2' && !$disable_breadcrumb ): ?>
	<?php echo rozer_breadcrumb(); ?>
<?php endif;
?>
<div id="content">
	<div class="container">	
		<?php
		if ( is_woocommerce_activated() && (is_cart() || is_checkout()) ){
			?>
			<div class="process-box">
			<?php
			rozer_checkout_process();
			?>
			</div>
			<?php
		} 
		while ( have_posts() ) :
			the_post();
			get_template_part( 'template-parts/posts/content', 'page' );
			// If comments are open or we have at least one comment, load up the comment template.
			if ( comments_open() || get_comments_number() ) :
				comments_template();
			endif;
		endwhile; // End of the loop.
		?>
	</div>
</div>
<?php
get_footer();