<?php

Kirki::add_section( 'header_layout', array(
    'priority'    => 1,
    'title'       => esc_html__( 'Header Layout', 'rozer' ),
    'panel'       => 'header',
) );
Kirki::add_field( 'option', [
	'type'        => 'radio-image',
	'settings'    => 'header_layout',
	'label'       => esc_html__( 'Select header layout', 'rozer' ),
	'section'     => 'header_layout',
	'default'     => '1',
	'choices'     => [
		'1'   => get_template_directory_uri() . '/assets/images/customizer/header1.jpg',
		'2' => get_template_directory_uri() . '/assets/images/customizer/header2.jpg',
		'3'  => get_template_directory_uri() . '/assets/images/customizer/header3.jpg',
		'4'  => get_template_directory_uri() . '/assets/images/customizer/header4.jpg',
	],
	'preset'      => array(
		'1'    => array(
			'settings' => array(
				'header_topbar_active' => true,
				'header_topbar_background' => '#ffffff',
				'header_topbar_text' => 'dark',
				'header_main_padding' => '27',
				'header_main_background' => ['background-color'      => '#ffffff'],
				'header_main_text' => 'dark',
				'hmenu_background' => '#ffffff',
				'hmenu_item_align' => 'left',
				'hmenu_item_color' => '#1d1d1d',
				'hmenu_item_color_active' => '#146cda',
				'hmenu_item_background_color' => 'rgba(255,255,255,0)',
				'hmenu_item_background_color_active' => 'rgba(255,255,255,0)',
				'hmenu_item_font' => '14',
				'hmenu_item_space' => '15',
				'vertical_menu_active' => false,
				'he_account_design' => 'both-inline',
			),
		),
		'2'   => array(
			'settings' => array(
				'header_topbar_active' => true,
				'header_topbar_background' => '#ffffff',
				'header_topbar_text' => 'dark',
				'header_main_padding' => '30',
				'header_main_background' => ['background-color'      => '#ffffff'],
				'header_main_text' => 'dark',
				'hmenu_background' => '#ffffff',
				'hmenu_item_align' => 'left',
				'hmenu_item_color' => '#1d1d1d',
				'hmenu_item_color_active' => '#686a6b',
				'hmenu_item_background_color' => 'rgba(255,255,255,0)',
				'hmenu_item_background_color_active' => 'rgba(255,255,255,0)',
				'hmenu_item_font' => '14',
				'hmenu_item_space' => '15',
				'vertical_menu_active' => true,
				'vmenu_title_size' => '14',
				'vmenu_title_width' => '270',
				'vmenu_title_bground' => '#146cda',
				'vmenu_title_color' => '#ffffff',
				'vmenu_items_width' => '270',
				'he_account_design' => 'both-inline',
			),
		),
		'3' => [
			'settings' => [
				'header_topbar_active' => true,
				'header_topbar_background' => '#0562d6',
				'header_topbar_text' => 'light',
				'header_main_padding' => '30',
				'header_main_background' => ['background-color'      => '#146cda'],
				'header_main_text' => 'light',
				'hmenu_background' => '#146cda',
				'hmenu_item_align' => 'left',
				'hmenu_item_color' => '#ffffff',
				'hmenu_item_color_active' => '#ffffff',
				'hmenu_item_background_color' => 'rgba(255,255,255,0)',
				'hmenu_item_background_color_active' => '#257dea',
				'hmenu_item_font' => '14',
				'hmenu_item_space' => '0',
				'he_account_design' => 'both-inline',
				'vertical_menu_active' => false,
			],
		],
		'4'    => array(
			'settings' => array(
				'header_topbar_active' => false,
				'header_main_padding' => '30',
				'header_main_background' => ['background-color'      => '#146cda'],
				'header_main_text' => 'light',
				'hmenu_background' => '#ffffff',
				'hmenu_item_align' => 'left',
				'hmenu_item_color' => '#1d1d1d',
				'hmenu_item_color_active' => '#146cda',
				'hmenu_item_background_color' => 'rgba(255,255,255,0)',
				'hmenu_item_background_color_active' => 'rgba(255,255,255,0)',
				'hmenu_item_font' => '14',
				'hmenu_item_space' => '15',
				'vertical_menu_active' => true,
				'vmenu_title_size' => '14',
				'vmenu_title_width' => '240',
				'vmenu_title_bground' => 'rgba(255,255,255,0)',
				'vmenu_title_color' => '#1d1d1d',
				'vmenu_items_width' => '270',
				'he_account_design' => 'only-icon',
			),
		),
	),
] );