<?

/*
Plugin Name: XLSX Importáló - Becomparts
Description: Új termékek felvétele és jelenlegiek frissítése
Author: Richárd
Version: 1.3.0
Author URI: http://pcnerd.hu/
*/






new xlsx_importer();

class xlsx_importer {



	// constructor
    function __construct() {
		add_action('admin_menu', [$this,"menu"] );
	}
	
	// admin menu
	function menu() {
		add_submenu_page( 'edit.php?post_type=product', 'Importáló', 'Excel importáló', 'manage_options', 'importer', [$this,"html"] ); 
	}
	
	
	
	// add page content
	function html() {
		
		// disable notices
		error_reporting( E_ALL & ~E_NOTICE );
		
		// back-end css
		$dir= plugins_url( 'back', __FILE__ );
		wp_enqueue_style( 'importer_css', "$dir/form.css" );
		
		// $name, $tmp_name, $size ...
		@ extract( $_FILES['xlsx'] );
		// $basedir, $baseurl ...
		extract( wp_upload_dir() );
		
		// upload
		if( $size ) {
		 if( $type!="application/vnd.openxmlformats-officedocument.spreadsheetml.sheet" ) {
			 
			// wrong file type
			$this->message( "Fájlformátum nem támogatott", "red" );
			
		 } else {
			 
			// clean filename
			$name= sanitize_file_name( $name );
			$name= preg_replace( "@[^\w\-\.]+@", "", $name );
			
			// add or replace date
			$date= date("Y-m-d");
			$name= preg_replace( "@(.\d{4}-\d{2}-\d{2})@", "", $name );
			$name= str_replace( ".xlsx", ".$date.xlsx", $name );
			
			// save file
			$file= "$basedir/xlsx/$name";
			move_uploaded_file( $tmp_name,$file );
			
			// import
			$this->import( $file );
			
		}}

		// user interface
		include("back/form.php");
	}
	
	

	
	function import( $file ) {
		
		// php setup
		ini_set("memory_limit", "512M");
		set_time_limit( 36000 );
		
		// $test, $sup
		extract( $_POST );

		// read xml, skip header
		$arr= $this->open_xlsx( $file );
		unset( $arr[1] );
		
		// missing supplier
		if( $sup=='' )
		  return $this->message( "Beszállító megadása kötelező", "red" );

		// get supplier id
		$post_parent= $this->supplier( $sup );
		
		// existing products by sku
		$prod_id= $this->prod_id( $post_parent );
		
		// static for new products
		$post_type    = 'product';
		$post_status  = 'draft';
		$_stock_status= 'instock';
		

		foreach( $arr as $i=>$row ) {
			list( $x, $post_title, $tag, $_sku, $ean_code, $_price )= $row;
			
			// quick fix
			$_price= floor( $_price );

			// non-unique sku
			if( @ in_array( $_sku, $b4 ) )
			  return $this->message( "Nem egyedi cikkszám: $_sku", "red" );
			$b4[]= $_sku;

			// product id
			$id= $prod_id[ $_sku ];
			unset( $prod_id[ $_sku ] );

			// counter
			$id ? $upd++ : $new++;

			// test only
			if( $test ) { continue; }
			
			// update / new
			if( $id ) {
			
				// set prices (faseter)
				$this->set_min_price( $id, $_price );

				// set stock status
				update_post_meta( $id, '_stock_status', 'instock' );
				
				// temporary
				if( $ean_code )
				  update_post_meta( $id, 'ean_code', $ean_code );

			} else {

				// Post & Meta
				$_min_price = $_regular_price = $_price;
				
				// Tags
				$tax_input['product_tag'] = $tag;
				
				// Prepare arrays
				$meta_input = compact( '_sku', 'ean_code', '_min_price', '_regular_price', '_price', '_stock_status' );
				$post = compact( 'post_title', 'post_parent', 'post_status', 'post_type', 'meta_input', 'tax_input' );

				// Create post
				$pid = wp_insert_post( $post );

			}
			
		} // foreach

		
		// warnings & messages
		$ige= $test ? "kerülne" : "került";

		if( $new )
		  $this->message( "Összesen $new termék $ige feltöltésre", "green" );
	  
		if( $upd )
		  $this->message( "Összesen $upd termék $ige frissítésre", "green" );
		
		if( $oos=count( $prod_id ) )
		  $this->message( "Jelenleg $oos termék nincs raktáron", "green" );
	  

		// test only
		if( $test ) { return; }

		// not in list
		foreach( $prod_id as $id )
		  update_post_meta( $id, '_stock_status', 'outofstock' );
		
	}
	
	
	
	
	// set product prices
	function set_min_price( $pid, $min ) {
		global $wpdb;
		// update
		$sql= $wpdb->prepare("
		  UPDATE wp_postmeta SET meta_value= %d
		  WHERE post_id= %d 
		  AND ( meta_key='_regular_price' OR meta_key='_price' )
		  AND meta_value < %d
		", $min, $pid, $min );
		$wpdb->query( $sql );
		// deals with cache
		update_post_meta( $pid, '_min_price', $min );
	}



	
	// sku indexed product_id list
	function prod_id( $par=0 ) {
		global $wpdb;
		$arr= $wpdb->get_results("
		  SELECT id, meta_value
		  FROM wp_posts, wp_postmeta
		  WHERE post_id = ID
		  AND meta_key = '_sku'
		  AND post_parent = '$par'
		", ARRAY_A );
		return array_column( $arr, 'id', 'meta_value' );
	}
	
	
	
	
	// supplier list & ID lookup
	function supplier( $title=null ) {
		global $wpdb;
		
		if( $title ) {
			
			// get id
			$id= get_page_by_title( $title, 'OBJECT', 'supplier' ) -> ID;
			if( $id )
			  return $id;
		  
			// insert
			$id= wp_insert_post( [
			  'post_type'  => 'supplier',
			  'post_title' => $title
			], false, false );
			
			// return id
			return $id;
		}
		
		// get full list
		$arr= $wpdb->get_results("
		  SELECT * FROM wp_posts
		  WHERE post_type= 'supplier'
		  ORDER BY post_title
		", 'ARRAY_A' );
		$arr= array_column( $arr, 'post_title', 'ID' );
		
		// return array
		return $arr;
	}
	



	// get xlsx values
	function open_xlsx( $file ) {
		// open zip
		$zip= new ZipArchive();
		$zip->open( $file );

		// open sharedStrings
		$string= $zip->getFromName("xl/sharedStrings.xml");
		$string= new SimpleXMLElement( $string );

		// open sheet1
		$sheet= $zip->getFromName("xl/worksheets/sheet1.xml");
		$sheet= new SimpleXMLElement( $sheet );

		// parse data
		foreach( $sheet->sheetData->row as $row ) {
		 foreach( $row->c as $c ) {
			 
			// no value
			if( !$c->v ) { continue; }
			
			// coords
			$y= $row['r']*1;
			$x= ord( $c['r'] )-64;
			
			// get value
			$si = $string->si[ +$c->v ];
			$val= $c['t']=="s" ? ( $si->t ?: $si->r->t ) : $c->v;
			$arr[ $y ][ $x ]= (string) $val;

		}}
		return $arr;
	}
	
	
	
	// display message
	function message( $msg, $color ) {
		echo "<div class='msgbox $color'> $msg </div>";
	}
	
	
	
}

