<?php
/**
 * WooCommerce Email Customizer with Drag and Drop Email Builder
 * Create awesome transactional emails with a drag and drop email builder
 * @author Flycart Technologies LLP
 * @license GNU GPL V3 or later
 */

if (!defined('ABSPATH')) exit; // Exit if accessed directly

if (!function_exists('WOOMBPB_getEmailTemplateFromPost')) {
	/**
     * Get Email template from post
     * */
    function WOOMBPB_getEmailTemplateFromPost($email_type, $lang){
        if($email_type != '' && $lang != ''){
            global $wpdb;
            //$postid = $wpdb->get_var( "SELECT ID FROM $wpdb->posts WHERE post_title = '" . $email_type . "' AND post_name = '".strtolower($lang)."' AND post_type = 'woo_mb_template'" );
            $postid = $wpdb->get_var( "SELECT pm.post_id FROM $wpdb->postmeta as pm LEFT JOIN $wpdb->posts as p ON (pm.post_id = p.ID) WHERE (pm.meta_value = '" . $lang ."' OR pm.meta_value = '" . strtolower($lang)."') AND pm.meta_key = 'wec_language' AND p.post_type = 'woo_mb_template' AND p.post_title = '" . $email_type ."'");
            return $postid;
        } else {
            return false;
        }
    }
}

if (!function_exists('WOOMBPB_RemoveEmailTemplateFromPost')) {
	/**
	 * Remove Email template from post
	 * */
	function WOOMBPB_RemoveEmailTemplateFromPost(){
		global $wpdb;
		$status = $wpdb->get_var( "DELETE FROM $wpdb->posts WHERE `post_type` = 'woo_mb_template'" );
		return $status;
	}
}

if (!function_exists('WOOMBPB_RemoveEmailTemplateMigrationForLanguageFix')) {
    /**
     * Remove Email template from post
     * */
    function WOOMBPB_RemoveEmailTemplateMigrationForLanguageFix(){
        $woo_mb_migration_lang_fix = get_option('woo_mb_migration_lang_fix', 0);
        if((int)$woo_mb_migration_lang_fix != 1){
            global $wpdb;
            $posts = $wpdb->get_results( "SELECT * FROM $wpdb->posts WHERE `post_type` = 'woo_mb_template'" );
            if(!empty($posts)){
                if(is_array($posts) && count($posts)){
                    foreach ($posts as $post){
                        if(!empty($post->ID)){
                            $postid = $post->ID;
                            $language = $post->post_name;
                            $language_splitted = explode('-', $language);
                            if(isset($language_splitted['0']) && !empty($language_splitted['0'])){
                                $language = $language_splitted['0'];
                                $index = 'wec_language';
                                $value = $language;
                                if (get_post_meta($postid, $index)) {
                                    update_post_meta($postid, $index, $value);
                                } else {
                                    add_post_meta($postid, $index, $value, true);
                                }
                            }
                        }
                    }
                    update_option('woo_mb_migration_lang_fix', 1);
                }
            }
        }
    }
}


function WOOMBPBonActivatePlugin()
{
    //check migration for language fix in WordPress 5.1
    WOOMBPB_RemoveEmailTemplateMigrationForLanguageFix();

    // Dependency Check.
    //if (!in_array('woocommerce/woocommerce.php', get_option('active_plugins'))) wp_die('Please Install WooCommerce to Continue !');

    // TODO: check compatible php version

    $mail_templates = array();

    // 1. New Order template
    $mail_templates['new_order'] = array(
    	'post_type' 	=> 'woo_mb_template',
    	'post_title' 	=> 'new_order',
    	'post_name' 	=> 'en_us',
    	'post_content'  => '{"elements":[{"type":"image","options":{"align":"center","padding":["15px","50px","15px","50px"],"image":"'.WOO_ECPB_URI.'/assets/images/woo-logo-vector.png","backgroundColor":"#edf1e4"},"id":"id1488456119390RAND49218","component":"imageTemplate"},{"type":"title","options":{"align":"center","title":" New Order","subTitle":"","padding":["30px","50px","30px","50px"],"backgroundColor":"#edf1e4","color":"#444444"},"id":"id1488459613836RAND65534","component":"titleTemplate"},{"type":"text","options":{"padding":["10px","50px","10px","50px"],"backgroundColor":"#ffffff","text":"<p><span style=\\\"font-size: 11pt; color: #333333; line-height: 2;\\\" data-mce-style=\\\"font-size: 11pt; color: #333333; line-height: 2;\\\">Your order has been created successfully. Your order details are as follows:</span></p>"},"id":"id1490763137492RAND32909","component":"textTemplate"},{"type":"itemTable","options":{"padding":["15px","50px","15px","50px"],"width":"370","backgroundColor":"#ffffff","text":"<p style=\\\"line-height: 22px;\\\" data-mce-style=\\\"line-height: 22px;\\\"><span style=\\\"color: rgb(51, 51, 51); font-size: 11pt;\\\" data-mce-style=\\\"color: #333333; font-size: 11pt;\\\">[woo_mb_items]</span></p>"},"id":"id1490763198282RAND62698","component":"itemTableTemplate"},{"type":"text","options":{"padding":["10px","50px","10px","50px"],"backgroundColor":"#ffffff","text":"<p style=\\\"text-align: center; line-height: 2;\\\" data-mce-style=\\\"text-align: center; line-height: 2;\\\"><span style=\\\"font-size: 11pt; color: rgb(51, 51, 51);\\\" data-mce-style=\\\"font-size: 11pt; color: #333333;\\\"><strong>Customer Information: </strong></span><br><span style=\\\"font-size: 11pt; color: rgb(51, 51, 51);\\\" data-mce-style=\\\"font-size: 11pt; color: #333333;\\\"> [woo_mb_shipping_first_name] </span><br><span style=\\\"font-size: 11pt; color: rgb(51, 51, 51);\\\" data-mce-style=\\\"font-size: 11pt; color: #333333;\\\"> [woo_mb_user_email]</span></p>"},"id":"id1490763223279RAND57986","component":"textTemplate"},{"type":"imageText2x2","options":{"padding":["15px","50px","15px","50px"],"width1":"255","width2":"255","backgroundColor":"#ffffff","text1":"<p style=\\\"text-align: left;\\\"><span style=\\\"font-size: 12pt; color: #333333;\\\"><strong>Shipping Address:</strong></span></p><p style=\\\"text-align: left;\\\"><span style=\\\"font-size: 11pt; color: #333333;\\\">[woo_mb_shipping_address]</span></p>","text2":"<p style=\\\"text-align: right;\\\"><span style=\\\"font-size: 12pt; color: #333333;\\\"><strong>Billing Address:</strong></span></p><p style=\\\"text-align: right;\\\"><span style=\\\"font-size: 11pt; color: #333333;\\\">[woo_mb_billing_address]</span></p>"},"id":"id1490768894336RAND47803","component":"imageText2x2Template"},{"type":"divider","options":{"padding":["15px","50px","0px","50px"],"backgroundColor":"#ffffff"},"id":"id1490763959813RAND82977","component":"dividerTemplate"},{"type":"text","options":{"padding":["10px","50px","10px","50px"],"backgroundColor":"#ffffff","text":"<p><span style=\\\"font-size: 11pt;\\\" data-mce-style=\\\"font-size: 11pt;\\\">Feel free to contact us if you have any question</span><br data-mce-bogus=\\\"1\\\"></p><p><span style=\\\"font-size: 11pt;\\\" data-mce-style=\\\"font-size: 11pt;\\\">Sincerely,</span><br data-mce-bogus=\\\"1\\\"></p><p><span style=\\\"font-size: 11pt;\\\" data-mce-style=\\\"font-size: 11pt;\\\">Mystore Team,</span><br data-mce-bogus=\\\"1\\\"></p><p><br data-mce-bogus=\\\"1\\\"></p>"},"id":"id1490764119933RAND43784","component":"textTemplate"},{"type":"unsubscribe","options":{"padding":["10px","50px","10px","50px"],"backgroundColor":"#9c5d90","text":"<div class=\\\"text-center\\\"><p><span style=\\\"color: #dddddd; font-size: 11pt;\\\" data-mce-style=\\\"color: #dddddd; font-size: 11pt;\\\">My Store | <a style=\\\"color: #dddddd;\\\" href=\\\"http://www.mystore.com\\\" data-mce-href=\\\"http://www.mystore.com\\\" data-mce-style=\\\"color: #dddddd;\\\">www.mystore.com</a> | <a style=\\\"color: #dddddd;\\\" href=\\\"http://facebook.com\\\" data-mce-href=\\\"http://facebook.com\\\" data-mce-style=\\\"color: #dddddd;\\\">Facebook</a></span><br data-mce-bogus=\\\"1\\\"></p></div>"},"id":"id1488455236937RAND46187","component":"unsubscribeTemplate"}],"html":"<html><head><meta http-equiv=\\\"Content-Type\\\" content=\\\"text/html; charset=UTF-8\\\"><meta name=\\\"viewport\\\" content=\\\"width=device-width\\\" initial-scale=\\\"1.0\\\" user-scalable=\\\"yes\\\"></head><body style=\\\"background: rgb(237, 241, 228) none repeat scroll 0% 0%; padding: 50px 5px;\\\"><table data-type=\\\"image\\\" class=\\\"em-main\\\" style=\\\"display: table; background-color: rgb(237, 241, 228);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" align=\\\"center\\\"><tbody><tr><td class=\\\"em-image\\\" style=\\\"padding: 15px 50px;\\\" align=\\\"center\\\"><img src=\\\"'.WOO_ECPB_URI.'/assets/images/woo-logo-vector.png\\\" tabindex=\\\"0\\\" style=\\\"display: block; max-width: 100%;\\\" border=\\\"0\\\"></td></tr></tbody></table>    <table data-type=\\\"title\\\" class=\\\"em-main\\\" style=\\\"display: table; background-color: rgb(237, 241, 228);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" align=\\\"center\\\"><tbody><tr><td data-block-id=\\\"background\\\" class=\\\"em-title\\\" style=\\\"color: rgb(117, 117, 117); padding: 30px 50px;\\\" align=\\\"center\\\"><h1 data-block-id=\\\"main-title\\\" style=\\\"font-family: Arial,sans-serif; margin: 0px; font-weight: 800; line-height: 42px; font-size: 36px; color: rgb(68, 68, 68);\\\"> New Order</h1> <!----></td></tr></tbody></table>    <table data-type=\\\"text-block\\\" class=\\\"em-main\\\" style=\\\"display: table; background-color: rgb(255, 255, 255);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" align=\\\"center\\\"><tbody><tr><td data-block-id=\\\"background\\\" class=\\\"em-block-text\\\" style=\\\"font-size: 13px; color: rgb(0, 0, 0); line-height: 22px; padding: 10px 50px;\\\" align=\\\"left\\\"><p><span style=\\\"font-size: 11pt; color: #333333; line-height: 2;\\\" data-mce-style=\\\"font-size: 11pt; color: #333333; line-height: 2;\\\">Your order has been created successfully. Your order details are as follows:</span></p></td></tr></tbody></table>    <table data-type=\\\"itemTable\\\" class=\\\"em-main\\\" style=\\\"display: table; background-color: rgb(255, 255, 255);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" bgcolor=\\\"#FFFFFF\\\" align=\\\"center\\\"><tbody><tr><td class=\\\"em-image-text\\\" style=\\\"font-family: Arial,serif; font-size: 13px; color: rgb(0, 0, 0); line-height: 22px; padding: 15px 50px;\\\" align=\\\"left\\\"><div><p style=\\\"line-height: 22px;\\\" data-mce-style=\\\"line-height: 22px;\\\"><span style=\\\"color: rgb(51, 51, 51); font-size: 11pt;\\\" data-mce-style=\\\"color: #333333; font-size: 11pt;\\\"></span></p>[woo_mb_items]<p></p></div></td></tr></tbody></table>    <table data-type=\\\"text-block\\\" class=\\\"em-main\\\" style=\\\"display: table; background-color: rgb(255, 255, 255);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" align=\\\"center\\\"><tbody><tr><td data-block-id=\\\"background\\\" class=\\\"em-block-text\\\" style=\\\"font-size: 13px; color: rgb(0, 0, 0); line-height: 22px; padding: 10px 50px;\\\" align=\\\"left\\\"><p style=\\\"text-align: center; line-height: 2;\\\" data-mce-style=\\\"text-align: center; line-height: 2;\\\"><span style=\\\"font-size: 11pt; color: rgb(51, 51, 51);\\\" data-mce-style=\\\"font-size: 11pt; color: #333333;\\\"><strong>Customer Information: </strong></span><br><span style=\\\"font-size: 11pt; color: rgb(51, 51, 51);\\\" data-mce-style=\\\"font-size: 11pt; color: #333333;\\\"> </span></p>[woo_mb_shipping_first_name] <br><span style=\\\"font-size: 11pt; color: rgb(51, 51, 51);\\\" data-mce-style=\\\"font-size: 11pt; color: #333333;\\\"> [woo_mb_user_email]</span><p></p></td></tr></tbody></table>    <table data-type=\\\"imageText2x2Template\\\" class=\\\"em-main\\\" style=\\\"display: table; background-color: rgb(255, 255, 255);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" bgcolor=\\\"#FFFFFF\\\" align=\\\"center\\\"><tbody><tr><td><table class=\\\"em-main\\\" style=\\\"display: table;\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" align=\\\"center\\\"><tbody><tr><td data-block-id=\\\"background\\\" class=\\\"em-image-caption\\\" style=\\\"padding: 15px 50px;\\\"><table class=\\\"em-image-caption-column\\\" width=\\\"255\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" align=\\\"left\\\"><tbody><tr><td class=\\\"em-image-caption-content\\\"><img style=\\\"display: block;\\\" width=\\\"255\\\" border=\\\"0\\\" align=\\\"2\\\"></td></tr> <tr><td class=\\\"em-image-caption-content text\\\" style=\\\"font-family: Arial,serif; font-size: 13px; color: rgb(0, 0, 0); line-height: 22px;\\\" align=\\\"left\\\"><p style=\\\"text-align: left;\\\"><span style=\\\"font-size: 12pt; color: #333333;\\\"><strong>Shipping Address:</strong></span></p><p style=\\\"text-align: left;\\\"><span style=\\\"font-size: 11pt; color: #333333;\\\"></span></p>[woo_mb_shipping_address]<p></p></td></tr> <tr><td class=\\\"em-image-caption-bottom-gap\\\" width=\\\"100%\\\" height=\\\"5\\\"></td></tr></tbody></table> <table class=\\\"em-image-caption-column\\\" width=\\\"255\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" align=\\\"right\\\"><tbody><tr><td class=\\\"em-image-caption-content\\\"><img style=\\\"display: block;\\\" width=\\\"255\\\" border=\\\"0\\\" align=\\\"2\\\"></td></tr> <tr><td class=\\\"em-image-caption-content text\\\" style=\\\"font-family: Arial,serif; font-size: 13px; color: rgb(0, 0, 0); line-height: 22px;\\\" align=\\\"left\\\"><p style=\\\"text-align: right;\\\"><span style=\\\"font-size: 12pt; color: #333333;\\\"><strong>Billing Address:</strong></span></p><p style=\\\"text-align: right;\\\"><span style=\\\"font-size: 11pt; color: #333333;\\\"></span></p>[woo_mb_billing_address]<p></p></td></tr> <tr><td width=\\\"100%\\\" height=\\\"5\\\"></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table>    <table data-type=\\\"divider\\\" class=\\\"em-main\\\" style=\\\"border: 0px none; display: table; background-color: rgb(255, 255, 255);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" align=\\\"center\\\"><tbody><tr><td class=\\\"em-divider-simple\\\" style=\\\"padding: 15px 50px 0px;\\\"><table style=\\\"border-top: 1px solid rgb(218, 223, 225);\\\" width=\\\"100%\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\"><tbody><tr><td width=\\\"100%\\\" height=\\\"15px\\\"></td></tr></tbody></table></td></tr></tbody></table>    <table data-type=\\\"text-block\\\" class=\\\"em-main\\\" style=\\\"display: table; background-color: rgb(255, 255, 255);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" align=\\\"center\\\"><tbody><tr><td data-block-id=\\\"background\\\" class=\\\"em-block-text\\\" style=\\\"font-size: 13px; color: rgb(0, 0, 0); line-height: 22px; padding: 10px 50px;\\\" align=\\\"left\\\"><p><span style=\\\"font-size: 11pt;\\\" data-mce-style=\\\"font-size: 11pt;\\\">Feel free to contact us if you have any question</span><br data-mce-bogus=\\\"1\\\"></p><p><span style=\\\"font-size: 11pt;\\\" data-mce-style=\\\"font-size: 11pt;\\\">Sincerely,</span><br data-mce-bogus=\\\"1\\\"></p><p><span style=\\\"font-size: 11pt;\\\" data-mce-style=\\\"font-size: 11pt;\\\">Mystore Team,</span><br data-mce-bogus=\\\"1\\\"></p><p><br data-mce-bogus=\\\"1\\\"></p></td></tr></tbody></table>    <table data-type=\\\"text-block\\\" class=\\\"em-main\\\" style=\\\"display: table; background-color: rgb(156, 93, 144);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" align=\\\"center\\\"><tbody><tr><td data-block-id=\\\"background\\\" style=\\\"font-family: Arial,serif; font-size: 13px; color: rgb(0, 0, 0); line-height: 22px; padding: 10px 50px;\\\" align=\\\"left\\\"><div class=\\\"text-center\\\"><p><span style=\\\"color: #dddddd; font-size: 11pt;\\\" data-mce-style=\\\"color: #dddddd; font-size: 11pt;\\\">My Store | <a style=\\\"color: #dddddd;\\\" href=\\\"http://www.mystore.com\\\" data-mce-href=\\\"http://www.mystore.com\\\" data-mce-style=\\\"color: #dddddd;\\\">www.mystore.com</a> | <a style=\\\"color: #dddddd;\\\" href=\\\"http://facebook.com\\\" data-mce-href=\\\"http://facebook.com\\\" data-mce-style=\\\"color: #dddddd;\\\">Facebook</a></span><br data-mce-bogus=\\\"1\\\"></p></div></td></tr></tbody></table>    </body></html>","emailSettings":{"options":{"paddingTop":"50px","paddingLeft":"5px","paddingBottom":"50px","paddingRight":"5px","backgroundColor":"#edf1e4"},"type":"emailSettings"}}'
    );

	// 2. Cancelled order
    $mail_templates['cancelled_order'] = array(
    	'post_type' 	=> 'woo_mb_template',
    	'post_title' 	=> 'cancelled_order',
    	'post_name' 	=> 'en_us',
    	'post_content'  => '{"elements":[{"type":"image","options":{"align":"center","padding":["15px","50px","15px","50px"],"image":"'.WOO_ECPB_URI.'/assets/images/woo-logo-vector.png","backgroundColor":"#edf1e4"},"id":"id1490886694686RAND36391","component":"imageTemplate"},{"type":"title","options":{"align":"center","title":"Cancelled Order ","subTitle":"","padding":["30px","50px","30px","50px"],"backgroundColor":"#edf1e4","color":"#444444"},"id":"id1488518155120RAND69788","component":"titleTemplate"},{"type":"text","options":{"padding":["10px","50px","10px","50px"],"backgroundColor":"#ffffff","text":"<p><span style=\\\"font-size: 11pt; color: #333333; line-height: 2;\\\" data-mce-style=\\\"font-size: 11pt; color: #333333; line-height: 2;\\\">We have sorry that you have cancelled an order from admin. The order details are as follows:</span></p>"},"id":"id1490764498153RAND65131","component":"textTemplate"},{"type":"itemTable","options":{"padding":["15px","50px","15px","50px"],"width":"370","backgroundColor":"#ffffff","text":"<p style=\\\"line-height: 22px;\\\" data-mce-style=\\\"line-height: 22px;\\\"><span style=\\\"color: rgb(51, 51, 51);\\\" data-mce-style=\\\"color: #333333;\\\">[woo_mb_items]</span></p>"},"id":"id1490764579914RAND55712","component":"itemTableTemplate"},{"type":"imageText2x2","options":{"padding":["15px","50px","15px","50px"],"width1":"255","width2":"255","backgroundColor":"#ffffff","text1":"<p><span style=\\\"color: rgb(51, 51, 51);\\\" data-mce-style=\\\"color: #333333;\\\"><strong><span style=\\\"font-size: 12pt;\\\" data-mce-style=\\\"font-size: 12pt;\\\">Shipping Address:</span></strong></span></p><p><span style=\\\"font-size: 11pt; color: rgb(51, 51, 51);\\\" data-mce-style=\\\"font-size: 11pt; color: #333333;\\\">[woo_mb_shipping_address]</span></p>","text2":"<p><span style=\\\"font-size: 12pt; color: rgb(51, 51, 51);\\\" data-mce-style=\\\"font-size: 12pt; color: #333333;\\\"><strong>Order Date: </strong><span style=\\\"font-size: 11pt;\\\" data-mce-style=\\\"font-size: 11pt;\\\">[woo_mb_order_date]</span></span></p><p style=\\\"margin-bottom: 8px;\\\" data-mce-style=\\\"margin-bottom: 8px;\\\"><span style=\\\"font-size: 12pt; color: rgb(51, 51, 51);\\\" data-mce-style=\\\"font-size: 12pt; color: #333333;\\\"><strong>Customer Information:</strong></span></p><p style=\\\"margin: 8px 0px;\\\" data-mce-style=\\\"margin: 8px 0px;\\\"><span style=\\\"font-size: 11pt; line-height: 2;\\\" data-mce-style=\\\"font-size: 11pt; line-height: 2;\\\"><span style=\\\"color: rgb(51, 51, 51);\\\" data-mce-style=\\\"color: #333333;\\\">[woo_mb_billing_first_name]</span><br><span style=\\\"color: rgb(51, 51, 51);\\\" data-mce-style=\\\"color: #333333;\\\">[woo_mb_user_email]</span> </span></p>"},"id":"id1490764605268RAND69832","component":"imageText2x2Template"},{"type":"divider","options":{"padding":["15px","50px","0px","50px"],"backgroundColor":"#ffffff"},"id":"id1490765637838RAND49930","component":"dividerTemplate"},{"type":"text","options":{"padding":["10px","50px","10px","50px"],"backgroundColor":"#ffffff","text":"<p><span style=\\\"font-size: 11pt; color: rgb(51, 51, 51);\\\" data-mce-style=\\\"font-size: 11pt; color: #333333;\\\">Feel free to contact us if you have any questions,</span></p><p><span style=\\\"font-size: 11pt; color: rgb(51, 51, 51);\\\" data-mce-style=\\\"font-size: 11pt; color: #333333;\\\">Sincerely,</span></p><p><span style=\\\"font-size: 11pt; color: rgb(51, 51, 51);\\\" data-mce-style=\\\"font-size: 11pt; color: #333333;\\\">Mystore Team.</span></p><p><span style=\\\"font-size: 11pt; color: rgb(51, 51, 51);\\\" data-mce-style=\\\"font-size: 11pt; color: #333333;\\\"><br data-mce-bogus=\\\"1\\\"></span></p>"},"id":"id1490765641364RAND61250","component":"textTemplate"},{"type":"unsubscribe","options":{"padding":["10px","50px","10px","50px"],"backgroundColor":"#9c5d90","text":"<div class=\\\"text-center\\\"><p><span style=\\\"color: #dddddd; font-size: 11pt;\\\" data-mce-style=\\\"color: #dddddd; font-size: 11pt;\\\">My Store | <a style=\\\"color: #dddddd;\\\" href=\\\"http://www.mystore.com\\\" data-mce-href=\\\"http://www.mystore.com\\\" data-mce-style=\\\"color: #dddddd;\\\">www.mystore.com</a> | <a style=\\\"color: #dddddd;\\\" href=\\\"http://facebook.com\\\" data-mce-href=\\\"http://facebook.com\\\" data-mce-style=\\\"color: #dddddd;\\\">Facebook<span id=\\\"_mce_caret\\\" data-mce-bogus=\\\"true\\\"><span style=\\\"color: #dddddd;\\\" data-mce-style=\\\"color: #dddddd;\\\"></span></span></a></span><br data-mce-bogus=\\\"1\\\"></p></div>"},"id":"id1488518077811RAND52665","component":"unsubscribeTemplate"}],"html":"<html><head><meta http-equiv=\\\"Content-Type\\\" content=\\\"text/html; charset=UTF-8\\\"><meta name=\\\"viewport\\\" content=\\\"width=device-width\\\" initial-scale=\\\"1.0\\\" user-scalable=\\\"yes\\\"></head><body style=\\\"background: rgb(237, 241, 228) none repeat scroll 0% 0%; padding: 50px 5px;\\\"><table data-type=\\\"image\\\" class=\\\"em-main\\\" style=\\\"display: table; background-color: rgb(237, 241, 228);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" align=\\\"center\\\"><tbody><tr><td class=\\\"em-image\\\" style=\\\"padding: 15px 50px;\\\" align=\\\"center\\\"><img src=\\\"'.WOO_ECPB_URI.'/assets/images/woo-logo-vector.png\\\" tabindex=\\\"0\\\" style=\\\"display: block; max-width: 100%;\\\" border=\\\"0\\\"></td></tr></tbody></table>    <table data-type=\\\"title\\\" class=\\\"em-main\\\" style=\\\"display: table; background-color: rgb(237, 241, 228);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" align=\\\"center\\\"><tbody><tr><td data-block-id=\\\"background\\\" class=\\\"em-title\\\" style=\\\"color: rgb(117, 117, 117); padding: 30px 50px;\\\" align=\\\"center\\\"><h1 data-block-id=\\\"main-title\\\" style=\\\"font-family: Arial,sans-serif; margin: 0px; font-weight: 800; line-height: 42px; font-size: 36px; color: rgb(68, 68, 68);\\\">Cancelled Order </h1> <!----></td></tr></tbody></table>    <table data-type=\\\"text-block\\\" class=\\\"em-main\\\" style=\\\"display: table; background-color: rgb(255, 255, 255);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" align=\\\"center\\\"><tbody><tr><td data-block-id=\\\"background\\\" class=\\\"em-block-text\\\" style=\\\"font-size: 13px; color: rgb(0, 0, 0); line-height: 22px; padding: 10px 50px;\\\" align=\\\"left\\\"><p><span style=\\\"font-size: 11pt; color: #333333; line-height: 2;\\\" data-mce-style=\\\"font-size: 11pt; color: #333333; line-height: 2;\\\">We have sorry that you have cancelled an order from admin. The order details are as follows:</span></p></td></tr></tbody></table>    <table data-type=\\\"itemTable\\\" class=\\\"em-main\\\" style=\\\"display: table; background-color: rgb(255, 255, 255);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" bgcolor=\\\"#FFFFFF\\\" align=\\\"center\\\"><tbody><tr><td class=\\\"em-image-text\\\" style=\\\"font-family: Arial,serif; font-size: 13px; color: rgb(0, 0, 0); line-height: 22px; padding: 15px 50px;\\\" align=\\\"left\\\"><div><p style=\\\"line-height: 22px;\\\" data-mce-style=\\\"line-height: 22px;\\\"><span style=\\\"color: rgb(51, 51, 51);\\\" data-mce-style=\\\"color: #333333;\\\"></span></p>[woo_mb_items]<p></p></div></td></tr></tbody></table>    <table data-type=\\\"imageText2x2Template\\\" class=\\\"em-main\\\" style=\\\"display: table; background-color: rgb(255, 255, 255);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" bgcolor=\\\"#FFFFFF\\\" align=\\\"center\\\"><tbody><tr><td><table class=\\\"em-main\\\" style=\\\"display: table;\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" align=\\\"center\\\"><tbody><tr><td data-block-id=\\\"background\\\" class=\\\"em-image-caption\\\" style=\\\"padding: 15px 50px;\\\"><table class=\\\"em-image-caption-column\\\" width=\\\"255\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" align=\\\"left\\\"><tbody><tr><td class=\\\"em-image-caption-content\\\"><img style=\\\"display: block;\\\" width=\\\"255\\\" border=\\\"0\\\" align=\\\"2\\\"></td></tr> <tr><td class=\\\"em-image-caption-content text\\\" style=\\\"font-family: Arial,serif; font-size: 13px; color: rgb(0, 0, 0); line-height: 22px;\\\" align=\\\"left\\\"><p><span style=\\\"color: rgb(51, 51, 51);\\\" data-mce-style=\\\"color: #333333;\\\"><strong><span style=\\\"font-size: 12pt;\\\" data-mce-style=\\\"font-size: 12pt;\\\">Shipping Address:</span></strong></span></p><p><span style=\\\"font-size: 11pt; color: rgb(51, 51, 51);\\\" data-mce-style=\\\"font-size: 11pt; color: #333333;\\\"></span></p>[woo_mb_shipping_address]<p></p></td></tr> <tr><td class=\\\"em-image-caption-bottom-gap\\\" width=\\\"100%\\\" height=\\\"5\\\"></td></tr></tbody></table> <table class=\\\"em-image-caption-column\\\" width=\\\"255\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" align=\\\"right\\\"><tbody><tr><td class=\\\"em-image-caption-content\\\"><img style=\\\"display: block;\\\" width=\\\"255\\\" border=\\\"0\\\" align=\\\"2\\\"></td></tr> <tr><td class=\\\"em-image-caption-content text\\\" style=\\\"font-family: Arial,serif; font-size: 13px; color: rgb(0, 0, 0); line-height: 22px;\\\" align=\\\"left\\\"><p><span style=\\\"font-size: 12pt; color: rgb(51, 51, 51);\\\" data-mce-style=\\\"font-size: 12pt; color: #333333;\\\"><strong>Order Date: </strong><span style=\\\"font-size: 11pt;\\\" data-mce-style=\\\"font-size: 11pt;\\\"></span></span></p>[woo_mb_order_date]<p></p><p style=\\\"margin-bottom: 8px;\\\" data-mce-style=\\\"margin-bottom: 8px;\\\"><span style=\\\"font-size: 12pt; color: rgb(51, 51, 51);\\\" data-mce-style=\\\"font-size: 12pt; color: #333333;\\\"><strong>Customer Information:</strong></span></p><p style=\\\"margin: 8px 0px;\\\" data-mce-style=\\\"margin: 8px 0px;\\\"><span style=\\\"font-size: 11pt; line-height: 2;\\\" data-mce-style=\\\"font-size: 11pt; line-height: 2;\\\"><span style=\\\"color: rgb(51, 51, 51);\\\" data-mce-style=\\\"color: #333333;\\\"></span></span></p>[woo_mb_billing_first_name]<br><span style=\\\"color: rgb(51, 51, 51);\\\" data-mce-style=\\\"color: #333333;\\\">[woo_mb_user_email]</span> <p></p></td></tr> <tr><td width=\\\"100%\\\" height=\\\"5\\\"></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table>    <table data-type=\\\"divider\\\" class=\\\"em-main\\\" style=\\\"border: 0px none; display: table; background-color: rgb(255, 255, 255);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" align=\\\"center\\\"><tbody><tr><td class=\\\"em-divider-simple\\\" style=\\\"padding: 15px 50px 0px;\\\"><table style=\\\"border-top: 1px solid rgb(218, 223, 225);\\\" width=\\\"100%\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\"><tbody><tr><td width=\\\"100%\\\" height=\\\"15px\\\"></td></tr></tbody></table></td></tr></tbody></table>    <table data-type=\\\"text-block\\\" class=\\\"em-main\\\" style=\\\"display: table; background-color: rgb(255, 255, 255);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" align=\\\"center\\\"><tbody><tr><td data-block-id=\\\"background\\\" class=\\\"em-block-text\\\" style=\\\"font-size: 13px; color: rgb(0, 0, 0); line-height: 22px; padding: 10px 50px;\\\" align=\\\"left\\\"><p><span style=\\\"font-size: 11pt; color: rgb(51, 51, 51);\\\" data-mce-style=\\\"font-size: 11pt; color: #333333;\\\">Feel free to contact us if you have any questions,</span></p><p><span style=\\\"font-size: 11pt; color: rgb(51, 51, 51);\\\" data-mce-style=\\\"font-size: 11pt; color: #333333;\\\">Sincerely,</span></p><p><span style=\\\"font-size: 11pt; color: rgb(51, 51, 51);\\\" data-mce-style=\\\"font-size: 11pt; color: #333333;\\\">Mystore Team.</span></p><p><span style=\\\"font-size: 11pt; color: rgb(51, 51, 51);\\\" data-mce-style=\\\"font-size: 11pt; color: #333333;\\\"><br data-mce-bogus=\\\"1\\\"></span></p></td></tr></tbody></table>    <table data-type=\\\"text-block\\\" class=\\\"em-main\\\" style=\\\"display: table; background-color: rgb(156, 93, 144);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" align=\\\"center\\\"><tbody><tr><td data-block-id=\\\"background\\\" style=\\\"font-family: Arial,serif; font-size: 13px; color: rgb(0, 0, 0); line-height: 22px; padding: 10px 50px;\\\" align=\\\"left\\\"><div class=\\\"text-center\\\"><p><span style=\\\"color: rgb(255, 255, 255); font-size: 11pt;\\\" data-mce-style=\\\"color: #dddddd; font-size: 11pt;\\\">My Store | <a style=\\\"color: #dddddd;\\\" href=\\\"http://www.mystore.com\\\" data-mce-href=\\\"http://www.mystore.com\\\" data-mce-style=\\\"color: #dddddd;\\\">www.mystore.com</a> | <a style=\\\"color: #v;\\\" href=\\\"http://facebook.com\\\" data-mce-href=\\\"http://facebook.com\\\" data-mce-style=\\\"color: #dddddd;\\\">Facebook<span id=\\\"_mce_caret\\\" data-mce-bogus=\\\"true\\\"><span style=\\\"color: rgb(255, 255, 255);\\\" data-mce-style=\\\"color: #dddddd;\\\"></span></span></a></span><br data-mce-bogus=\\\"1\\\"></p></div></td></tr></tbody></table>    </body></html>","emailSettings":{"options":{"paddingTop":"50px","paddingLeft":"5px","paddingBottom":"50px","paddingRight":"5px","backgroundColor":"#edf1e4"},"type":"emailSettings"}}'
    );

    // 3. Failed order
    $mail_templates['failed_order'] = array(
    	'post_type' 	=> 'woo_mb_template',
    	'post_title' 	=> 'failed_order',
    	'post_name' 	=> 'en_us',
    	'post_content'  => '{"elements":[{"type":"image","options":{"align":"center","padding":["15px","50px","15px","50px"],"image":"'.WOO_ECPB_URI.'/assets/images/woo-logo-vector.png","backgroundColor":"#edf1e4"},"id":"id1490886745861RAND68591","component":"imageTemplate"},{"type":"title","options":{"align":"center","title":"Failed Order","subTitle":"","padding":["30px","50px","30px","50px"],"backgroundColor":"#edf1e4","color":"#444444"},"id":"id1488524636518RAND58079","component":"titleTemplate"},{"type":"text","options":{"padding":["10px","50px","10px","50px"],"backgroundColor":"#ffffff","text":"<p><span style=\\\"font-size: 11pt; color: #333333; line-height: 2;\\\" data-mce-style=\\\"font-size: 11pt; color: #333333; line-height: 2;\\\">We are really sorry that your order #[woo_mb_order_id] could not be processed at this time. The order details are as follows:</span></p>"},"id":"id1490765925296RAND23945","component":"textTemplate"},{"type":"itemTable","options":{"padding":["15px","50px","15px","50px"],"width":"370","backgroundColor":"#ffffff","text":"<p style=\\\"line-height: 22px;\\\" data-mce-style=\\\"line-height: 22px;\\\"><span style=\\\"color: rgb(51, 51, 51);\\\" data-mce-style=\\\"color: #333333;\\\">[woo_mb_items]</span></p>"},"id":"id1490766036596RAND70761","component":"itemTableTemplate"},{"type":"text","options":{"padding":["10px","50px","10px","50px"],"backgroundColor":"#ffffff","text":"<p><span style=\\\"font-size: 11pt; color: rgb(51, 51, 51);\\\" data-mce-style=\\\"font-size: 11pt; color: #333333;\\\">Please get in touch with us if you have any questions.</span><br></p><p><span style=\\\"font-size: 11pt; color: rgb(51, 51, 51);\\\" data-mce-style=\\\"font-size: 11pt; color: #333333;\\\"><br data-mce-bogus=\\\"1\\\"></span></p>"},"id":"id1490766100962RAND26992","component":"textTemplate"},{"type":"unsubscribe","options":{"padding":["10px","50px","10px","50px"],"backgroundColor":"#9c5d90","text":"<div class=\\\"text-center\\\"><p><span style=\\\"color: #dddddd; font-size: 11pt;\\\" data-mce-style=\\\"color: #dddddd; font-size: 11pt;\\\">My Store | <a style=\\\"color: #dddddd;\\\" href=\\\"http://www.mystore.com\\\" data-mce-href=\\\"http://www.mystore.com\\\" data-mce-style=\\\"color: #dddddd;\\\">www.mystore.com</a> | <a style=\\\"color: #dddddd;\\\" href=\\\"http://facebook.com\\\" data-mce-href=\\\"http://facebook.com\\\" data-mce-style=\\\"color: #dddddd;\\\">Facebook</a></span><br data-mce-bogus=\\\"1\\\"></p></div>"},"id":"id1488524767967RAND22012","component":"unsubscribeTemplate"}],"html":"<html><head><meta http-equiv=\\\"Content-Type\\\" content=\\\"text/html; charset=UTF-8\\\"><meta name=\\\"viewport\\\" content=\\\"width=device-width\\\" initial-scale=\\\"1.0\\\" user-scalable=\\\"yes\\\"></head><body style=\\\"background: rgb(237, 241, 228) none repeat scroll 0% 0%; padding: 50px 5px;\\\"><table data-type=\\\"image\\\" class=\\\"em-main\\\" style=\\\"display: table; background-color: rgb(237, 241, 228);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" align=\\\"center\\\"><tbody><tr><td class=\\\"em-image\\\" style=\\\"padding: 15px 50px;\\\" align=\\\"center\\\"><img src=\\\"'.WOO_ECPB_URI.'/assets/images/woo-logo-vector.png\\\" tabindex=\\\"0\\\" style=\\\"display: block; max-width: 100%;\\\" border=\\\"0\\\"></td></tr></tbody></table>    <table data-type=\\\"title\\\" class=\\\"em-main\\\" style=\\\"display: table; background-color: rgb(237, 241, 228);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" align=\\\"center\\\"><tbody><tr><td data-block-id=\\\"background\\\" class=\\\"em-title\\\" style=\\\"color: rgb(117, 117, 117); padding: 30px 50px;\\\" align=\\\"center\\\"><h1 data-block-id=\\\"main-title\\\" style=\\\"font-family: Arial,sans-serif; margin: 0px; font-weight: 800; line-height: 42px; font-size: 36px; color: rgb(68, 68, 68);\\\">Failed Order</h1> <!----></td></tr></tbody></table>    <table data-type=\\\"text-block\\\" class=\\\"em-main\\\" style=\\\"display: table; background-color: rgb(255, 255, 255);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" align=\\\"center\\\"><tbody><tr><td data-block-id=\\\"background\\\" class=\\\"em-block-text\\\" style=\\\"font-size: 13px; color: rgb(0, 0, 0); line-height: 22px; padding: 10px 50px;\\\" align=\\\"left\\\"><p><span style=\\\"font-size: 11pt; color: #333333; line-height: 2;\\\" data-mce-style=\\\"font-size: 11pt; color: #333333; line-height: 2;\\\">We are really sorry that your order #</span></p>[woo_mb_order_id] could not be processed at this time. The order details are as follows:<p></p></td></tr></tbody></table>    <table data-type=\\\"itemTable\\\" class=\\\"em-main\\\" style=\\\"display: table; background-color: rgb(255, 255, 255);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" bgcolor=\\\"#FFFFFF\\\" align=\\\"center\\\"><tbody><tr><td class=\\\"em-image-text\\\" style=\\\"font-family: Arial,serif; font-size: 13px; color: rgb(0, 0, 0); line-height: 22px; padding: 15px 50px;\\\" align=\\\"left\\\"><div><p style=\\\"line-height: 22px;\\\" data-mce-style=\\\"line-height: 22px;\\\"><span style=\\\"color: rgb(51, 51, 51);\\\" data-mce-style=\\\"color: #333333;\\\"></span></p>[woo_mb_items]<p></p></div></td></tr></tbody></table>    <table data-type=\\\"text-block\\\" class=\\\"em-main\\\" style=\\\"display: table; background-color: rgb(255, 255, 255);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" align=\\\"center\\\"><tbody><tr><td data-block-id=\\\"background\\\" class=\\\"em-block-text\\\" style=\\\"font-size: 13px; color: rgb(0, 0, 0); line-height: 22px; padding: 10px 50px;\\\" align=\\\"left\\\"><p><span style=\\\"font-size: 11pt; color: rgb(51, 51, 51);\\\" data-mce-style=\\\"font-size: 11pt; color: #333333;\\\">Please get in touch with us if you have any questions.</span><br></p><p><span style=\\\"font-size: 11pt; color: rgb(51, 51, 51);\\\" data-mce-style=\\\"font-size: 11pt; color: #333333;\\\"><br data-mce-bogus=\\\"1\\\"></span></p></td></tr></tbody></table>    <table data-type=\\\"text-block\\\" class=\\\"em-main\\\" style=\\\"display: table; background-color: rgb(156, 93, 144);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" align=\\\"center\\\"><tbody><tr><td data-block-id=\\\"background\\\" style=\\\"font-family: Arial,serif; font-size: 13px; color: rgb(0, 0, 0); line-height: 22px; padding: 10px 50px;\\\" align=\\\"left\\\"><div class=\\\"text-center\\\"><p><span style=\\\"color: rgb(255, 255, 255); font-size: 11pt;\\\" data-mce-style=\\\"color: #dddddd; font-size: 11pt;\\\">My Store | <a style=\\\"color: #ffffff;\\\" href=\\\"http://www.mystore.com\\\" data-mce-href=\\\"http://www.mystore.com\\\" data-mce-style=\\\"color: #dddddd;\\\">www.mystore.com</a> | <a style=\\\"color: #dddddd;\\\" href=\\\"http://facebook.com\\\" data-mce-href=\\\"http://facebook.com\\\" data-mce-style=\\\"color: #dddddd;\\\">Facebook</a></span><br data-mce-bogus=\\\"1\\\"></p></div></td></tr></tbody></table>    </body></html>","emailSettings":{"options":{"paddingTop":"50px","paddingLeft":"5px","paddingBottom":"50px","paddingRight":"5px","backgroundColor":"#edf1e4"},"type":"emailSettings"}}'
    );

    // 4. customer_on_hold_order 
    $mail_templates['customer_on_hold_order'] = array(
    	'post_type' 	=> 'woo_mb_template',
    	'post_title' 	=> 'customer_on_hold_order',
    	'post_name' 	=> 'en_us',
    	'post_content'  => '{"elements":[{"type":"image","options":{"align":"center","padding":["15px","50px","15px","50px"],"image":"'.WOO_ECPB_URI.'/assets/images/woo-logo-vector.png","backgroundColor":"#edf1e4"},"id":"id1490886766453RAND93678","component":"imageTemplate"},{"type":"title","options":{"align":"center","title":"Order on hold","subTitle":"","padding":["30px","50px","30px","50px"],"backgroundColor":"#edf1e4","color":"#444444"},"id":"id1488524915998RAND36976","component":"titleTemplate"},{"type":"text","options":{"padding":["10px","50px","10px","50px"],"backgroundColor":"#ffffff","text":"<p><span style=\\\"font-size: 11pt; color: rgb(51, 51, 51);\\\" data-mce-style=\\\"font-size: 11pt; color: #333333;\\\">Dear <strong>[woo_mb_billing_first_name]</strong>,</span><br></p><p><span style=\\\"font-size: 11pt; color: rgb(51, 51, 51);\\\" data-mce-style=\\\"font-size: 11pt; color: #333333;\\\">Your order is on hold. The order details are as follows:</span></p>"},"id":"id1490766169832RAND74939","component":"textTemplate"},{"type":"itemTable","options":{"padding":["15px","50px","15px","50px"],"width":"370","backgroundColor":"#ffffff","text":"<p style=\\\"line-height: 22px;\\\" data-mce-style=\\\"line-height: 22px;\\\"><span style=\\\"color: rgb(51, 51, 51);\\\" data-mce-style=\\\"color: #333333;\\\">[woo_mb_items]</span></p>"},"id":"id1490766221822RAND82965","component":"itemTableTemplate"},{"type":"billingAddress","options":{"padding":["15px","50px","15px","50px"],"width":"370","backgroundColor":"#ffffff","text":"<div><span style=\\\"font-size: 12pt; color: rgb(51, 51, 51);\\\" data-mce-style=\\\"font-size: 12pt; color: #333333;\\\"><strong>Billing Address:</strong></span></div><p style=\\\"line-height: 22px;\\\" data-mce-style=\\\"line-height: 22px;\\\"><span style=\\\"font-size: 11pt; color: rgb(51, 51, 51);\\\" data-mce-style=\\\"font-size: 11pt; color: #333333;\\\">[woo_mb_billing_address]</span></p><p><span style=\\\"color: rgb(51, 51, 51);\\\" data-mce-style=\\\"color: #333333;\\\"><strong><span style=\\\"font-size: 12pt;\\\" data-mce-style=\\\"font-size: 12pt;\\\">Order Date:</span></strong> <span style=\\\"font-size: 11pt;\\\" data-mce-style=\\\"font-size: 11pt;\\\">[woo_mb_order_date]</span></span></p>"},"id":"id1490766233247RAND48675","component":"billingAddressTemplate"},{"type":"divider","options":{"padding":["15px","50px","0px","50px"],"backgroundColor":"#ffffff"},"id":"id1490769124242RAND25353","component":"dividerTemplate"},{"type":"text","options":{"padding":["10px","50px","10px","50px"],"backgroundColor":"#ffffff","text":"<p style=\\\"margin: 0px 0px 10px; line-height: 22px; font-size: 13px;\\\" data-block-id=\\\"text-area\\\" data-mce-style=\\\"margin: 0px 0px 10px; line-height: 22px; font-size: 13px;\\\"><span style=\\\"color: #333333; font-size: 11pt;\\\" data-mce-style=\\\"color: #333333; font-size: 11pt;\\\">We will be in touch with you as soon as we start processing the order.</span></p>"},"id":"id1490769139583RAND24690","component":"textTemplate"},{"type":"unsubscribe","options":{"padding":["10px","50px","10px","50px"],"backgroundColor":"#9c5d90","text":"<div class=\\\"text-center\\\"><p><span style=\\\"color: #dddddd; font-size: 11pt;\\\" data-mce-style=\\\"color: #dddddd; font-size: 11pt;\\\">My Store | <a style=\\\"color: #dddddd;\\\" href=\\\"http://www.mystore.com\\\" data-mce-href=\\\"http://www.mystore.com\\\" data-mce-style=\\\"color: #dddddd;\\\">www.mystore.com</a> | <a style=\\\"color: #dddddd;\\\" href=\\\"http://facebook.com\\\" data-mce-href=\\\"http://facebook.com\\\" data-mce-style=\\\"color: #dddddd;\\\">Facebook</a></span><br data-mce-bogus=\\\"1\\\"></p></div>"},"id":"id1488524877587RAND50354","component":"unsubscribeTemplate"}],"html":"<html><head><meta http-equiv=\\\"Content-Type\\\" content=\\\"text/html; charset=UTF-8\\\"><meta name=\\\"viewport\\\" content=\\\"width=device-width\\\" initial-scale=\\\"1.0\\\" user-scalable=\\\"yes\\\"></head><body style=\\\"background: rgb(237, 241, 228) none repeat scroll 0% 0%; padding: 50px 5px;\\\"><table data-type=\\\"image\\\" class=\\\"em-main\\\" style=\\\"display: table; background-color: rgb(237, 241, 228);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" align=\\\"center\\\"><tbody><tr><td class=\\\"em-image\\\" style=\\\"padding: 15px 50px;\\\" align=\\\"center\\\"><img src=\\\"'.WOO_ECPB_URI.'/assets/images/woo-logo-vector.png\\\" tabindex=\\\"0\\\" style=\\\"display: block; max-width: 100%;\\\" border=\\\"0\\\"></td></tr></tbody></table>    <table data-type=\\\"title\\\" class=\\\"em-main\\\" style=\\\"display: table; background-color: rgb(237, 241, 228);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" align=\\\"center\\\"><tbody><tr><td data-block-id=\\\"background\\\" class=\\\"em-title\\\" style=\\\"color: rgb(117, 117, 117); padding: 30px 50px;\\\" align=\\\"center\\\"><h1 data-block-id=\\\"main-title\\\" style=\\\"font-family: Arial,sans-serif; margin: 0px; font-weight: 800; line-height: 42px; font-size: 36px; color: rgb(68, 68, 68);\\\">Order on hold</h1> <!----></td></tr></tbody></table>    <table data-type=\\\"text-block\\\" class=\\\"em-main\\\" style=\\\"display: table; background-color: rgb(255, 255, 255);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" align=\\\"center\\\"><tbody><tr><td data-block-id=\\\"background\\\" class=\\\"em-block-text\\\" style=\\\"font-size: 13px; color: rgb(0, 0, 0); line-height: 22px; padding: 10px 50px;\\\" align=\\\"left\\\"><p><span style=\\\"font-size: 11pt; color: rgb(51, 51, 51);\\\" data-mce-style=\\\"font-size: 11pt; color: #333333;\\\">Dear <strong></strong></span></p>[woo_mb_billing_first_name],<br><p></p><p><span style=\\\"font-size: 11pt; color: rgb(51, 51, 51);\\\" data-mce-style=\\\"font-size: 11pt; color: #333333;\\\">Your order is on hold. The order details are as follows:</span></p></td></tr></tbody></table>    <table data-type=\\\"itemTable\\\" class=\\\"em-main\\\" style=\\\"display: table; background-color: rgb(255, 255, 255);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" bgcolor=\\\"#FFFFFF\\\" align=\\\"center\\\"><tbody><tr><td class=\\\"em-image-text\\\" style=\\\"font-family: Arial,serif; font-size: 13px; color: rgb(0, 0, 0); line-height: 22px; padding: 15px 50px;\\\" align=\\\"left\\\"><div><p style=\\\"line-height: 22px;\\\" data-mce-style=\\\"line-height: 22px;\\\"><span style=\\\"color: rgb(51, 51, 51);\\\" data-mce-style=\\\"color: #333333;\\\"></span></p>[woo_mb_items]<p></p></div></td></tr></tbody></table>    <table data-type=\\\"billingAddress\\\" class=\\\"em-main\\\" style=\\\"display: table; background-color: rgb(255, 255, 255);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" bgcolor=\\\"#FFFFFF\\\" align=\\\"center\\\"><tbody><tr><td class=\\\"em-image-text\\\" style=\\\"font-family: Arial,serif; font-size: 13px; color: rgb(0, 0, 0); line-height: 22px; padding: 15px 50px;\\\" align=\\\"left\\\"><div><div><span style=\\\"font-size: 12pt; color: rgb(51, 51, 51);\\\" data-mce-style=\\\"font-size: 12pt; color: #333333;\\\"><strong>Billing Address:</strong></span></div><p style=\\\"line-height: 22px;\\\" data-mce-style=\\\"line-height: 22px;\\\"><span style=\\\"font-size: 11pt; color: rgb(51, 51, 51);\\\" data-mce-style=\\\"font-size: 11pt; color: #333333;\\\"></span></p>[woo_mb_billing_address]<p></p><p><span style=\\\"color: rgb(51, 51, 51);\\\" data-mce-style=\\\"color: #333333;\\\"><strong><span style=\\\"font-size: 12pt;\\\" data-mce-style=\\\"font-size: 12pt;\\\">Order Date:</span></strong> <span style=\\\"font-size: 11pt;\\\" data-mce-style=\\\"font-size: 11pt;\\\"></span></span></p>[woo_mb_order_date]<p></p></div></td></tr></tbody></table>    <table data-type=\\\"divider\\\" class=\\\"em-main\\\" style=\\\"border: 0px none; display: table; background-color: rgb(255, 255, 255);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" align=\\\"center\\\"><tbody><tr><td class=\\\"em-divider-simple\\\" style=\\\"padding: 15px 50px 0px;\\\"><table style=\\\"border-top: 1px solid rgb(218, 223, 225);\\\" width=\\\"100%\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\"><tbody><tr><td width=\\\"100%\\\" height=\\\"15px\\\"></td></tr></tbody></table></td></tr></tbody></table>    <table data-type=\\\"text-block\\\" class=\\\"em-main\\\" style=\\\"display: table; background-color: rgb(255, 255, 255);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" align=\\\"center\\\"><tbody><tr><td data-block-id=\\\"background\\\" class=\\\"em-block-text\\\" style=\\\"font-size: 13px; color: rgb(0, 0, 0); line-height: 22px; padding: 10px 50px;\\\" align=\\\"left\\\"><p style=\\\"margin: 0px 0px 10px; line-height: 22px; font-size: 13px;\\\" data-block-id=\\\"text-area\\\" data-mce-style=\\\"margin: 0px 0px 10px; line-height: 22px; font-size: 13px;\\\"><span style=\\\"color: #333333; font-size: 11pt;\\\" data-mce-style=\\\"color: #333333; font-size: 11pt;\\\">We will be in touch with you as soon as we start processing the order.</span></p></td></tr></tbody></table>    <table data-type=\\\"text-block\\\" class=\\\"em-main\\\" style=\\\"display: table; background-color: rgb(156, 93, 144);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" align=\\\"center\\\"><tbody><tr><td data-block-id=\\\"background\\\" style=\\\"font-family: Arial,serif; font-size: 13px; color: rgb(0, 0, 0); line-height: 22px; padding: 10px 50px;\\\" align=\\\"left\\\"><div class=\\\"text-center\\\"><p><span style=\\\"color: rgb(255, 255, 255); font-size: 11pt;\\\" data-mce-style=\\\"color: #dddddd; font-size: 11pt;\\\">My Store | <a style=\\\"color: #dddddd;\\\" href=\\\"http://www.mystore.com\\\" data-mce-href=\\\"http://www.mystore.com\\\" data-mce-style=\\\"color: #dddddd;\\\">www.mystore.com</a> | <a style=\\\"color: #dddddd;\\\" href=\\\"http://facebook.com\\\" data-mce-href=\\\"http://facebook.com\\\" data-mce-style=\\\"color: #dddddd;\\\">Facebook</a></span><br data-mce-bogus=\\\"1\\\"></p></div></td></tr></tbody></table>    </body></html>","emailSettings":{"options":{"paddingTop":"50px","paddingLeft":"5px","paddingBottom":"50px","paddingRight":"5px","backgroundColor":"#edf1e4"},"type":"emailSettings"}}'
    );

    // 5. customer_processing_order
    $mail_templates['customer_processing_order'] = array(
    	'post_type' 	=> 'woo_mb_template',
    	'post_title' 	=> 'customer_processing_order',
    	'post_name' 	=> 'en_us',
    	'post_content'  => '{"elements":[{"type":"image","options":{"align":"center","padding":["15px","50px","15px","50px"],"image":"'.WOO_ECPB_URI.'/assets/images/woo-logo-vector.png","backgroundColor":"#edf1e4"},"id":"id1490886778323RAND72418","component":"imageTemplate"},{"type":"title","options":{"align":"center","title":"Processing Order","subTitle":"","padding":["30px","50px","30px","50px"],"backgroundColor":"#edf1e4","color":"#444444"},"id":"id1488525617254RAND23501","component":"titleTemplate"},{"type":"text","options":{"padding":["10px","50px","10px","50px"],"backgroundColor":"#ffffff","text":"<p><span style=\\\"font-size: 11pt; color: rgb(51, 51, 51);\\\" data-mce-style=\\\"font-size: 11pt; color: #333333;\\\">Your order has been received, and is now being processed.</span><br></p>"},"id":"id1490766497446RAND64980","component":"textTemplate"},{"type":"itemTable","options":{"padding":["15px","50px","15px","50px"],"width":"370","backgroundColor":"#ffffff","text":"<p style=\\\"line-height: 22px;\\\">[woo_mb_items]</p>"},"id":"id1490766919190RAND41722","component":"itemTableTemplate"},{"type":"billingAddress","options":{"padding":["15px","50px","15px","50px"],"width":"370","backgroundColor":"#ffffff","text":"<div><span style=\\\"font-size: 12pt; color: #333333;\\\"><strong>Billing Address:</strong></span></div><p style=\\\"line-height: 22px;\\\"><span style=\\\"font-size: 11pt; color: #333333;\\\">[woo_mb_billing_address]</span></p>"},"id":"id1490766867596RAND33688","component":"billingAddressTemplate"},{"type":"divider","options":{"padding":["15px","50px","0px","50px"],"backgroundColor":"#ffffff"},"id":"id1490766931287RAND45766","component":"dividerTemplate"},{"type":"text","options":{"padding":["10px","50px","10px","50px"],"backgroundColor":"#ffffff","text":"<p><span style=\\\"font-size: 11pt; color: rgb(51, 51, 51);\\\" data-mce-style=\\\"font-size: 11pt; color: #333333;\\\">Feel free to contact us if you have any questions,</span><br></p><p><span style=\\\"font-size: 11pt; color: rgb(51, 51, 51);\\\" data-mce-style=\\\"font-size: 11pt; color: #333333;\\\">Sincerely,</span></p><p><span style=\\\"font-size: 11pt; color: rgb(51, 51, 51);\\\" data-mce-style=\\\"font-size: 11pt; color: #333333;\\\">Mystore Team.</span></p><p><span style=\\\"font-size: 11pt; color: rgb(51, 51, 51);\\\" data-mce-style=\\\"font-size: 11pt; color: #333333;\\\"><br data-mce-bogus=\\\"1\\\"></span></p>"},"id":"id1490766941254RAND24051","component":"textTemplate"},{"type":"unsubscribe","options":{"padding":["10px","50px","10px","50px"],"backgroundColor":"#9c5d90","text":"<div class=\\\"text-center\\\"><p><span style=\\\"color: #dddddd; font-size: 11pt;\\\" data-mce-style=\\\"color: #dddddd; font-size: 11pt;\\\">My Store | <a style=\\\"color: #dddddd;\\\" href=\\\"http://www.mystore.com\\\" data-mce-href=\\\"http://www.mystore.com\\\" data-mce-style=\\\"color: #dddddd;\\\">www.mystore.com</a> | <a style=\\\"color: #dddddd;\\\" href=\\\"http://facebook.com\\\" data-mce-href=\\\"http://facebook.com\\\" data-mce-style=\\\"color: #dddddd;\\\">Facebook</a></span><br data-mce-bogus=\\\"1\\\"></p></div>"},"id":"id1488525440843RAND92496","component":"unsubscribeTemplate"}],"html":"<html><head><meta http-equiv=\\\"Content-Type\\\" content=\\\"text/html; charset=UTF-8\\\"><meta name=\\\"viewport\\\" content=\\\"width=device-width\\\" initial-scale=\\\"1.0\\\" user-scalable=\\\"yes\\\"></head><body style=\\\"background: rgb(237, 241, 228) none repeat scroll 0% 0%; padding: 50px 5px;\\\"><table data-type=\\\"image\\\" class=\\\"em-main\\\" style=\\\"display: table; background-color: rgb(237, 241, 228);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" align=\\\"center\\\"><tbody><tr><td class=\\\"em-image\\\" style=\\\"padding: 15px 50px;\\\" align=\\\"center\\\"><img src=\\\"'.WOO_ECPB_URI.'/assets/images/woo-logo-vector.png\\\" tabindex=\\\"0\\\" style=\\\"display: block; max-width: 100%;\\\" border=\\\"0\\\"></td></tr></tbody></table>    <table data-type=\\\"title\\\" class=\\\"em-main\\\" style=\\\"display: table; background-color: rgb(237, 241, 228);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" align=\\\"center\\\"><tbody><tr><td data-block-id=\\\"background\\\" class=\\\"em-title\\\" style=\\\"color: rgb(117, 117, 117); padding: 30px 50px;\\\" align=\\\"center\\\"><h1 data-block-id=\\\"main-title\\\" style=\\\"font-family: Arial,sans-serif; margin: 0px; font-weight: 800; line-height: 42px; font-size: 36px; color: rgb(68, 68, 68);\\\">Processing Order</h1> <!----></td></tr></tbody></table>    <table data-type=\\\"text-block\\\" class=\\\"em-main\\\" style=\\\"display: table; background-color: rgb(255, 255, 255);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" align=\\\"center\\\"><tbody><tr><td data-block-id=\\\"background\\\" class=\\\"em-block-text\\\" style=\\\"font-size: 13px; color: rgb(0, 0, 0); line-height: 22px; padding: 10px 50px;\\\" align=\\\"left\\\"><p><span style=\\\"font-size: 11pt; color: rgb(51, 51, 51);\\\" data-mce-style=\\\"font-size: 11pt; color: #333333;\\\">Your order has been received, and is now being processed.</span><br></p></td></tr></tbody></table>    <table data-type=\\\"itemTable\\\" class=\\\"em-main\\\" style=\\\"display: table; background-color: rgb(255, 255, 255);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" bgcolor=\\\"#FFFFFF\\\" align=\\\"center\\\"><tbody><tr><td class=\\\"em-image-text\\\" style=\\\"font-family: Arial,serif; font-size: 13px; color: rgb(0, 0, 0); line-height: 22px; padding: 15px 50px;\\\" align=\\\"left\\\"><div><p style=\\\"line-height: 22px;\\\"></p>[woo_mb_items]<p></p></div></td></tr></tbody></table>    <table data-type=\\\"billingAddress\\\" class=\\\"em-main\\\" style=\\\"display: table; background-color: rgb(255, 255, 255);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" bgcolor=\\\"#FFFFFF\\\" align=\\\"center\\\"><tbody><tr><td class=\\\"em-image-text\\\" style=\\\"font-family: Arial,serif; font-size: 13px; color: rgb(0, 0, 0); line-height: 22px; padding: 15px 50px;\\\" align=\\\"left\\\"><div><div><span style=\\\"font-size: 12pt; color: #333333;\\\"><strong>Billing Address:</strong></span></div><p style=\\\"line-height: 22px;\\\"><span style=\\\"font-size: 11pt; color: #333333;\\\"></span></p>[woo_mb_billing_address]<p></p></div></td></tr></tbody></table>    <table data-type=\\\"divider\\\" class=\\\"em-main\\\" style=\\\"border: 0px none; display: table; background-color: rgb(255, 255, 255);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" align=\\\"center\\\"><tbody><tr><td class=\\\"em-divider-simple\\\" style=\\\"padding: 15px 50px 0px;\\\"><table style=\\\"border-top: 1px solid rgb(218, 223, 225);\\\" width=\\\"100%\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\"><tbody><tr><td width=\\\"100%\\\" height=\\\"15px\\\"></td></tr></tbody></table></td></tr></tbody></table>    <table data-type=\\\"text-block\\\" class=\\\"em-main\\\" style=\\\"display: table; background-color: rgb(255, 255, 255);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" align=\\\"center\\\"><tbody><tr><td data-block-id=\\\"background\\\" class=\\\"em-block-text\\\" style=\\\"font-size: 13px; color: rgb(0, 0, 0); line-height: 22px; padding: 10px 50px;\\\" align=\\\"left\\\"><p><span style=\\\"font-size: 11pt; color: rgb(51, 51, 51);\\\" data-mce-style=\\\"font-size: 11pt; color: #333333;\\\">Feel free to contact us if you have any questions,</span><br></p><p><span style=\\\"font-size: 11pt; color: rgb(51, 51, 51);\\\" data-mce-style=\\\"font-size: 11pt; color: #333333;\\\">Sincerely,</span></p><p><span style=\\\"font-size: 11pt; color: rgb(51, 51, 51);\\\" data-mce-style=\\\"font-size: 11pt; color: #333333;\\\">Mystore Team.</span></p><p><span style=\\\"font-size: 11pt; color: rgb(51, 51, 51);\\\" data-mce-style=\\\"font-size: 11pt; color: #333333;\\\"><br data-mce-bogus=\\\"1\\\"></span></p></td></tr></tbody></table>    <table data-type=\\\"text-block\\\" class=\\\"em-main\\\" style=\\\"display: table; background-color: rgb(156, 93, 144);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" align=\\\"center\\\"><tbody><tr><td data-block-id=\\\"background\\\" style=\\\"font-family: Arial,serif; font-size: 13px; color: rgb(0, 0, 0); line-height: 22px; padding: 10px 50px;\\\" align=\\\"left\\\"><div class=\\\"text-center\\\"><p><span style=\\\"color: rgb(255, 255, 255); font-size: 11pt;\\\" data-mce-style=\\\"color: #dddddd; font-size: 11pt;\\\">My Store | <a style=\\\"color: #dddddd;\\\" href=\\\"http://www.mystore.com\\\" data-mce-href=\\\"http://www.mystore.com\\\" data-mce-style=\\\"color: #dddddd;\\\">www.mystore.com</a> | <a style=\\\"color: #dddddd;\\\" href=\\\"http://facebook.com\\\" data-mce-href=\\\"http://facebook.com\\\" data-mce-style=\\\"color: #dddddd;\\\">Facebook</a></span><br data-mce-bogus=\\\"1\\\"></p></div></td></tr></tbody></table>    </body></html>","emailSettings":{"options":{"paddingTop":"50px","paddingLeft":"5px","paddingBottom":"50px","paddingRight":"5px","backgroundColor":"#edf1e4"},"type":"emailSettings"}}'
    );

    // 6. customer_completed_order
    $mail_templates['customer_completed_order'] = array(
    	'post_type' 	=> 'woo_mb_template',
    	'post_title' 	=> 'customer_completed_order',
    	'post_name' 	=> 'en_us',
    	'post_content'  => '{"elements":[{"type":"image","options":{"align":"center","padding":["15px","50px","15px","50px"],"image":"'.WOO_ECPB_URI.'/assets/images/woo-logo-vector.png","backgroundColor":"#edf1e4"},"id":"id1490886789527RAND38649","component":"imageTemplate"},{"type":"title","options":{"align":"center","title":"Completed Order","subTitle":"","padding":["30px","50px","30px","50px"],"backgroundColor":"#edf1e4","color":"#444444"},"id":"id1488525861577RAND44670","component":"titleTemplate"},{"type":"text","options":{"padding":["10px","50px","10px","50px"],"backgroundColor":"#ffffff","text":"<p><span style=\\\"font-size: 11pt; color: #333333; line-height: 2;\\\" data-mce-style=\\\"font-size: 11pt; color: #333333; line-height: 2;\\\">Howdy [woo_mb_billing_first_name]. Your recent order on [woo_mb_site_name] has been completed. Your order details shown below for your reference: <br></span></p>"},"id":"id1490767060738RAND73192","component":"textTemplate"},{"type":"itemTable","options":{"padding":["15px","50px","15px","50px"],"width":"370","backgroundColor":"#ffffff","text":"<p style=\\\"line-height: 22px;\\\" data-mce-style=\\\"line-height: 22px;\\\">[woo_mb_items]</p>"},"id":"id1490767144172RAND82875","component":"itemTableTemplate"},{"type":"billingAddress","options":{"padding":["15px","50px","15px","50px"],"width":"370","backgroundColor":"#ffffff","text":"<div><span style=\\\"font-size: 12pt; color: #333333;\\\"><strong>Billing Address:</strong></span></div><p style=\\\"line-height: 22px;\\\"><span style=\\\"font-size: 11pt; color: #333333;\\\">[woo_mb_billing_address]</span></p>"},"id":"id1490767152734RAND74102","component":"billingAddressTemplate"},{"type":"divider","options":{"padding":["15px","50px","0px","50px"],"backgroundColor":"#ffffff"},"id":"id1490767159285RAND10313","component":"dividerTemplate"},{"type":"text","options":{"padding":["10px","50px","10px","50px"],"backgroundColor":"#ffffff","text":"<p><span style=\\\"font-size: 11pt; color: rgb(51, 51, 51);\\\" data-mce-style=\\\"font-size: 11pt; color: #333333;\\\">Feel free to contact us if you have any questions,</span><br></p><p><span style=\\\"font-size: 11pt; color: rgb(51, 51, 51);\\\" data-mce-style=\\\"font-size: 11pt; color: #333333;\\\">Sincerely,</span></p><p><span style=\\\"font-size: 11pt; color: rgb(51, 51, 51);\\\" data-mce-style=\\\"font-size: 11pt; color: #333333;\\\">Mystore Team.</span></p><p><span style=\\\"font-size: 11pt; color: rgb(51, 51, 51);\\\" data-mce-style=\\\"font-size: 11pt; color: #333333;\\\"><br data-mce-bogus=\\\"1\\\"></span></p>"},"id":"id1490767168274RAND34416","component":"textTemplate"},{"type":"unsubscribe","options":{"padding":["10px","50px","10px","50px"],"backgroundColor":"#9c5d90","text":"<div class=\\\"text-center\\\"><p><span style=\\\"color: #dddddd; font-size: 11pt;\\\" data-mce-style=\\\"color: #dddddd; font-size: 11pt;\\\">My Store | <a style=\\\"color: #dddddd;\\\" href=\\\"http://www.mystore.com\\\" data-mce-href=\\\"http://www.mystore.com\\\" data-mce-style=\\\"color: #dddddd;\\\">www.mystore.com</a> | <a style=\\\"color: #dddddd;\\\" href=\\\"http://facebook.com\\\" data-mce-href=\\\"http://facebook.com\\\" data-mce-style=\\\"color: #dddddd;\\\">Facebook</a></span><br data-mce-bogus=\\\"1\\\"></p></div>"},"id":"id1488525718375RAND98905","component":"unsubscribeTemplate"}],"html":"<html><head><meta http-equiv=\\\"Content-Type\\\" content=\\\"text/html; charset=UTF-8\\\"><meta name=\\\"viewport\\\" content=\\\"width=device-width\\\" initial-scale=\\\"1.0\\\" user-scalable=\\\"yes\\\"></head><body style=\\\"background: rgb(237, 241, 228) none repeat scroll 0% 0%; padding: 50px 5px;\\\"><table data-type=\\\"image\\\" class=\\\"em-main\\\" style=\\\"display: table; background-color: rgb(237, 241, 228);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" align=\\\"center\\\"><tbody><tr><td class=\\\"em-image\\\" style=\\\"padding: 15px 50px;\\\" align=\\\"center\\\"><img src=\\\"'.WOO_ECPB_URI.'/assets/images/woo-logo-vector.png\\\" tabindex=\\\"0\\\" style=\\\"display: block; max-width: 100%;\\\" border=\\\"0\\\"></td></tr></tbody></table>    <table data-type=\\\"title\\\" class=\\\"em-main\\\" style=\\\"display: table; background-color: rgb(237, 241, 228);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" align=\\\"center\\\"><tbody><tr><td data-block-id=\\\"background\\\" class=\\\"em-title\\\" style=\\\"color: rgb(117, 117, 117); padding: 30px 50px;\\\" align=\\\"center\\\"><h1 data-block-id=\\\"main-title\\\" style=\\\"font-family: Arial,sans-serif; margin: 0px; font-weight: 800; line-height: 42px; font-size: 36px; color: rgb(68, 68, 68);\\\">Completed Order</h1> <!----></td></tr></tbody></table>    <table data-type=\\\"text-block\\\" class=\\\"em-main\\\" style=\\\"display: table; background-color: rgb(255, 255, 255);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" align=\\\"center\\\"><tbody><tr><td data-block-id=\\\"background\\\" class=\\\"em-block-text\\\" style=\\\"font-size: 13px; color: rgb(0, 0, 0); line-height: 22px; padding: 10px 50px;\\\" align=\\\"left\\\"><p><span style=\\\"font-size: 11pt; color: #333333; line-height: 2;\\\" data-mce-style=\\\"font-size: 11pt; color: #333333; line-height: 2;\\\">Howdy </span></p>[woo_mb_billing_first_name]. Your recent order on [woo_mb_site_name] has been completed. Your order details shown below for your reference: <br><p></p></td></tr></tbody></table>    <table data-type=\\\"itemTable\\\" class=\\\"em-main\\\" style=\\\"display: table; background-color: rgb(255, 255, 255);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" bgcolor=\\\"#FFFFFF\\\" align=\\\"center\\\"><tbody><tr><td class=\\\"em-image-text\\\" style=\\\"font-family: Arial,serif; font-size: 13px; color: rgb(0, 0, 0); line-height: 22px; padding: 15px 50px;\\\" align=\\\"left\\\"><div><p style=\\\"line-height: 22px;\\\" data-mce-style=\\\"line-height: 22px;\\\"></p>[woo_mb_items]<p></p></div></td></tr></tbody></table>    <table data-type=\\\"billingAddress\\\" class=\\\"em-main\\\" style=\\\"display: table; background-color: rgb(255, 255, 255);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" bgcolor=\\\"#FFFFFF\\\" align=\\\"center\\\"><tbody><tr><td class=\\\"em-image-text\\\" style=\\\"font-family: Arial,serif; font-size: 13px; color: rgb(0, 0, 0); line-height: 22px; padding: 15px 50px;\\\" align=\\\"left\\\"><div><div><span style=\\\"font-size: 12pt; color: #333333;\\\"><strong>Billing Address:</strong></span></div><p style=\\\"line-height: 22px;\\\"><span style=\\\"font-size: 11pt; color: #333333;\\\"></span></p>[woo_mb_billing_address]<p></p></div></td></tr></tbody></table>    <table data-type=\\\"divider\\\" class=\\\"em-main\\\" style=\\\"border: 0px none; display: table; background-color: rgb(255, 255, 255);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" align=\\\"center\\\"><tbody><tr><td class=\\\"em-divider-simple\\\" style=\\\"padding: 15px 50px 0px;\\\"><table style=\\\"border-top: 1px solid rgb(218, 223, 225);\\\" width=\\\"100%\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\"><tbody><tr><td width=\\\"100%\\\" height=\\\"15px\\\"></td></tr></tbody></table></td></tr></tbody></table>    <table data-type=\\\"text-block\\\" class=\\\"em-main\\\" style=\\\"display: table; background-color: rgb(255, 255, 255);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" align=\\\"center\\\"><tbody><tr><td data-block-id=\\\"background\\\" class=\\\"em-block-text\\\" style=\\\"font-size: 13px; color: rgb(0, 0, 0); line-height: 22px; padding: 10px 50px;\\\" align=\\\"left\\\"><p><span style=\\\"font-size: 11pt; color: rgb(51, 51, 51);\\\" data-mce-style=\\\"font-size: 11pt; color: #333333;\\\">Feel free to contact us if you have any questions,</span><br></p><p><span style=\\\"font-size: 11pt; color: rgb(51, 51, 51);\\\" data-mce-style=\\\"font-size: 11pt; color: #333333;\\\">Sincerely,</span></p><p><span style=\\\"font-size: 11pt; color: rgb(51, 51, 51);\\\" data-mce-style=\\\"font-size: 11pt; color: #333333;\\\">Mystore Team.</span></p><p><span style=\\\"font-size: 11pt; color: rgb(51, 51, 51);\\\" data-mce-style=\\\"font-size: 11pt; color: #333333;\\\"><br data-mce-bogus=\\\"1\\\"></span></p></td></tr></tbody></table>    <table data-type=\\\"text-block\\\" class=\\\"em-main\\\" style=\\\"display: table; background-color: rgb(156, 93, 144);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" align=\\\"center\\\"><tbody><tr><td data-block-id=\\\"background\\\" style=\\\"font-family: Arial,serif; font-size: 13px; color: rgb(0, 0, 0); line-height: 22px; padding: 10px 50px;\\\" align=\\\"left\\\"><div class=\\\"text-center\\\"><p><span style=\\\"color: rgb(255, 255, 255); font-size: 11pt;\\\" data-mce-style=\\\"color: #dddddd; font-size: 11pt;\\\">My Store | <a style=\\\"color: #dddddd;\\\" href=\\\"http://www.mystore.com\\\" data-mce-href=\\\"http://www.mystore.com\\\" data-mce-style=\\\"color: #dddddd;\\\">www.mystore.com</a> | <a style=\\\"color: #dddddd;\\\" href=\\\"http://facebook.com\\\" data-mce-href=\\\"http://facebook.com\\\" data-mce-style=\\\"color: #dddddd;\\\">Facebook</a></span><br data-mce-bogus=\\\"1\\\"></p></div></td></tr></tbody></table>    </body></html>","emailSettings":{"options":{"paddingTop":"50px","paddingLeft":"5px","paddingBottom":"50px","paddingRight":"5px","backgroundColor":"#edf1e4"},"type":"emailSettings"}}'
    );

    // 7. customer_refunded_order
    $mail_templates['customer_refunded_order'] = array(
    	'post_type' 	=> 'woo_mb_template',
    	'post_title' 	=> 'customer_refunded_order',
    	'post_name' 	=> 'en_us',
    	'post_content'  => '{"elements":[{"type":"image","options":{"align":"center","padding":["15px","50px","15px","50px"],"image":"'.WOO_ECPB_URI.'/assets/images/woo-logo-vector.png","backgroundColor":"#edf1e4"},"id":"id1490886800324RAND4931","component":"imageTemplate"},{"type":"title","options":{"align":"center","title":"Order Refunded","subTitle":"","padding":["30px","50px","30px","50px"],"backgroundColor":"#edf1e4","color":"#444444"},"id":"id1488526128177RAND13076","component":"titleTemplate"},{"type":"text","options":{"padding":["10px","50px","10px","50px"],"backgroundColor":"#ffffff","text":"<p><span style=\\\"font-size: 11pt; color: rgb(51, 51, 51);\\\" data-mce-style=\\\"font-size: 11pt; color: #333333;\\\">Hi there, Your order on [woo_mb_site_name] has been refunded.</span><br data-mce-bogus=\\\"1\\\"></p>"},"id":"id1490767471550RAND44862","component":"textTemplate"},{"type":"itemTable","options":{"padding":["15px","50px","15px","50px"],"width":"370","backgroundColor":"#ffffff","text":"<p style=\\\"line-height: 22px;\\\">[woo_mb_items]</p>"},"id":"id1490767529029RAND33935","component":"itemTableTemplate"},{"type":"billingAddress","options":{"padding":["15px","50px","15px","50px"],"width":"370","backgroundColor":"#ffffff","text":"<div><span style=\\\"font-size: 12pt; color: #333333;\\\"><strong>Billing Address:</strong></span></div><p style=\\\"line-height: 22px;\\\"><span style=\\\"font-size: 11pt; color: #333333;\\\">[woo_mb_billing_address]</span></p>"},"id":"id1490767539118RAND20027","component":"billingAddressTemplate"},{"type":"divider","options":{"padding":["15px","50px","0px","50px"],"backgroundColor":"#ffffff"},"id":"id1490767545454RAND35819","component":"dividerTemplate"},{"type":"text","options":{"padding":["10px","50px","10px","50px"],"backgroundColor":"#ffffff","text":"<p><span style=\\\"font-size: 11pt; color: rgb(51, 51, 51);\\\" data-mce-style=\\\"font-size: 11pt; color: #333333;\\\">Feel free to contact us if you have any question,</span></p><p><span style=\\\"font-size: 11pt; color: rgb(51, 51, 51);\\\" data-mce-style=\\\"font-size: 11pt; color: #333333;\\\">Sincerely,</span></p><p><span style=\\\"font-size: 11pt; color: rgb(51, 51, 51);\\\" data-mce-style=\\\"font-size: 11pt; color: #333333;\\\">Mystore Team.</span></p><p><span style=\\\"font-size: 11pt; color: rgb(51, 51, 51);\\\" data-mce-style=\\\"font-size: 11pt; color: #333333;\\\"><br data-mce-bogus=\\\"1\\\"></span></p>"},"id":"id1490767556981RAND16973","component":"textTemplate"},{"type":"unsubscribe","options":{"padding":["10px","50px","10px","50px"],"backgroundColor":"#9c5d90","text":"<div class=\\\"text-center\\\"><p><span style=\\\"color: #dddddd; font-size: 11pt;\\\" data-mce-style=\\\"color: #dddddd; font-size: 11pt;\\\">My Store | <a style=\\\"color: #dddddd;\\\" href=\\\"http://www.mystore.com\\\" data-mce-href=\\\"http://www.mystore.com\\\" data-mce-style=\\\"color: #dddddd;\\\">www.mystore.com</a> | <a style=\\\"color: #dddddd;\\\" href=\\\"http://facebook.com\\\" data-mce-href=\\\"http://facebook.com\\\" data-mce-style=\\\"color: #dddddd;\\\">Facebook</a></span><br data-mce-bogus=\\\"1\\\"></p></div>"},"id":"id1488526027255RAND13343","component":"unsubscribeTemplate"}],"html":"<html><head><meta http-equiv=\\\"Content-Type\\\" content=\\\"text/html; charset=UTF-8\\\"><meta name=\\\"viewport\\\" content=\\\"width=device-width\\\" initial-scale=\\\"1.0\\\" user-scalable=\\\"yes\\\"></head><body style=\\\"background: rgb(237, 241, 228) none repeat scroll 0% 0%; padding: 50px 5px;\\\"><table data-type=\\\"image\\\" class=\\\"em-main\\\" style=\\\"display: table; background-color: rgb(237, 241, 228);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" align=\\\"center\\\"><tbody><tr><td class=\\\"em-image\\\" style=\\\"padding: 15px 50px;\\\" align=\\\"center\\\"><img src=\\\"'.WOO_ECPB_URI.'/assets/images/woo-logo-vector.png\\\" tabindex=\\\"0\\\" style=\\\"display: block; max-width: 100%;\\\" border=\\\"0\\\"></td></tr></tbody></table>    <table data-type=\\\"title\\\" class=\\\"em-main\\\" style=\\\"display: table; background-color: rgb(237, 241, 228);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" align=\\\"center\\\"><tbody><tr><td data-block-id=\\\"background\\\" class=\\\"em-title\\\" style=\\\"color: rgb(117, 117, 117); padding: 30px 50px;\\\" align=\\\"center\\\"><h1 data-block-id=\\\"main-title\\\" style=\\\"font-family: Arial,sans-serif; margin: 0px; font-weight: 800; line-height: 42px; font-size: 36px; color: rgb(68, 68, 68);\\\">Order Refunded</h1> <!----></td></tr></tbody></table>    <table data-type=\\\"text-block\\\" class=\\\"em-main\\\" style=\\\"display: table; background-color: rgb(255, 255, 255);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" align=\\\"center\\\"><tbody><tr><td data-block-id=\\\"background\\\" class=\\\"em-block-text\\\" style=\\\"font-size: 13px; color: rgb(0, 0, 0); line-height: 22px; padding: 10px 50px;\\\" align=\\\"left\\\"><p><span style=\\\"font-size: 11pt; color: rgb(51, 51, 51);\\\" data-mce-style=\\\"font-size: 11pt; color: #333333;\\\">Hi there, Your order on </span></p>[woo_mb_site_name] has been refunded.<br data-mce-bogus=\\\"1\\\"><p></p></td></tr></tbody></table>    <table data-type=\\\"itemTable\\\" class=\\\"em-main\\\" style=\\\"display: table; background-color: rgb(255, 255, 255);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" bgcolor=\\\"#FFFFFF\\\" align=\\\"center\\\"><tbody><tr><td class=\\\"em-image-text\\\" style=\\\"font-family: Arial,serif; font-size: 13px; color: rgb(0, 0, 0); line-height: 22px; padding: 15px 50px;\\\" align=\\\"left\\\"><div><p style=\\\"line-height: 22px;\\\"></p>[woo_mb_items]<p></p></div></td></tr></tbody></table>    <table data-type=\\\"billingAddress\\\" class=\\\"em-main\\\" style=\\\"display: table; background-color: rgb(255, 255, 255);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" bgcolor=\\\"#FFFFFF\\\" align=\\\"center\\\"><tbody><tr><td class=\\\"em-image-text\\\" style=\\\"font-family: Arial,serif; font-size: 13px; color: rgb(0, 0, 0); line-height: 22px; padding: 15px 50px;\\\" align=\\\"left\\\"><div><div><span style=\\\"font-size: 12pt; color: #333333;\\\"><strong>Billing Address:</strong></span></div><p style=\\\"line-height: 22px;\\\"><span style=\\\"font-size: 11pt; color: #333333;\\\"></span></p>[woo_mb_billing_address]<p></p></div></td></tr></tbody></table>    <table data-type=\\\"divider\\\" class=\\\"em-main\\\" style=\\\"border: 0px none; display: table; background-color: rgb(255, 255, 255);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" align=\\\"center\\\"><tbody><tr><td class=\\\"em-divider-simple\\\" style=\\\"padding: 15px 50px 0px;\\\"><table style=\\\"border-top: 1px solid rgb(218, 223, 225);\\\" width=\\\"100%\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\"><tbody><tr><td width=\\\"100%\\\" height=\\\"15px\\\"></td></tr></tbody></table></td></tr></tbody></table>    <table data-type=\\\"text-block\\\" class=\\\"em-main\\\" style=\\\"display: table; background-color: rgb(255, 255, 255);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" align=\\\"center\\\"><tbody><tr><td data-block-id=\\\"background\\\" class=\\\"em-block-text\\\" style=\\\"font-size: 13px; color: rgb(0, 0, 0); line-height: 22px; padding: 10px 50px;\\\" align=\\\"left\\\"><p><span style=\\\"font-size: 11pt; color: rgb(51, 51, 51);\\\" data-mce-style=\\\"font-size: 11pt; color: #333333;\\\">Feel free to contact us if you have any question,</span></p><p><span style=\\\"font-size: 11pt; color: rgb(51, 51, 51);\\\" data-mce-style=\\\"font-size: 11pt; color: #333333;\\\">Sincerely,</span></p><p><span style=\\\"font-size: 11pt; color: rgb(51, 51, 51);\\\" data-mce-style=\\\"font-size: 11pt; color: #333333;\\\">Mystore Team.</span></p><p><span style=\\\"font-size: 11pt; color: rgb(51, 51, 51);\\\" data-mce-style=\\\"font-size: 11pt; color: #333333;\\\"><br data-mce-bogus=\\\"1\\\"></span></p></td></tr></tbody></table>    <table data-type=\\\"text-block\\\" class=\\\"em-main\\\" style=\\\"display: table; background-color: rgb(156, 93, 144);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" align=\\\"center\\\"><tbody><tr><td data-block-id=\\\"background\\\" style=\\\"font-family: Arial,serif; font-size: 13px; color: rgb(0, 0, 0); line-height: 22px; padding: 10px 50px;\\\" align=\\\"left\\\"><div class=\\\"text-center\\\"><p><span style=\\\"color: rgb(255, 255, 255); font-size: 11pt;\\\" data-mce-style=\\\"color: #dddddd; font-size: 11pt;\\\">My Store | <a style=\\\"color: #dddddd;\\\" href=\\\"http://www.mystore.com\\\" data-mce-href=\\\"http://www.mystore.com\\\" data-mce-style=\\\"color: #dddddd;\\\">www.mystore.com</a> | <a style=\\\"color: #dddddd;\\\" href=\\\"http://facebook.com\\\" data-mce-href=\\\"http://facebook.com\\\" data-mce-style=\\\"color: #dddddd;\\\">Facebook</a></span><br data-mce-bogus=\\\"1\\\"></p></div></td></tr></tbody></table>    </body></html>","emailSettings":{"options":{"paddingTop":"50px","paddingLeft":"5px","paddingBottom":"50px","paddingRight":"5px","backgroundColor":"#edf1e4"},"type":"emailSettings"}}'
    );

    // 8. customer_invoice
    $mail_templates['customer_invoice'] = array(
    	'post_type' 	=> 'woo_mb_template',
    	'post_title' 	=> 'customer_invoice',
    	'post_name' 	=> 'en_us',
    	'post_content'  => '{"elements":[{"type":"image","options":{"align":"center","padding":["15px","50px","15px","50px"],"image":"'.WOO_ECPB_URI.'/assets/images/woo-logo-vector.png","backgroundColor":"#edf1e4"},"id":"id1490886879372RAND9294","component":"imageTemplate"},{"type":"title","options":{"align":"center","title":"Invoice","subTitle":"","padding":["30px","50px","30px","50px"],"backgroundColor":"#edf1e4","color":"#444444"},"id":"id1488526444949RAND88707","component":"titleTemplate"},{"type":"imageText2x2","options":{"padding":["15px","50px","15px","50px"],"width1":"255","width2":"255","backgroundColor":"#ffffff","text1":"<p style=\\\"text-align: left;\\\"><span style=\\\"font-size: 12pt;\\\"><strong>Shipping Address:</strong></span></p><p style=\\\"text-align: left;\\\"><span style=\\\"font-size: 11pt;\\\">[woo_mb_shipping_address]</span></p>","text2":"<p><span style=\\\"font-size: 12pt;\\\" data-mce-style=\\\"font-size: 12pt;\\\"><strong>Billing Address:</strong></span></p><p style=\\\"text-align: right;\\\" data-mce-style=\\\"text-align: right;\\\"><span style=\\\"font-size: 11pt;\\\" data-mce-style=\\\"font-size: 11pt;\\\">[woo_mb_billing_address]</span></p>"},"id":"id1490767667540RAND40887","component":"imageText2x2Template"},{"type":"itemTable","options":{"padding":["15px","50px","15px","50px"],"width":"370","backgroundColor":"#ffffff","text":"<p style=\\\"line-height: 22px;\\\">[woo_mb_items]</p>"},"id":"id1490767772755RAND56776","component":"itemTableTemplate"},{"type":"divider","options":{"padding":["15px","50px","0px","50px"],"backgroundColor":"#ffffff"},"id":"id1490767910023RAND16094","component":"dividerTemplate"},{"type":"text","options":{"padding":["10px","50px","10px","50px"],"backgroundColor":"#ffffff","text":"<p><span style=\\\"font-size: 11pt; color: #333333; line-height: 2;\\\" data-mce-style=\\\"font-size: 11pt; color: #333333; line-height: 2;\\\">Thank you for your order with [woo_mb_site_name]. Feel free to contact us, if you have any questions,</span></p><p><span style=\\\"font-size: 11pt; color: #333333;\\\" data-mce-style=\\\"font-size: 11pt; color: #333333;\\\">Sincerely,</span></p><p><span style=\\\"font-size: 11pt; color: #333333;\\\" data-mce-style=\\\"font-size: 11pt; color: #333333;\\\">Mystore Team.</span></p><p><span style=\\\"font-size: 11pt; color: #333333;\\\" data-mce-style=\\\"font-size: 11pt; color: #333333;\\\"><br data-mce-bogus=\\\"1\\\"></span></p>"},"id":"id1490767787660RAND75494","component":"textTemplate"},{"type":"unsubscribe","options":{"padding":["10px","50px","10px","50px"],"backgroundColor":"#9c5d90","text":"<div class=\\\"text-center\\\"><p><span style=\\\"color: #dddddd; font-size: 11pt;\\\" data-mce-style=\\\"color: #dddddd; font-size: 11pt;\\\">My Store | <a style=\\\"color: #dddddd;\\\" href=\\\"http://www.mystore.com\\\" data-mce-href=\\\"http://www.mystore.com\\\" data-mce-style=\\\"color: #dddddd;\\\">www.mystore.com</a> | <a style=\\\"color: #dddddd;\\\" href=\\\"http://facebook.com\\\" data-mce-href=\\\"http://facebook.com\\\" data-mce-style=\\\"color: #dddddd;\\\">Facebook</a></span><br data-mce-bogus=\\\"1\\\"></p></div>"},"id":"id1488526265403RAND2007","component":"unsubscribeTemplate"}],"html":"<html><head><meta http-equiv=\\\"Content-Type\\\" content=\\\"text/html; charset=UTF-8\\\"><meta name=\\\"viewport\\\" content=\\\"width=device-width\\\" initial-scale=\\\"1.0\\\" user-scalable=\\\"yes\\\"></head><body style=\\\"background: rgb(237, 241, 228) none repeat scroll 0% 0%; padding: 50px 5px;\\\"><table data-type=\\\"image\\\" class=\\\"em-main\\\" style=\\\"display: table; background-color: rgb(237, 241, 228);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" align=\\\"center\\\"><tbody><tr><td class=\\\"em-image\\\" style=\\\"padding: 15px 50px;\\\" align=\\\"center\\\"><img src=\\\"'.WOO_ECPB_URI.'/assets/images/woo-logo-vector.png\\\" tabindex=\\\"0\\\" style=\\\"display: block; max-width: 100%;\\\" border=\\\"0\\\"></td></tr></tbody></table>    <table data-type=\\\"title\\\" class=\\\"em-main\\\" style=\\\"display: table; background-color: rgb(237, 241, 228);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" align=\\\"center\\\"><tbody><tr><td data-block-id=\\\"background\\\" class=\\\"em-title\\\" style=\\\"color: rgb(117, 117, 117); padding: 30px 50px;\\\" align=\\\"center\\\"><h1 data-block-id=\\\"main-title\\\" style=\\\"font-family: Arial,sans-serif; margin: 0px; font-weight: 800; line-height: 42px; font-size: 36px; color: rgb(68, 68, 68);\\\">Invoice</h1> <!----></td></tr></tbody></table>    <table data-type=\\\"imageText2x2Template\\\" class=\\\"em-main\\\" style=\\\"display: table; background-color: rgb(255, 255, 255);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" bgcolor=\\\"#FFFFFF\\\" align=\\\"center\\\"><tbody><tr><td><table class=\\\"em-main\\\" style=\\\"display: table;\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" align=\\\"center\\\"><tbody><tr><td data-block-id=\\\"background\\\" class=\\\"em-image-caption\\\" style=\\\"padding: 15px 50px;\\\"><table class=\\\"em-image-caption-column\\\" width=\\\"255\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" align=\\\"left\\\"><tbody><tr><td class=\\\"em-image-caption-content\\\"><img style=\\\"display: block;\\\" width=\\\"255\\\" border=\\\"0\\\" align=\\\"2\\\"></td></tr> <tr><td class=\\\"em-image-caption-content text\\\" style=\\\"font-family: Arial,serif; font-size: 13px; color: rgb(0, 0, 0); line-height: 22px;\\\" align=\\\"left\\\"><p style=\\\"text-align: left;\\\"><span style=\\\"font-size: 12pt;\\\"><strong>Shipping Address:</strong></span></p><p style=\\\"text-align: left;\\\"><span style=\\\"font-size: 11pt;\\\"></span></p>[woo_mb_shipping_address]<p></p></td></tr> <tr><td class=\\\"em-image-caption-bottom-gap\\\" width=\\\"100%\\\" height=\\\"5\\\"></td></tr></tbody></table> <table class=\\\"em-image-caption-column\\\" width=\\\"255\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" align=\\\"right\\\"><tbody><tr><td class=\\\"em-image-caption-content\\\"><img style=\\\"display: block;\\\" width=\\\"255\\\" border=\\\"0\\\" align=\\\"2\\\"></td></tr> <tr><td class=\\\"em-image-caption-content text\\\" style=\\\"font-family: Arial,serif; font-size: 13px; color: rgb(0, 0, 0); line-height: 22px;\\\" align=\\\"left\\\"><p><span style=\\\"font-size: 12pt;\\\" data-mce-style=\\\"font-size: 12pt;\\\"><strong>Billing Address:</strong></span></p><p style=\\\"text-align: right;\\\" data-mce-style=\\\"text-align: right;\\\"><span style=\\\"font-size: 11pt;\\\" data-mce-style=\\\"font-size: 11pt;\\\"></span></p>[woo_mb_billing_address]<p></p></td></tr> <tr><td width=\\\"100%\\\" height=\\\"5\\\"></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table>    <table data-type=\\\"itemTable\\\" class=\\\"em-main\\\" style=\\\"display: table; background-color: rgb(255, 255, 255);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" bgcolor=\\\"#FFFFFF\\\" align=\\\"center\\\"><tbody><tr><td class=\\\"em-image-text\\\" style=\\\"font-family: Arial,serif; font-size: 13px; color: rgb(0, 0, 0); line-height: 22px; padding: 15px 50px;\\\" align=\\\"left\\\"><div><p style=\\\"line-height: 22px;\\\"></p>[woo_mb_items]<p></p></div></td></tr></tbody></table>    <table data-type=\\\"divider\\\" class=\\\"em-main\\\" style=\\\"border: 0px none; display: table; background-color: rgb(255, 255, 255);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" align=\\\"center\\\"><tbody><tr><td class=\\\"em-divider-simple\\\" style=\\\"padding: 15px 50px 0px;\\\"><table style=\\\"border-top: 1px solid rgb(218, 223, 225);\\\" width=\\\"100%\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\"><tbody><tr><td width=\\\"100%\\\" height=\\\"15px\\\"></td></tr></tbody></table></td></tr></tbody></table>    <table data-type=\\\"text-block\\\" class=\\\"em-main\\\" style=\\\"display: table; background-color: rgb(255, 255, 255);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" align=\\\"center\\\"><tbody><tr><td data-block-id=\\\"background\\\" class=\\\"em-block-text\\\" style=\\\"font-size: 13px; color: rgb(0, 0, 0); line-height: 22px; padding: 10px 50px;\\\" align=\\\"left\\\"><p><span style=\\\"font-size: 11pt; color: #333333; line-height: 2;\\\" data-mce-style=\\\"font-size: 11pt; color: #333333; line-height: 2;\\\">Thank you for your order with </span></p>[woo_mb_site_name]. Feel free to contact us, if you have any questions,<p></p><p><span style=\\\"font-size: 11pt; color: #333333;\\\" data-mce-style=\\\"font-size: 11pt; color: #333333;\\\">Sincerely,</span></p><p><span style=\\\"font-size: 11pt; color: #333333;\\\" data-mce-style=\\\"font-size: 11pt; color: #333333;\\\">Mystore Team.</span></p><p><span style=\\\"font-size: 11pt; color: #333333;\\\" data-mce-style=\\\"font-size: 11pt; color: #333333;\\\"><br data-mce-bogus=\\\"1\\\"></span></p></td></tr></tbody></table>    <table data-type=\\\"text-block\\\" class=\\\"em-main\\\" style=\\\"display: table; background-color: rgb(156, 93, 144);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" align=\\\"center\\\"><tbody><tr><td data-block-id=\\\"background\\\" style=\\\"font-family: Arial,serif; font-size: 13px; color: rgb(0, 0, 0); line-height: 22px; padding: 10px 50px;\\\" align=\\\"left\\\"><div class=\\\"text-center\\\"><p><span style=\\\"color: rgb(255, 255, 255); font-size: 11pt;\\\" data-mce-style=\\\"color: #dddddd; font-size: 11pt;\\\">My Store | <a style=\\\"color: #dddddd;\\\" href=\\\"http://www.mystore.com\\\" data-mce-href=\\\"http://www.mystore.com\\\" data-mce-style=\\\"color: #dddddd;\\\">www.mystore.com</a> | <a style=\\\"color: #dddddd;\\\" href=\\\"http://facebook.com\\\" data-mce-href=\\\"http://facebook.com\\\" data-mce-style=\\\"color: #dddddd;\\\">Facebook</a></span><br data-mce-bogus=\\\"1\\\"></p></div></td></tr></tbody></table>    </body></html>","emailSettings":{"options":{"paddingTop":"50px","paddingLeft":"5px","paddingBottom":"50px","paddingRight":"5px","backgroundColor":"#edf1e4"},"type":"emailSettings"}}'
    );

    // 9. customer_note
    $mail_templates['customer_note'] = array(
    	'post_type' 	=> 'woo_mb_template',
    	'post_title' 	=> 'customer_note',
    	'post_name' 	=> 'en_us',
    	'post_content'  => '{"elements":[{"type":"image","options":{"align":"center","padding":["15px","50px","15px","50px"],"image":"'.WOO_ECPB_URI.'/assets/images/woo-logo-vector.png","backgroundColor":"#edf1e4"},"id":"id1490886893205RAND6004","component":"imageTemplate"},{"type":"title","options":{"align":"center","title":"Customer Note","subTitle":"","padding":["30px","50px","30px","50px"],"backgroundColor":"#edf1e4","color":"#444444"},"id":"id1488526766460RAND75248","component":"titleTemplate"},{"type":"text","options":{"padding":["10px","50px","10px","50px"],"backgroundColor":"#ffffff","text":"<p><span style=\\\"font-size: 11pt; color: rgb(51, 51, 51);\\\" data-mce-style=\\\"font-size: 11pt; color: #333333;\\\"><span style=\\\"line-height: 2;\\\" data-mce-style=\\\"line-height: 2;\\\">Hello, a note has been just added to your order: </span><span style=\\\"line-height: 2;\\\" data-mce-style=\\\"line-height: 2;\\\"><strong>#[woo_mb_order_id]</strong></span><span style=\\\"line-height: 2;\\\" data-mce-style=\\\"line-height: 2;\\\"> for your reference, your order details are shown below.</span></span></p>"},"id":"id1490767975242RAND21227","component":"textTemplate"},{"type":"itemTable","options":{"padding":["15px","50px","15px","50px"],"width":"370","backgroundColor":"#ffffff","text":"<p style=\\\"line-height: 22px;\\\">[woo_mb_items]</p>"},"id":"id1490768130472RAND60455","component":"itemTableTemplate"},{"type":"divider","options":{"padding":["15px","50px","0px","50px"],"backgroundColor":"#ffffff"},"id":"id1490768203203RAND79542","component":"dividerTemplate"},{"type":"text","options":{"padding":["10px","50px","10px","50px"],"backgroundColor":"#ffffff","text":"<p style=\\\"margin: 0px 0px 10px; line-height: 22px; font-size: 13px;\\\" data-block-id=\\\"text-area\\\" data-mce-style=\\\"margin: 0px 0px 10px; line-height: 22px; font-size: 13px;\\\"><span style=\\\"color: #333333; font-size: 11pt;\\\" data-mce-style=\\\"color: #333333; font-size: 11pt;\\\">Feel free to contact us if you have any questions,</span></p><p style=\\\"margin: 0px 0px 10px; line-height: 22px; font-size: 13px;\\\" data-block-id=\\\"text-area\\\" data-mce-style=\\\"margin: 0px 0px 10px; line-height: 22px; font-size: 13px;\\\"><span style=\\\"color: #333333; font-size: 11pt;\\\" data-mce-style=\\\"color: #333333; font-size: 11pt;\\\">Sincerely,</span></p><p style=\\\"margin: 0px 0px 10px; line-height: 22px; font-size: 13px;\\\" data-block-id=\\\"text-area\\\" data-mce-style=\\\"margin: 0px 0px 10px; line-height: 22px; font-size: 13px;\\\"><span style=\\\"color: #333333; font-size: 11pt;\\\" data-mce-style=\\\"color: #333333; font-size: 11pt;\\\">Mystore Team.</span></p><p style=\\\"margin: 0px 0px 10px; line-height: 22px; font-size: 13px;\\\" data-block-id=\\\"text-area\\\" data-mce-style=\\\"margin: 0px 0px 10px; line-height: 22px; font-size: 13px;\\\"><span style=\\\"color: #333333; font-size: 11pt;\\\" data-mce-style=\\\"color: #333333; font-size: 11pt;\\\"><br data-mce-bogus=\\\"1\\\"></span></p>"},"id":"id1490768196212RAND44460","component":"textTemplate"},{"type":"unsubscribe","options":{"padding":["10px","50px","10px","50px"],"backgroundColor":"#9c5d90","text":"<div class=\\\"text-center\\\"><p><span style=\\\"color: #dddddd; font-size: 11pt;\\\" data-mce-style=\\\"color: #dddddd; font-size: 11pt;\\\">My Store | <a style=\\\"color: #dddddd;\\\" href=\\\"http://www.mystore.com\\\" data-mce-href=\\\"http://www.mystore.com\\\" data-mce-style=\\\"color: #dddddd;\\\">www.mystore.com</a> | <a style=\\\"color: #dddddd;\\\" href=\\\"http://facebook.com\\\" data-mce-href=\\\"http://facebook.com\\\" data-mce-style=\\\"color: #dddddd;\\\">Facebook</a></span><br data-mce-bogus=\\\"1\\\"></p></div>"},"id":"id1488526645848RAND13669","component":"unsubscribeTemplate"}],"html":"<html><head><meta http-equiv=\\\"Content-Type\\\" content=\\\"text/html; charset=UTF-8\\\"><meta name=\\\"viewport\\\" content=\\\"width=device-width\\\" initial-scale=\\\"1.0\\\" user-scalable=\\\"yes\\\"></head><body style=\\\"background: rgb(237, 241, 228) none repeat scroll 0% 0%; padding: 50px 5px;\\\"><table data-type=\\\"image\\\" class=\\\"em-main\\\" style=\\\"display: table; background-color: rgb(237, 241, 228);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" align=\\\"center\\\"><tbody><tr><td class=\\\"em-image\\\" style=\\\"padding: 15px 50px;\\\" align=\\\"center\\\"><img src=\\\"'.WOO_ECPB_URI.'/assets/images/woo-logo-vector.png\\\" tabindex=\\\"0\\\" style=\\\"display: block; max-width: 100%;\\\" border=\\\"0\\\"></td></tr></tbody></table>    <table data-type=\\\"title\\\" class=\\\"em-main\\\" style=\\\"display: table; background-color: rgb(237, 241, 228);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" align=\\\"center\\\"><tbody><tr><td data-block-id=\\\"background\\\" class=\\\"em-title\\\" style=\\\"color: rgb(117, 117, 117); padding: 30px 50px;\\\" align=\\\"center\\\"><h1 data-block-id=\\\"main-title\\\" style=\\\"font-family: Arial,sans-serif; margin: 0px; font-weight: 800; line-height: 42px; font-size: 36px; color: rgb(68, 68, 68);\\\">Customer Note</h1> <!----></td></tr></tbody></table>    <table data-type=\\\"text-block\\\" class=\\\"em-main\\\" style=\\\"display: table; background-color: rgb(255, 255, 255);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" align=\\\"center\\\"><tbody><tr><td data-block-id=\\\"background\\\" class=\\\"em-block-text\\\" style=\\\"font-size: 13px; color: rgb(0, 0, 0); line-height: 22px; padding: 10px 50px;\\\" align=\\\"left\\\"><p><span style=\\\"font-size: 11pt; color: rgb(51, 51, 51);\\\" data-mce-style=\\\"font-size: 11pt; color: #333333;\\\"><span style=\\\"line-height: 2;\\\" data-mce-style=\\\"line-height: 2;\\\">Hello, a note has been just added to your order: </span><span style=\\\"line-height: 2;\\\" data-mce-style=\\\"line-height: 2;\\\"><strong>#</strong></span></span></p>[woo_mb_order_id]<span style=\\\"line-height: 2;\\\" data-mce-style=\\\"line-height: 2;\\\"> for your reference, your order details are shown below.</span><p></p></td></tr></tbody></table>    <table data-type=\\\"itemTable\\\" class=\\\"em-main\\\" style=\\\"display: table; background-color: rgb(255, 255, 255);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" bgcolor=\\\"#FFFFFF\\\" align=\\\"center\\\"><tbody><tr><td class=\\\"em-image-text\\\" style=\\\"font-family: Arial,serif; font-size: 13px; color: rgb(0, 0, 0); line-height: 22px; padding: 15px 50px;\\\" align=\\\"left\\\"><div><p style=\\\"line-height: 22px;\\\"></p>[woo_mb_items]<p></p></div></td></tr></tbody></table>    <table data-type=\\\"divider\\\" class=\\\"em-main\\\" style=\\\"border: 0px none; display: table; background-color: rgb(255, 255, 255);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" align=\\\"center\\\"><tbody><tr><td class=\\\"em-divider-simple\\\" style=\\\"padding: 15px 50px 0px;\\\"><table style=\\\"border-top: 1px solid rgb(218, 223, 225);\\\" width=\\\"100%\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\"><tbody><tr><td width=\\\"100%\\\" height=\\\"15px\\\"></td></tr></tbody></table></td></tr></tbody></table>    <table data-type=\\\"text-block\\\" class=\\\"em-main\\\" style=\\\"display: table; background-color: rgb(255, 255, 255);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" align=\\\"center\\\"><tbody><tr><td data-block-id=\\\"background\\\" class=\\\"em-block-text\\\" style=\\\"font-size: 13px; color: rgb(0, 0, 0); line-height: 22px; padding: 10px 50px;\\\" align=\\\"left\\\"><p style=\\\"margin: 0px 0px 10px; line-height: 22px; font-size: 13px;\\\" data-block-id=\\\"text-area\\\" data-mce-style=\\\"margin: 0px 0px 10px; line-height: 22px; font-size: 13px;\\\"><span style=\\\"color: #333333; font-size: 11pt;\\\" data-mce-style=\\\"color: #333333; font-size: 11pt;\\\">Feel free to contact us if you have any questions,</span></p><p style=\\\"margin: 0px 0px 10px; line-height: 22px; font-size: 13px;\\\" data-block-id=\\\"text-area\\\" data-mce-style=\\\"margin: 0px 0px 10px; line-height: 22px; font-size: 13px;\\\"><span style=\\\"color: #333333; font-size: 11pt;\\\" data-mce-style=\\\"color: #333333; font-size: 11pt;\\\">Sincerely,</span></p><p style=\\\"margin: 0px 0px 10px; line-height: 22px; font-size: 13px;\\\" data-block-id=\\\"text-area\\\" data-mce-style=\\\"margin: 0px 0px 10px; line-height: 22px; font-size: 13px;\\\"><span style=\\\"color: #333333; font-size: 11pt;\\\" data-mce-style=\\\"color: #333333; font-size: 11pt;\\\">Mystore Team.</span></p><p style=\\\"margin: 0px 0px 10px; line-height: 22px; font-size: 13px;\\\" data-block-id=\\\"text-area\\\" data-mce-style=\\\"margin: 0px 0px 10px; line-height: 22px; font-size: 13px;\\\"><span style=\\\"color: #333333; font-size: 11pt;\\\" data-mce-style=\\\"color: #333333; font-size: 11pt;\\\"><br data-mce-bogus=\\\"1\\\"></span></p></td></tr></tbody></table>    <table data-type=\\\"text-block\\\" class=\\\"em-main\\\" style=\\\"display: table; background-color: rgb(156, 93, 144);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" align=\\\"center\\\"><tbody><tr><td data-block-id=\\\"background\\\" style=\\\"font-family: Arial,serif; font-size: 13px; color: rgb(0, 0, 0); line-height: 22px; padding: 10px 50px;\\\" align=\\\"left\\\"><div class=\\\"text-center\\\"><p><span style=\\\"color: rgb(255, 255, 255); font-size: 11pt;\\\" data-mce-style=\\\"color: #dddddd; font-size: 11pt;\\\">My Store | <a style=\\\"color: #dddddd;\\\" href=\\\"http://www.mystore.com\\\" data-mce-href=\\\"http://www.mystore.com\\\" data-mce-style=\\\"color: #dddddd;\\\">www.mystore.com</a> | <a style=\\\"color: #dddddd;\\\" href=\\\"http://facebook.com\\\" data-mce-href=\\\"http://facebook.com\\\" data-mce-style=\\\"color: #dddddd;\\\">Facebook</a></span><br data-mce-bogus=\\\"1\\\"></p></div></td></tr></tbody></table>    </body></html>","emailSettings":{"options":{"paddingTop":"50px","paddingLeft":"5px","paddingBottom":"50px","paddingRight":"5px","backgroundColor":"#edf1e4"},"type":"emailSettings"}}'
    );

    // 10. customer_new_account
    $mail_templates['customer_new_account'] = array(
    	'post_type' 	=> 'woo_mb_template',
    	'post_title' 	=> 'customer_new_account',
    	'post_name' 	=> 'en_us',
            'post_content'  => '{"elements":[{"type":"image","options":{"align":"center","padding":["15px","50px","15px","50px"],"image":"'.WOO_ECPB_URI.'/assets/images/woo-logo-vector.png","backgroundColor":"#edf1e4"},"id":"id1490886910373RAND19564","component":"imageTemplate"},{"type":"title","options":{"align":"center","title":"New Account","subTitle":"","padding":["30px","50px","30px","50px"],"backgroundColor":"#edf1e4","color":"#444444"},"id":"id1488527092799RAND82274","component":"titleTemplate"},{"type":"text","options":{"padding":["10px","50px","10px","50px"],"backgroundColor":"#ffffff","text":"<p style=\\\"margin: 0px 0px 10px; line-height: 30px; font-size: 13px;\\\" data-block-id=\\\"text-area\\\" data-mce-style=\\\"margin: 0px 0px 10px; line-height: 30px; font-size: 13px;\\\"><span style=\\\"color: #333333; font-size: 11pt;\\\" data-mce-style=\\\"color: #333333; font-size: 11pt;\\\">Your account has been created successfully at [woo_mb_site_name]</span></p><p style=\\\"margin: 0px 0px 10px; line-height: 30px; font-size: 13px;\\\" data-block-id=\\\"text-area\\\" data-mce-style=\\\"margin: 0px 0px 10px; line-height: 30px; font-size: 13px;\\\"><strong><span style=\\\"color: #333333; font-size: 11pt;\\\" data-mce-style=\\\"color: #333333; font-size: 11pt;\\\">User name: </span></strong><span style=\\\"color: #333333; font-size: 11pt;\\\" data-mce-style=\\\"color: #333333; font-size: 11pt;\\\">[woo_mb_user_name]</span></p><p style=\\\"margin: 0px 0px 10px; line-height: 30px; font-size: 13px;\\\" data-block-id=\\\"text-area\\\" data-mce-style=\\\"margin: 0px 0px 10px; line-height: 30px; font-size: 13px;\\\"><strong><span style=\\\"color: #333333; font-size: 11pt;\\\" data-mce-style=\\\"color: #333333; font-size: 11pt;\\\">E-mail: </span></strong><span style=\\\"color: #333333; font-size: 11pt;\\\" data-mce-style=\\\"color: #333333; font-size: 11pt;\\\">[woo_mb_user_email] </span><strong><span style=\\\"color: #333333; font-size: 11pt;\\\" data-mce-style=\\\"color: #333333; font-size: 11pt;\\\"><br></span></strong></p>"},"id":"id1490768345289RAND72591","component":"textTemplate"},{"type":"unsubscribe","options":{"padding":["10px","50px","10px","50px"],"backgroundColor":"#9c5d90","text":"<div class=\\\"text-center\\\"><p><span style=\\\"color: #dddddd; font-size: 11pt;\\\" data-mce-style=\\\"color: #dddddd; font-size: 11pt;\\\">My Store | <a style=\\\"color: #dddddd;\\\" href=\\\"http://www.mystore.com\\\" data-mce-href=\\\"http://www.mystore.com\\\" data-mce-style=\\\"color: #dddddd;\\\">www.mystore.com</a> | <a style=\\\"color: #dddddd;\\\" href=\\\"http://facebook.com\\\" data-mce-href=\\\"http://facebook.com\\\" data-mce-style=\\\"color: #dddddd;\\\">Facebook</a></span><br data-mce-bogus=\\\"1\\\"></p></div>"},"id":"id1488527053558RAND68859","component":"unsubscribeTemplate"}],"html":"<html><head><meta http-equiv=\\\"Content-Type\\\" content=\\\"text/html; charset=UTF-8\\\"><meta name=\\\"viewport\\\" content=\\\"width=device-width\\\" initial-scale=\\\"1.0\\\" user-scalable=\\\"yes\\\"></head><body style=\\\"background: rgb(237, 241, 228) none repeat scroll 0% 0%; padding: 50px 5px;\\\"><table data-type=\\\"image\\\" class=\\\"em-main\\\" style=\\\"display: table; background-color: rgb(237, 241, 228);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" align=\\\"center\\\"><tbody><tr><td class=\\\"em-image\\\" style=\\\"padding: 15px 50px;\\\" align=\\\"center\\\"><img src=\\\"'.WOO_ECPB_URI.'/assets/images/woo-logo-vector.png\\\" tabindex=\\\"0\\\" style=\\\"display: block; max-width: 100%;\\\" border=\\\"0\\\"></td></tr></tbody></table>    <table data-type=\\\"title\\\" class=\\\"em-main\\\" style=\\\"display: table; background-color: rgb(237, 241, 228);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" align=\\\"center\\\"><tbody><tr><td data-block-id=\\\"background\\\" class=\\\"em-title\\\" style=\\\"color: rgb(117, 117, 117); padding: 30px 50px;\\\" align=\\\"center\\\"><h1 data-block-id=\\\"main-title\\\" style=\\\"font-family: Arial,sans-serif; margin: 0px; font-weight: 800; line-height: 42px; font-size: 36px; color: rgb(68, 68, 68);\\\">New Account</h1> <!----></td></tr></tbody></table>    <table data-type=\\\"text-block\\\" class=\\\"em-main\\\" style=\\\"display: table; background-color: rgb(255, 255, 255);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" align=\\\"center\\\"><tbody><tr><td data-block-id=\\\"background\\\" class=\\\"em-block-text\\\" style=\\\"font-size: 13px; color: rgb(0, 0, 0); line-height: 22px; padding: 10px 50px;\\\" align=\\\"left\\\"><p style=\\\"margin: 0px 0px 10px; line-height: 30px; font-size: 13px;\\\" data-block-id=\\\"text-area\\\" data-mce-style=\\\"margin: 0px 0px 10px; line-height: 30px; font-size: 13px;\\\"><span style=\\\"color: #333333; font-size: 11pt;\\\" data-mce-style=\\\"color: #333333; font-size: 11pt;\\\">Your account has been created successfully at </span></p>[woo_mb_site_name]<p></p><p style=\\\"margin: 0px 0px 10px; line-height: 30px; font-size: 13px;\\\" data-block-id=\\\"text-area\\\" data-mce-style=\\\"margin: 0px 0px 10px; line-height: 30px; font-size: 13px;\\\"><strong><span style=\\\"color: #333333; font-size: 11pt;\\\" data-mce-style=\\\"color: #333333; font-size: 11pt;\\\">User name: </span></strong><span style=\\\"color: #333333; font-size: 11pt;\\\" data-mce-style=\\\"color: #333333; font-size: 11pt;\\\"></span></p>[woo_mb_user_name]<p></p><p style=\\\"margin: 0px 0px 10px; line-height: 30px; font-size: 13px;\\\" data-block-id=\\\"text-area\\\" data-mce-style=\\\"margin: 0px 0px 10px; line-height: 30px; font-size: 13px;\\\"><strong><span style=\\\"color: #333333; font-size: 11pt;\\\" data-mce-style=\\\"color: #333333; font-size: 11pt;\\\">E-mail: </span></strong><span style=\\\"color: #333333; font-size: 11pt;\\\" data-mce-style=\\\"color: #333333; font-size: 11pt;\\\"></span></p>[woo_mb_user_email] <strong><span style=\\\"color: #333333; font-size: 11pt;\\\" data-mce-style=\\\"color: #333333; font-size: 11pt;\\\"><br></span></strong><p></p></td></tr></tbody></table>    <table data-type=\\\"text-block\\\" class=\\\"em-main\\\" style=\\\"display: table; background-color: rgb(156, 93, 144);\\\" width=\\\"640\\\" border=\\\"0\\\" cellspacing=\\\"0\\\" cellpadding=\\\"0\\\" align=\\\"center\\\"><tbody><tr><td data-block-id=\\\"background\\\" style=\\\"font-family: Arial,serif; font-size: 13px; color: rgb(0, 0, 0); line-height: 22px; padding: 10px 50px;\\\" align=\\\"left\\\"><div class=\\\"text-center\\\"><p><span style=\\\"color: #dddddd; font-size: 11pt;\\\" data-mce-style=\\\"color: #dddddd; font-size: 11pt;\\\">My Store | <a style=\\\"color: #dddddd;\\\" href=\\\"http://www.mystore.com\\\" data-mce-href=\\\"http://www.mystore.com\\\" data-mce-style=\\\"color: #dddddd;\\\">www.mystore.com</a> | <a style=\\\"color: #dddddd;\\\" href=\\\"http://facebook.com\\\" data-mce-href=\\\"http://facebook.com\\\" data-mce-style=\\\"color: #dddddd;\\\">Facebook</a></span><br data-mce-bogus=\\\"1\\\"></p></div></td></tr></tbody></table>    </body></html>","emailSettings":{"options":{"paddingTop":"50px","paddingLeft":"5px","paddingBottom":"50px","paddingRight":"5px","backgroundColor":"#edf1e4"},"type":"emailSettings"}}'
    );

    foreach ($mail_templates as $template_key => $one_template) {
        $current_lang = get_locale();
        if(empty($current_lang) || $current_lang == 'en') $current_lang = 'en_US';
        $one_template['post_name'] = $current_lang;

        if ( empty($one_template['post_type']) || !isset($one_template['post_type']) ) {
            $one_template['post_type'] = 'woo_mb_template';
        }

        $one_template['post_status'] = 'active';
        $one_template['comment_status'] = 'closed';
        $one_template['ping_status'] = 'closed';

        $postid = WOOMBPB_getEmailTemplateFromPost($one_template['post_title'], $one_template['post_name']);
        if($postid){
            // do nothing
        } else {
            $insert = wp_insert_post($one_template);
            if($insert){
                $post_content = str_replace("\\\\\"","\\\"", $one_template['post_content']);
                $post_content = json_decode($post_content);
                $metaData['additionalstyles'] = '';
                $metaData['elements'] = $post_content->elements;
                $metaData['emailSettings'] = $post_content->emailSettings;
                $metaData['html'] = $post_content->html;
                $metaData['styles'] = '';
                $metaData['wec_language'] = $one_template['post_name'];
                foreach ($metaData as $index => $value) {
                    add_post_meta($insert, $index, $value, true);
                }
                // success inserting
            }
        }
    }
}

function WOOMBPBonDeactivationPlugin()
{
}