<?php
/**
 * Order Status Rules for WooCommerce - Rule Section Settings
 *
 * @version 2.4.1
 * @since   2.0.0
 *
 * @author  Algoritmika Ltd.
 */

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

if ( ! class_exists( 'Alg_WC_Order_Status_Rules_Settings_Rule' ) ) :

class Alg_WC_Order_Status_Rules_Settings_Rule extends Alg_WC_Order_Status_Rules_Settings_Section {

	/**
	 * Constructor.
	 *
	 * @version 2.0.0
	 * @since   2.0.0
	 */
	function __construct( $i ) {
		$this->id   = 'rule_' . $i;
		$this->desc = sprintf( __( 'Rule #%d', 'order-status-rules-for-woocommerce' ), $i );
		$this->num  = $i;
		parent::__construct();
	}

	/**
	 * get_settings.
	 *
	 * @version 2.4.1
	 * @since   2.0.0
	 *
	 * @todo    [next] (dev) `alg_wc_order_status_rules()->core->init_options()`?
	 * @todo    [next] (dev) `alg_wc_order_status_rules_products` (and maybe for `alg_wc_order_status_rules_product_cats`, etc.): ajax
	 * @todo    [next] (desc) `alg_wc_order_status_rules_skip_days`: better desc
	 * @todo    [later] (dev) group into more subsections?
	 * @todo    [maybe] (dev) `alg_wc_order_status_rules_product_cats`, `alg_wc_order_status_rules_product_tags`: add term ID?
	 * @todo    [maybe] (dev) `alg_wc_order_status_rules_gateways`: add "Other" and/or "N/A" options?
	 * @todo    [maybe] (desc) `alg_wc_order_status_rules_gateways`: better desc?
	 * @todo    [maybe] (feature) `alg_wc_order_status_rules_gateways`, `alg_wc_order_status_rules_products`, etc.: add "exclude" options?
	 */
	function get_settings() {

		add_action( 'admin_footer', array( $this, 'add_admin_script' ) );

		global $wp_roles;
		$titles         = get_option( 'alg_wc_order_status_rules_title', array() );
		$_gateways      = WC()->payment_gateways()->payment_gateways;
		$_gateways      = array_combine( wp_list_pluck( $_gateways, 'id' ), wp_list_pluck( $_gateways, 'method_title' ) );
		$products       = get_option( 'alg_wc_order_status_rules_products', array() );
		$_products      = wc_get_products( array( 'limit' => -1, 'return' => 'ids', 'type' => array_merge( array_keys( wc_get_product_types() ), array( 'variation' ) ) ) );
		$_products      = array_combine( $_products, array_map( array( $this, 'get_product_title' ), $_products ) );
		$product_cats   = get_option( 'alg_wc_order_status_rules_product_cats', array() );
		$_product_cats  = get_terms( array( 'taxonomy' => 'product_cat', 'hide_empty' => false ) );
		$_product_cats  = ( ! empty( $_product_cats ) && ! is_wp_error( $_product_cats ) ? array_combine( wp_list_pluck( $_product_cats, 'term_id' ), wp_list_pluck( $_product_cats, 'name' ) ) : array() );
		$product_tags   = get_option( 'alg_wc_order_status_rules_product_tags', array() );
		$_product_tags  = get_terms( array( 'taxonomy' => 'product_tag', 'hide_empty' => false ) );
		$_product_tags  = ( ! empty( $_product_tags ) && ! is_wp_error( $_product_tags ) ? array_combine( wp_list_pluck( $_product_tags, 'term_id' ), wp_list_pluck( $_product_tags, 'name' ) ) : array() );
		$user_roles     = array_merge( array( 'guest' => __( 'Guest', 'order-status-rules-for-woocommerce' ) ), wp_list_pluck( apply_filters( 'editable_roles', $wp_roles->roles ), 'name' ) );
		$users          = get_users( array( 'orderby' => 'user_nicename' ) );
		$users          = array_combine( wp_list_pluck( $users, 'ID' ), array_map( array( $this, 'get_user_nicename' ), $users ) );
		$users          = array_replace( array( 'guest' => __( 'Guest', 'order-status-rules-for-woocommerce' ) . ' (#0)' ), $users );

		$i = $this->num;
		return array(
			array(
				'title'    => sprintf( __( 'Rule #%d', 'order-status-rules-for-woocommerce' ), $i ) . ( ! empty( $titles[ $i ] ) ? ': ' . $titles[ $i ] : '' ),
				'type'     => 'title',
				'id'       => "alg_wc_order_status_rules_options_{$i}",
			),
			array(
				'title'    => __( 'Enable/Disable', 'order-status-rules-for-woocommerce' ),
				'desc'     => '<strong>' . sprintf( __( 'Enable rule #%s', 'order-status-rules-for-woocommerce' ), $i ) . '</strong>',
				'id'       => "alg_wc_order_status_rules_enabled[{$i}]",
				'default'  => 'no',
				'type'     => 'checkbox',
			),
			array(
				'title'    => __( 'Status from', 'order-status-rules-for-woocommerce' ),
				'id'       => "alg_wc_order_status_rules_from[{$i}]",
				'default'  => 'wc-pending',
				'type'     => 'select',
				'class'    => 'wc-enhanced-select',
				'options'  => wc_get_order_statuses(),
			),
			array(
				'title'    => __( 'Status to', 'order-status-rules-for-woocommerce' ),
				'id'       => "alg_wc_order_status_rules_to[{$i}]",
				'default'  => 'wc-cancelled',
				'type'     => 'select',
				'class'    => 'wc-enhanced-select',
				'options'  => wc_get_order_statuses(),
			),
			array(
				'title'    => __( 'Time trigger', 'order-status-rules-for-woocommerce' ),
				'id'       => "alg_wc_order_status_rules_time_trigger[{$i}]",
				'default'  => 1,
				'type'     => 'number',
				'custom_attributes' => array( 'min' => 0 ),
			),
			array(
				'id'       => "alg_wc_order_status_rules_time_trigger_unit[{$i}]",
				'default'  => 'hour',
				'type'     => 'select',
				'class'    => 'chosen_select',
				'options'  => array(
					'second' => __( 'second(s)', 'order-status-rules-for-woocommerce' ),
					'minute' => __( 'minute(s)', 'order-status-rules-for-woocommerce' ),
					'hour'   => __( 'hour(s)', 'order-status-rules-for-woocommerce' ),
					'day'    => __( 'day(s)', 'order-status-rules-for-woocommerce' ),
					'week'   => __( 'week(s)', 'order-status-rules-for-woocommerce' ),
				),
			),
			array(
				'title'    => __( 'Skip days', 'order-status-rules-for-woocommerce' ),
				'desc_tip' => __( 'Ignored if empty, or if all seven days are selected.', 'order-status-rules-for-woocommerce' ),
				'desc'     => $this->get_select_all_buttons(),
				'id'       => "alg_wc_order_status_rules_skip_days[{$i}]",
				'default'  => array(),
				'type'     => 'multiselect',
				'class'    => 'chosen_select',
				'options'  => array(
					1 => __( 'Monday', 'order-status-rules-for-woocommerce' ),
					2 => __( 'Tuesday', 'order-status-rules-for-woocommerce' ),
					3 => __( 'Wednesday', 'order-status-rules-for-woocommerce' ),
					4 => __( 'Thursday', 'order-status-rules-for-woocommerce' ),
					5 => __( 'Friday', 'order-status-rules-for-woocommerce' ),
					6 => __( 'Saturday', 'order-status-rules-for-woocommerce' ),
					7 => __( 'Sunday', 'order-status-rules-for-woocommerce' ),
				),
			),
			array(
				'title'    => __( 'Admin title', 'order-status-rules-for-woocommerce' ) . ' (' . __( 'optional', 'order-status-rules-for-woocommerce' ) . ')',
				'id'       => "alg_wc_order_status_rules_title[{$i}]",
				'default'  => '',
				'type'     => 'text',
			),
			array(
				'type'     => 'sectionend',
				'id'       => "alg_wc_order_status_rules_options_{$i}",
			),
			array(
				'title'    => __( 'Conditions', 'order-status-rules-for-woocommerce' ),
				'type'     => 'title',
				'id'       => "alg_wc_order_status_rules_condition_options_{$i}",
			),
			array(
				'title'    => __( 'Minimum order amount', 'order-status-rules-for-woocommerce' ),
				'desc_tip' => __( 'Minimum order amount (subtotal).', 'order-status-rules-for-woocommerce' ) . ' ' .
					__( 'If you want the rule to be applied only for orders with subtotal equal or greater than some value, you can set it here.', 'order-status-rules-for-woocommerce' ) . ' ' .
					__( 'Ignored if empty.', 'order-status-rules-for-woocommerce' ),
				'id'       => "alg_wc_order_status_rules_min_amount[{$i}]",
				'default'  => '',
				'type'     => 'number',
				'custom_attributes' => array( 'step' => '0.000001' ),
			),
			array(
				'title'    => __( 'Maximum order amount', 'order-status-rules-for-woocommerce' ),
				'desc_tip' => __( 'Maximum order amount (subtotal).', 'order-status-rules-for-woocommerce' ) . ' ' .
					__( 'If you want the rule to be applied only for orders with subtotal equal or less than some value, you can set it here.', 'order-status-rules-for-woocommerce' ) . ' ' .
					__( 'Ignored if empty.', 'order-status-rules-for-woocommerce' ),
				'id'       => "alg_wc_order_status_rules_max_amount[{$i}]",
				'default'  => '',
				'type'     => 'number',
				'custom_attributes' => array( 'step' => '0.000001' ),
			),
			array(
				'title'    => __( 'Minimum order quantity', 'order-status-rules-for-woocommerce' ),
				'desc_tip' => __( 'Minimum number of items in the order.', 'order-status-rules-for-woocommerce' ) . ' ' .
					__( 'If you want the rule to be applied only for orders with number of items equal or greater than some value, you can set it here.', 'order-status-rules-for-woocommerce' ) . ' ' .
					__( 'Ignored if empty.', 'order-status-rules-for-woocommerce' ),
				'id'       => "alg_wc_order_status_rules_min_qty[{$i}]",
				'default'  => '',
				'type'     => 'number',
				'custom_attributes' => array( 'min' => 0 ),
			),
			array(
				'title'    => __( 'Maximum order quantity', 'order-status-rules-for-woocommerce' ),
				'desc_tip' => __( 'Maximum number of items in the order.', 'order-status-rules-for-woocommerce' ) . ' ' .
					__( 'If you want the rule to be applied only for orders with number of items equal or less than some value, you can set it here.', 'order-status-rules-for-woocommerce' ) . ' ' .
					__( 'Ignored if empty.', 'order-status-rules-for-woocommerce' ),
				'id'       => "alg_wc_order_status_rules_max_qty[{$i}]",
				'default'  => '',
				'type'     => 'number',
				'custom_attributes' => array( 'min' => 0 ),
			),
			array(
				'title'    => __( 'Payment gateways', 'order-status-rules-for-woocommerce' ),
				'desc_tip' => __( 'Required payment gateways.', 'order-status-rules-for-woocommerce' ) . ' ' .
					__( 'If you want the rule to be applied only for orders with selected payment gateways, you can set them here.', 'order-status-rules-for-woocommerce' ) . ' ' .
					__( 'Ignored if empty.', 'order-status-rules-for-woocommerce' ),
				'desc'     => $this->get_select_all_buttons(),
				'id'       => "alg_wc_order_status_rules_gateways[{$i}]",
				'default'  => array(),
				'type'     => 'multiselect',
				'class'    => 'chosen_select',
				'options'  => $_gateways,
			),
			array(
				'title'    => __( 'Shipping methods', 'order-status-rules-for-woocommerce' ),
				'desc_tip' => __( 'Required shipping methods.', 'order-status-rules-for-woocommerce' ) . ' ' .
					__( 'If you want the rule to be applied only for orders with selected shipping methods, you can set them here.', 'order-status-rules-for-woocommerce' ) . ' ' .
					__( 'Ignored if empty.', 'order-status-rules-for-woocommerce' ),
				'desc'     => $this->get_select_all_buttons(),
				'id'       => "alg_wc_order_status_rules_shipping_instances[{$i}]",
				'default'  => array(),
				'type'     => 'multiselect',
				'class'    => 'chosen_select',
				'options'  => $this->get_shipping_methods_instances(),
			),
			array(
				'title'    => __( 'Products', 'order-status-rules-for-woocommerce' ),
				'desc_tip' => __( 'Required products.', 'order-status-rules-for-woocommerce' ) . ' ' .
					__( 'If you want the rule to be applied only for orders with selected products, you can set them here.', 'order-status-rules-for-woocommerce' ) . ' ' .
					__( 'Ignored if empty.', 'order-status-rules-for-woocommerce' ),
				'desc'     => $this->get_select_all_buttons(),
				'id'       => "alg_wc_order_status_rules_products[{$i}]",
				'default'  => array(),
				'type'     => 'multiselect',
				'class'    => 'chosen_select',
				'options'  => array_replace(
					( ! empty( $products[ $i ] ) ? array_combine( $products[ $i ], array_map( array( $this, 'get_missing_product_title' ), $products[ $i ] ) ) : array() ),
					$_products ),
			),
			array(
				'title'    => __( 'Product categories', 'order-status-rules-for-woocommerce' ),
				'desc_tip' => __( 'Required product categories.', 'order-status-rules-for-woocommerce' ) . ' ' .
					__( 'If you want the rule to be applied only for orders with selected product categories, you can set them here.', 'order-status-rules-for-woocommerce' ) . ' ' .
					__( 'Ignored if empty.', 'order-status-rules-for-woocommerce' ),
				'desc'     => $this->get_select_all_buttons(),
				'id'       => "alg_wc_order_status_rules_product_cats[{$i}]",
				'default'  => array(),
				'type'     => 'multiselect',
				'class'    => 'chosen_select',
				'options'  => array_replace(
					( ! empty( $product_cats[ $i ] ) ? array_combine( $product_cats[ $i ], array_map( array( $this, 'get_missing_product_cat_title' ), $product_cats[ $i ] ) ) : array() ),
					$_product_cats ),
			),
			array(
				'title'    => __( 'Product tags', 'order-status-rules-for-woocommerce' ),
				'desc_tip' => __( 'Required product tags.', 'order-status-rules-for-woocommerce' ) . ' ' .
					__( 'If you want the rule to be applied only for orders with selected product tags, you can set them here.', 'order-status-rules-for-woocommerce' ) . ' ' .
					__( 'Ignored if empty.', 'order-status-rules-for-woocommerce' ),
				'desc'     => $this->get_select_all_buttons(),
				'id'       => "alg_wc_order_status_rules_product_tags[{$i}]",
				'default'  => array(),
				'type'     => 'multiselect',
				'class'    => 'chosen_select',
				'options'  => array_replace(
					( ! empty( $product_tags[ $i ] ) ? array_combine( $product_tags[ $i ], array_map( array( $this, 'get_missing_product_tag_title' ), $product_tags[ $i ] ) ) : array() ),
					$_product_tags ),
			),
			array(
				'title'    => __( 'User roles', 'order-status-rules-for-woocommerce' ),
				'desc_tip' => __( 'Required user roles.', 'order-status-rules-for-woocommerce' ) . ' ' .
					__( 'If you want the rule to be applied only for orders from selected user roles, you can set them here.', 'order-status-rules-for-woocommerce' ) . ' ' .
					__( 'Ignored if empty.', 'order-status-rules-for-woocommerce' ),
				'desc'     => $this->get_select_all_buttons(),
				'id'       => "alg_wc_order_status_rules_user_roles[{$i}]",
				'default'  => array(),
				'type'     => 'multiselect',
				'class'    => 'chosen_select',
				'options'  => $user_roles,
			),
			array(
				'title'    => __( 'Users', 'order-status-rules-for-woocommerce' ),
				'desc_tip' => __( 'Required users.', 'order-status-rules-for-woocommerce' ) . ' ' .
					__( 'If you want the rule to be applied only for orders from selected users, you can set them here.', 'order-status-rules-for-woocommerce' ) . ' ' .
					__( 'Ignored if empty.', 'order-status-rules-for-woocommerce' ),
				'desc'     => $this->get_select_all_buttons(),
				'id'       => "alg_wc_order_status_rules_users[{$i}]",
				'default'  => array(),
				'type'     => 'multiselect',
				'class'    => 'chosen_select',
				'options'  => $users,
			),
			array(
				'title'    => __( 'Order meta', 'order-status-rules-for-woocommerce' ),
				'desc'     => __( 'Meta key', 'order-status-rules-for-woocommerce' ),
				'desc_tip' => __( 'Required order meta.', 'order-status-rules-for-woocommerce' ) . ' ' .
					__( 'If you want the rule to be applied only for orders with specific order meta value, you can set it here.', 'order-status-rules-for-woocommerce' ) . ' ' .
					__( 'Ignored if empty.', 'order-status-rules-for-woocommerce' ),
				'id'       => "alg_wc_order_status_rules_meta_key[{$i}]",
				'default'  => '',
				'type'     => 'text',
			),
			array(
				'desc'     => __( 'Meta value', 'order-status-rules-for-woocommerce' ),
				'id'       => "alg_wc_order_status_rules_meta_value[{$i}]",
				'default'  => '',
				'type'     => 'text',
			),
			array(
				'desc'     => __( 'Multiple meta values', 'order-status-rules-for-woocommerce' ),
				'desc_tip' => __( 'Allows setting multiple meta values as a comma-separated list.', 'order-status-rules-for-woocommerce' ),
				'id'       => "alg_wc_order_status_rules_meta_value_is_multiple[{$i}]",
				'default'  => 'no',
				'type'     => 'checkbox',
			),
			array(
				'title'    => __( 'Date created before', 'order-status-rules-for-woocommerce' ),
				'desc_tip' => __( 'Date (UTC).', 'order-status-rules-for-woocommerce' ) . ' ' .
					__( 'If you want the rule to be applied only for orders created before some date, you set it here.', 'order-status-rules-for-woocommerce' ) . ' ' .
					__( 'Ignored if empty.', 'order-status-rules-for-woocommerce' ),
				'id'       => "alg_wc_order_status_rules_date_created_before[{$i}]",
				'default'  => '',
				'type'     => 'date',
			),
			array(
				'title'    => __( 'Date created after', 'order-status-rules-for-woocommerce' ),
				'desc_tip' => __( 'Date (UTC).', 'order-status-rules-for-woocommerce' ) . ' ' .
					__( 'If you want the rule to be applied only for orders created after some date, you set it here.', 'order-status-rules-for-woocommerce' ) . ' ' .
					__( 'Ignored if empty.', 'order-status-rules-for-woocommerce' ),
				'id'       => "alg_wc_order_status_rules_date_created_after[{$i}]",
				'default'  => '',
				'type'     => 'date',
			),
			array(
				'type'     => 'sectionend',
				'id'       => "alg_wc_order_status_rules_condition_options_{$i}",
			),
		);

	}

}

endif;
