<?php

namespace Foxpost_Woo_Parcel\Includes\Helpers;

/**
 * Helper to provide missing funtions.
 *
 * @since      1.1.6
 *
 * @package    Foxpost_Woo_Parcel
 * @subpackage Foxpost_Woo_Parcel/includes/helpers
 */

if (!defined('ABSPATH')) {
    die;
}

/**
 * Class Foxpost_Woo_Parcel_Compat
 * @package Foxpost_Woo_Parcel\Includes\Helpers
 */
class Foxpost_Woo_Parcel_Compat {
    /**
     * Convert a UTF-8 encoded string to title/proper case
     *    (uppercase every first character in each word, lower case all other characters)
     *
     * @param string $string UTF-8 encoded string
     *
     * @return string
     */
    public static function mb_convert_case($string = '')
    {
        if (function_exists('mb_convert_case')) {
            return mb_convert_case($string, MB_CASE_TITLE, 'UTF-8');
        }

        return ucwords($string);
    }
}
