(function ($) {
    'use strict';
    jQuery(document).ready(function ($) {
        var isIphoneDevice = (/(iP)/g.test(navigator.userAgent));
        var isSafari = navigator.userAgent.toLowerCase().indexOf('safari') > -1;
        var isChrome = navigator.userAgent.toLowerCase().indexOf('chrome') > -1;
        if (isChrome) {
            isSafari = false;
        }

        var downloadFile = function (method, reload) {
            var ids = [];
            jQuery('#posts-filter').find('input[name="post[]"]:checked').each(function () {
                ids.push($(this).val());
            });
            var params = jQuery.param({'ids': ids});
            var url = ajaxurl + (ajaxurl.indexOf('?') === -1 ? '?' : '&') + 'action=foxpost_woo_parcel&method=' + method + '&' + params;

            if (isIphoneDevice || isSafari) {
                var getUrl = async function () {
                    return url
                };
                var windowReference = window.open();

                getUrl().then(function (url) {
                    windowReference.location = url;
                });
            } else {
                var iframeId = 'export_download_frame';
                $('#' + iframeId).remove();
                var $iframe = $('<iframe id="' + iframeId + '" width="0" height="0" style="display: none;"></iframe>');
                $('body').append($iframe);

                $iframe.attr('src', url);
            }

            if (reload) {
                setTimeout(function () {
                    window.location.reload();
                }, 0);
            }

            return false;
        }

        var $form = $('#posts-filter');
        $form.submit(function (event) {
            var $selects = $('#bulk-action-selector-top, #bulk-action-selector-bottom');

            $selects.each(function (index, elem) {

                if ($(this).val() === 'foxpost_export_to_xls') {
                    return downloadFile('export_download', true);
                }
                if ($(this).val() === 'foxpost_generate_stickers') {
                    return downloadFile('generate_stickers', true);
                }
            });
        });
    });
})(jQuery);
