<?php
/**
 * Plugin functions
 *
 * @since 1.0.0
 * @package FBLiveChat
 */

function fblivechat_update_settings(array $settings)
{
    return update_option(FBLiveChat\Plugin::OPTION_KEY, $settings);
}

/**
 * Get all settings
 *
 * @return array
 */
function fblivechat_get_settings()
{
    $settings = array_merge([
        'app_id' => '',
        'app_secret' => '',
        'client_token' => '',
        'client_locale' => 'en_US',
        'chat_enabled' => 1,
        'client_page_id' => '',
        'show_on_device' => 'both',
        'show_on_page' => 'all',
        'hide_pages' => [],
        'show_pages' => [],
        'icon_offset_left' => '',
        'icon_offset_right' => '',
        'icon_offset_bottom' => '',
        'theme_color' => '#0084FF',
        'minimize_on_desktop' => false,
        'logged_in_greeting' => '',
        'logged_out_greeting' => '',
        'greeting_dialog_delay' => 0
    ], (array)get_option(FBLiveChat\Plugin::OPTION_KEY));

    return $settings;
}

/**
 * Get a setting
 *
 * @param string $key
 *
 * @return string|int
 */
function fblivechat_get_setting($key)
{
    $settings = fblivechat_get_settings();

    return isset($settings[$key]) ? $settings[$key] : '';
}

/**
 * List pages by {$field}
 *
 * @param string $field The field which will be used as index key.
 *
 * @return array
 */
function fblivechat_list_pages($field = 'slug')
{
    if (!in_array($field, ['id', 'slug'])) {
        throw new OutOfRangeException(esc_html__('Listing field is not available.', 'facebook-messenger-live-chat-for-wordpress'));
    }

    static $result = [];

    if (empty($result[$field])) {
        $posts = get_posts([
            'post_type' => 'page',
            'no_found_rows' => 1,
            'posts_per_page' => -1,
            'cache_results' => 0,
            'update_post_meta_cache' => 0,
            'update_post_term_cache' => 0
        ]);
        if (empty($posts)) {
            throw new OutOfRangeException(esc_html__('No post found.', 'facebook-messenger-live-chat-for-wordpress'));
        }
        foreach ($posts as $post) {
            $result[$field][$post->post_name] = $post->post_title;
        }
    }

    return $result[$field];
}

/**
 * @return array
 */
function fblivechat_get_locales()
{
    return [
        'af_ZA' => 'Afrikaans',
        'ar_AR' => 'Arabic',
        'az_AZ' => 'Azerbaijani',
        'be_BY' => 'Belarusian',
        'bg_BG' => 'Bulgarian',
        'bn_IN' => 'Bengali',
        'bs_BA' => 'Bosnian',
        'ca_ES' => 'Catalan',
        'cs_CZ' => 'Czech',
        'cy_GB' => 'Welsh',
        'da_DK' => 'Danish',
        'de_DE' => 'German',
        'el_GR' => 'Greek',
        'en_GB' => 'English (GB)',
        'en_PI' => 'English (Pirate)',
        'en_UD' => 'English (Upside Down)',
        'en_US' => 'English (US)',
        'eo_EO' => 'Esperanto',
        'es_ES' => 'Spanish (Spain)',
        'es_LA' => 'Spanish',
        'et_EE' => 'Estonian',
        'eu_ES' => 'Basque',
        'fa_IR' => 'Persian',
        'fb_LT' => 'Leet Speak',
        'fi_FI' => 'Finnish',
        'fo_FO' => 'Faroese',
        'fr_CA' => 'French (Canada)',
        'fr_FR' => 'French (France)',
        'fy_NL' => 'Frisian',
        'ga_IE' => 'Irish',
        'gl_ES' => 'Galician',
        'he_IL' => 'Hebrew',
        'hi_IN' => 'Hindi',
        'hr_HR' => 'Croatian',
        'hu_HU' => 'Hungarian',
        'hy_AM' => 'Armenian',
        'id_ID' => 'Indonesian',
        'is_IS' => 'Icelandic',
        'it_IT' => 'Italian',
        'ja_JP' => 'Japanese',
        'ka_GE' => 'Georgian',
        'km_KH' => 'Khmer',
        'ko_KR' => 'Korean',
        'ku_TR' => 'Kurdish',
        'la_VA' => 'Latin',
        'lt_LT' => 'Lithuanian',
        'lv_LV' => 'Latvian',
        'mk_MK' => 'Macedonian',
        'ml_IN' => 'Malayalam',
        'mn_MN' => 'Mongolian',
        'ms_MY' => 'Malay',
        'nb_NO' => 'Norwegian (bokmal)',
        'ne_NP' => 'Nepali',
        'nl_NL' => 'Dutch',
        'nn_NO' => 'Norwegian (nynorsk)',
        'pa_IN' => 'Punjabi',
        'pl_PL' => 'Polish',
        'ps_AF' => 'Pashto',
        'pt_BR' => 'Portuguese (Brazil)',
        'pt_PT' => 'Portuguese (Portugal)',
        'ro_RO' => 'Romanian',
        'ru_RU' => 'Russian',
        'sk_SK' => 'Slovak',
        'sl_SI' => 'Slovenian',
        'sq_AL' => 'Albanian',
        'sr_RS' => 'Serbian',
        'sv_SE' => 'Swedish',
        'sw_KE' => 'Swahili',
        'ta_IN' => 'Tamil',
        'te_IN' => 'Telugu',
        'th_TH' => 'Thai',
        'tl_PH' => 'Filipino',
        'tr_TR' => 'Turkish',
        'uk_UA' => 'Ukrainian',
        'vi_VN' => 'Vietnamese',
        'zh_CN' => 'Simplified Chinese (China)',
        'zh_HK' => 'Traditional Chinese (Hong Kong)',
        'zh_TW' => 'Traditional Chinese (Taiwan)',
    ];
}

function fblivechat_is_show()
{
    global $wp_query;

    if (!$wp_query->is_main_query()) {
        return false;
    }

    $post_slug = isset($wp_query->post) ? $wp_query->post->post_name : '';
    $settings = fblivechat_get_settings();
    $is_mobile = wp_is_mobile();

    if (empty($post_slug) || empty($settings['chat_enabled'])) {
        return false;
    }

    if ('mobile' === $settings['show_on_device']) {
        if (!$is_mobile) {
            return false;
        }
    } elseif ('desktop' !== $settings['show_on_device']) {
        if ($is_mobile) {
            return false;
        }
    }else{
        return true;
    }

    if ($settings['show_on_page'] == 'all') {
        return true;
    } elseif ($settings['show_on_page'] == 'custom1' && is_singular('page')) {
        if (!in_array($post_slug, $settings['hide_pages'])) {
            return true;
        } else {
            return false;
        }
    } elseif ($settings['show_on_page'] == 'custom2' && is_singular('page')) {
        if (in_array($post_slug, $settings['show_pages'])) {
            return true;
        } else {
            return false;
        }
    }
}
