(function($) {
    'use strict';

    /**
     * Pops up a window with specified url and callback
     */
    function popup(url, cb) {
        var top = top || (screen.height / 2) - 250,
            left = left || (screen.width / 2) - 300,
            win = window.open(url, 'link_facebook_account', 'location=0,status=1,resizable=yes,width=600,height=500,top=' + top + ',left=' + left);

        function check() {
            if (!win || win.closed != false) {
                cb();
            } else {
                setTimeout(check, 100);
            }
        }

        setTimeout(check, 100);
    }

    /**
     * Setup client credentials
     *
     * @param {object} e Event
     */
    function setup_client_credentials(e) {
        popup('https://api.cleveraddon.com/facebook/login.php?locale=' + FBLiveChat.clientLocale + '&dir=' + FBLiveChat.textDirection, () => {
            $.ajax({
                url: 'https://api.cleveraddon.com/facebook/token.php',
                type: 'GET',
                dataType: 'json',
                crossDomain: true
            }).done((r) => {
                if (r.success) {
                    $.post(ajaxurl, {
                        action: 'setup_client_credentials',
                        app_id: r.data.id,
                        app_secret: r.data.secret,
                        client_token: r.data.token
                    }, function(data, status, xhr) {
                        location.reload();
                    });
                } else {
                    console.log(r);
                }
            }).fail((r) => {
                console.log(r);
            });
        });
    }

    // DOM ready
    $(() => {
        const enabled = $('#fblivechat-enabled'),
            settingsContent = $('#fblivechat-settings-content'),
            showOnPages = $('#fblivechat-show-on'),
            excludedPagesRow = $('#fblivechat-excluded-pages-row'),
            includedPagesRow = $('#fblivechat-included-pages-row'),
            showOnDevice = $('#fblivechat-show-on-device'),
            desktopMinimizeRow = $('#fblivechat-minimize-on-desktop-row');

        $('.select2').select2({
            width: 240,
            dir: FBLiveChat.textDirection
        });

        $('.wp-color-picker').wpColorPicker();

        if ('all' === showOnPages.val()) {
            excludedPagesRow.hide();
            includedPagesRow.hide();
        } else if ('custom1' == showOnPages.val()) {
            excludedPagesRow.show();
            includedPagesRow.hide();
        } else if ('custom2' == showOnPages.val()) {
            excludedPagesRow.hide();
            includedPagesRow.show();
        }

        showOnPages.on('change', (e) => {
            if ('all' === showOnPages.val()) {
                excludedPagesRow.hide();
                includedPagesRow.hide();
            } else if ('custom1' == showOnPages.val()) {
                excludedPagesRow.show();
                includedPagesRow.hide();
            } else if ('custom2' == showOnPages.val()) {
                excludedPagesRow.hide();
                includedPagesRow.show();
            }
        });

        $('.fblivechat-button-connect').on('click', setup_client_credentials);
        $('.fblivechat-button-reconnect').on('click', setup_client_credentials);
    });
    $(document).on('click', '.fblivechat-tab-control-item:not(.active) a', function(e) {
        e.preventDefault();
        $('.fblivechat-tab-control-item.active').removeClass('active');
        $('.fblivechat-tab.active').removeClass('active');
        $(this).closest('.fblivechat-tab-control-item').addClass('active');
        var target = $(this).attr('href');
        $(target).addClass('active');
    })
}(jQuery))
