<?php
/*
Plugin Name: Capturly - Optimize your website
Plugin URI: https://capturly.com/
Description: <a href="https://capturly.com/" target="_blank">Capturly</a> is a software tool for studying user behavior on your website. Among other features it allows you to record your users real-time, meaning a new level of customer analyzing. Create your Capturly account <a href="https://capturly.com/users/new/" target="_blank">here</a>, and paste in your tracking code <a href="admin.php?page=capturly">here</a>.
Author: Capturly
Version: 1.2.0
Author URI: https://capturly.com/
*/

if (!defined('ABSPATH')) die();

register_deactivation_hook(__FILE__, 'capturly_uninstall');

$plugin = plugin_basename(__FILE__);

function capturly_uninstall()
{
    delete_option('capturly_options');
}

function capturly_init()
{
    register_setting('capturly_plugin_options', 'capturly_options', 'capturly_validate_options');
}
add_action ('admin_init', 'capturly_init');

// add the options page
function capturly_add_options_page()
{
    add_options_page('Capturly', 'Capturly', 'administrator', 'capturly_settings', 'capturly_render_form');
}
add_action ('admin_menu', 'capturly_add_options_page');

function capturly_render_form()
{
    $options = get_option('capturly_options'); ?>

    <h1>Capturly <?php _e('Settings') ?></h1>
    <?php
    if (isset($options) && !empty($options)) { ?>
        <?php ?>
        <div class="updated">
            <p><?php _e('Tracking code is installed.') ?></p>
        </div>
    <?php } else { ?>
        <div class="error">
            <p><?php _e('Tracking code is not installed.') ?></p>
        </div>
    <?php } ?>

    <form method="post" action="options.php">
        <?php
        settings_fields('capturly_plugin_options');
        ?>
        <h3>Insert your Capturly tracking code (save empty field to delete):</h3>
        <?php
        /*<input id="capturly_account_id" name="capturly_options[capturly_account_id]" value="<?= isset($options['capturly_account_id']) ? $options['capturly_account_id'] : '' ?>" class="regular-text"/>
        <span class="description">(ex. t-rgctqux3hhd3i8wgqj2jr2eg)</span>
        <p>Or insert your tracking code here:</p>*/
        ?>
        <textarea name="capturly_options[capturly_tracking_code]" style="height:140px;width:50%;" spellcheck="false"><?= (isset($options['capturly_tracking_code']) && !empty($options['capturly_tracking_code'])) ? htmlspecialchars($options['capturly_tracking_code'], ENT_QUOTES) : '' ?></textarea>
        <p class="submit">
            <input type="submit" class="button button-primary button-large" name="update_message" value="<?php echo _e('Save Changes') ?>">
        </p>
    </form>
    <p> If you don’t have a Capturly ID yet, please go to our <a href="http://capturly.com">website</a> and register your WordPress website to gain one.</p>
<?php
}

function getCapturlyTrackingCode($accountId)
{
    return '<script>
        trq("account", "' . $accountId . '");
        (function(d,t){
        var s=d.createElement(t),c=d.getElementsByTagName(t)[0];
        s.async=1;
        s.src="https://cdn.capturly.com/js/track.js";
        c.parentNode.insertBefore(s,c);
        }(document,\'script\'));function trq(){(trq.q=trq.q||[]).push(arguments);}</script>';
}

function getNewCapturlyTrackingCode($accountId, $capturlyID) {
    return "<script>
    function trq(){(trq.q=trq.q||[]).push(arguments);}
    trq('account', '" . $accountId . "');
    var _paq=_paq||[];
    _paq.push(['trackPageView']);
    _paq.push(['enableLinkTracking']);
    (function() {
        var u='//capturly.com/';
        _paq.push(['setTrackerUrl', u+'capturly-track.php']);
        _paq.push(['setSiteId', '" . $capturlyID . "']);
        var d=document, g=d.createElement('script'), s=d.getElementsByTagName('script')[0];
        g.type='text/javascript'; g.async=true; g.defer=true; g.src=u+'capturly-track-js.js';
        s.parentNode.insertBefore(g,s);
    })();
    </script>";
}

function capturly_validate_options($input)
{
    $options = get_option('capturly_options');
    $oldTrackingCode = $options['capturly_tracking_code'];
    $newTrackingCode = trim($input['capturly_tracking_code']);
//    $oldAccountId = $options['capturly_account_id'];
//    $newAccountId = trim($input['capturly_account_id']);

//    if (!empty($newAccountId) && preg_match("/^t-.{24}/", $newAccountId) !== 0) {
//        $newTrackingCode = getCapturlyTrackingCode($newAccountId);
//    } else
    if (!empty($newTrackingCode) && preg_match("/t-.{24}['\"]\)/", $newTrackingCode) !== 0) {
        preg_match("/t-.{24}/", $newTrackingCode, $outPutArray);
        preg_match("/\'\d+\'/", $newTrackingCode, $capturlySiteID);

        $newAccountId = $outPutArray[0];
        $newTrackingCode = getCapturlyTrackingCode($newAccountId);

        if (!empty($capturlySiteID)) {
            $capturlySiteID = str_replace("'","", $capturlySiteID[0]);
            $newTrackingCode = getNewCapturlyTrackingCode($newAccountId, $capturlySiteID);
        }
    } elseif (empty($newTrackingCode)) {
        return null;
    } else {
        $error = "The given tracking code is not valid";
        add_settings_error('unique_identifyer', esc_attr('settings_updated'),
            __($error), 'error');
        add_action('admin_notices', 'print_errors');

//        $newAccountId = $oldAccountId;
        $newTrackingCode = $oldTrackingCode;
    }

    return array('capturly_tracking_code' => $newTrackingCode);
}

function print_errors()
{
    settings_errors('unique_identifyer');
}

function capturly_settings_link($links)
{
    $settings_link = '<a href="options-general.php?page=capturly_settings">Settings</a>';
    array_unshift($links, $settings_link);

    return $links;
}
add_filter("plugin_action_links_{$plugin}", 'capturly_settings_link');

function add_capturly_script()
{
    $options = get_option('capturly_options');

    if (isset($options['capturly_tracking_code'])) {
        echo $options['capturly_tracking_code'];
    }
}

add_action('wp_footer', 'add_capturly_script');
