<?php
class waruk_wcFields {
function __construct() {
			//mezők hozzáadása a termék adatlaphoz
			add_action( 'woocommerce_product_options_general_product_data', array($this, 'add_extra_fields'));
			add_action( 'woocommerce_product_after_variable_attributes', array($this, 'add_extra_variable_fields'), 10, 3 );
			add_action( 'woocommerce_process_product_meta', array($this, 'save_fields'));
					add_action( 'woocommerce_save_product_variation', array($this, 'save_variation_fields'), 10, 2 );
					//Kategória átnevezése
					add_action('product_cat_add_form_fields', array($this, 'add_category_field'), 10, 2);
					add_action('product_cat_edit_form_fields', array($this, 'edit_category'), 10, 2);
					
					add_action('edited_product_cat', array($this, 'save_category'), 10, 2);
add_action('create_product_cat', array($this, 'save_category'), 10, 2);
					}
			public function add_extra_fields() {
				if (get_option('waruk_hide_default') !=1) {
				woocommerce_wp_checkbox( array(
				'id' => 'arukereso_hide',
				'label' => __('A termék elrejtése az Árukereső xml-ből', 'woo-arukereso'),
				'description' => __('Ha be van pipálva, ez a termék nem lesz bent az árukereső xml-ben.', 'woo-arukereso') ) );
				} else {
				woocommerce_wp_checkbox( array(
				'id' => 'arukereso_show',
				'label' => __('A termék megjelenítése az Árukereső számára', 'woo-arukereso'), 
				'description' => __('Ha be van pipálva, a termék elérhető lesz az Árukereső számára.', 'woo-arukereso') ) );
				}
				woocommerce_wp_text_input(
        array(
            'id' => 'waruk_prod_name',
            'label' =>__('Megjelenő terméknév az Árukeresőben', 'woo-arukereso'),
            'placeholder' => __('Akkor töltsük ki, ha termékünk neve eltér az Árukeresőben megjelenő névtől.', 'woo-arukereso'),
            'desc_tip' => 'true',
            'description' => __('Akkor használjuk, ha egyedi terméknevet szeretnénk megadni az Árukereső számára', 'woo-arukereso')
			)
    );
	woocommerce_wp_text_input(
        array(
            'id' => 'product_number',
            'label' =>__('A gyártó által megadott termékkód', 'woo-arukereso'),
                        'desc_tip' => 'true',
            'description' => __('A ProductNumber feltüntetése kötelező a terméklistában elektronikai, informatikai, háztartási cikkek esetében illetve azokban a kategóriákban, amelyekben termékkód alapján történik a feldolgozás.', 'woo-arukereso')
        )
    );
				woocommerce_wp_text_input(
        array(
            'id' => 'manufacturer',
            'label' =>__('Termék gyártójának megnevezése', 'woo-arukereso'),
            'placeholder' => __('Termék gyártójának megnevezése', 'woo-arukereso'),
            'desc_tip' => 'true',
            'description' => __('A termék gyártójának megnevezése (ha nem szerepel a termék névben)', 'woo-arukereso')
        )
    );
	woocommerce_wp_text_input(
        array(
            'id' => 'ean_code',
            'label' =>__('EAN kód', 'woo-arukereso'),
            'placeholder' => __('gyártó által adott EAN kód', 'woo-arukereso'),
            'desc_tip' => 'true',
            'description' => __('Min. 8 - max. 13 számjegyű gyártó által adott termékazonosító; egyedinek kell lennie. (European Article Number)', 'woo-arukereso')
        )
    );
	woocommerce_wp_text_input(
        array(
            'id' => 'warranty',
            'label' =>__('Termék garancia', 'woo-arukereso'),
            'placeholder' => __('Termékhez járó garancia', 'woo-arukereso'),
            'desc_tip' => 'true',
            'description' => __('Garancia hossza = hónapok száma. Pl.: 12 (1 éves garancia esetén), 24 (2 éves garancia esetén)', 'woo-arukereso')
        )
    );
			woocommerce_wp_text_input(
        array(
            'id' => 'shipping_time',
            'label' =>__('Termék kiszállítási ideje', 'woo-arukereso'),
            'placeholder' => __('Termék kiszállításának ideje', 'woo-arukereso'),
            'desc_tip' => 'true',
            'description' => __('A termékhez tartozókiszállítási idő napban', 'woo-arukereso')
        )
    );
	woocommerce_wp_text_input(
        array(
            'id' => 'shipping_cost',
            'label' =>__('Termék szállítási költsége', 'woo-arukereso'),
            'placeholder' => __('Termék szállítási költsége', 'woo-arukereso'),
            'desc_tip' => 'true',
            'description' => __('A termékhez tartozó szálítási költség', 'woo-arukereso')
        )
    );
	woocommerce_wp_text_input(
        array(
            'id' => 'woo_prod_category',
            'label' =>__('Terméknek megfelelő Árukereső kategória', 'woo-arukereso'),
            'placeholder' => __('Terméknek megfelelő Árukereső kategória', 'woo-arukereso'),
            'desc_tip' => 'true',
            'description' => __('Amennyiben eltér weboldalunk kategória megnevezése az Árukeresőjétől, itt írhatjuk felül', 'woo-arukereso')
        )
    );
				}
				public function add_extra_variable_fields ($loop, $variation_data, $variation) {
		echo '<div class="variation-custom-fields">';
		if (get_option('waruk_hide_default') !=1) {
				woocommerce_wp_checkbox( 
		array(
		'id' => 'arukereso_hide['. $loop .']',
		'label' => __('A termék elrejtése az Árukereső xml-ből', 'woo-arukereso'),
		'description' => __('Ha be van pipálva, ez a termék nem lesz bent az árukereső xml-ben.', 'woo-arukereso'),
		'value'         => get_post_meta($variation->ID, 'arukereso_hide', true) 
		) );
				} else {
				woocommerce_wp_checkbox( array(
				'id' => 'arukereso_show['. $loop .']',
				'label' => __('A termék megjelenítése az Árukereső számára', 'woo-arukereso'),
				'description' => __('Ha be van pipálva, a termék elérhető lesz az Árukereső számára.', 'woo-arukereso'),
				'value'         => get_post_meta($variation->ID, 'arukereso_show', true) ) );
				}
					woocommerce_wp_text_input(
        array(
            'id' => 'waruk_prod_name['. $loop .']',
            'label' =>__('Megjelenő terméknév az Árukeresőben', 'woo-arukereso'),
            'placeholder' => __('Akkor töltsük ki, ha termékünk neve eltér az Árukeresőben megjelenő névtől.', 'woo-arukereso'),
            'desc_tip' => 'true',
            'description' => __('A termékhez tartozó szálítási költség', 'woo-arukereso'),
			'value'         => get_post_meta($variation->ID, 'waruk_prod_name', true) 
        )
    );
								woocommerce_wp_text_input(
        array(
            'id' => 'product_number['. $loop .']',
            'label' =>__('A gyártó által megadott termékkód', 'woo-arukereso'),
                        'desc_tip' => 'true',
            'description' => __('A ProductNumber feltüntetése kötelező a terméklistában elektronikai, informatikai, háztartási cikkek esetében illetve azokban a kategóriákban, amelyekben termékkód alapján történik a feldolgozás.', 'woo-arukereso'),
			'value'         => get_post_meta($variation->ID, 'product_number', true)
        )
    );
	woocommerce_wp_text_input(
        array(
            'id' => 'manufacturer['. $loop .']',
            'label' =>__('Termék gyártójának megnevezése', 'woo-arukereso'),
            'placeholder' => __('Termék gyártójának megnevezése', 'woo-arukereso'),
            'desc_tip' => 'true',
            'description' => __('A termék gyártójának megnevezése (ha nem szerepel a termék névben)', 'woo-arukereso'),
			'value'         => get_post_meta($variation->ID, 'manufacturer', true) 
        )
    );
	woocommerce_wp_text_input(
        array(
            'id' => 'ean_code['. $loop .']',
            'label' =>__('EAN kód', 'woo-arukereso'),
            'placeholder' => __('gyártó által adott EAn kód', 'woo-arukereso'),
            'desc_tip' => 'true',
            'description' => __('Min. 8 - max. 13 számjegyű gyártó által adott termékazonosító; egyedinek kell lennie. (European Article Number)', 'woo-arukereso'),
			'value'         => get_post_meta($variation->ID, 'ean_code', true) 
        )
    );
	woocommerce_wp_text_input(
        array(
            'id' => 'warranty['. $loop .']',
            'label' =>__('Termék garancia', 'woo-arukereso'),
            'placeholder' => __('Termékhez járó garancia', 'woo-arukereso'),
            'desc_tip' => 'true',
            'description' => __('Garancia hossza = hónapok száma. Pl.: 12 (1 éves garancia esetén), 24 (2 éves garancia esetén)', 'woo-arukereso'),
			'value'         => get_post_meta($variation->ID, 'warranty', true) 
        )
    );
		woocommerce_wp_text_input(
        array(
            'id' => 'shipping_time['. $loop .']',
            'label' =>__('Termék kiszállítási ideje', 'woo-arukereso'),
            'placeholder' => __('Termék kiszállításának ideje', 'woo-arukereso'),
            'desc_tip' => 'true',
            'description' => __('A termékhez tartozókiszállítási idő napban', 'woo-arukereso'),
			'value'         => get_post_meta($variation->ID, 'shipping_time', true) 
        )
    );
	woocommerce_wp_text_input(
        array(
            'id' => 'shipping_cost['. $loop .']',
            'label' =>__('Termék szállítási költsége', 'woo-arukereso'),
            'placeholder' => __('Termék szállítási költsége', 'woo-arukereso'),
            'desc_tip' => 'true',
            'description' => __('A termékhez tartozó szálítási költség', 'woo-arukereso'),
			'value'         => get_post_meta($variation->ID, 'shipping_cost', true) 
        )
    );
	woocommerce_wp_text_input(
        array(
            'id' => 'woo_prod_category['. $loop .']',
            'label' =>__('Terméknek megfelelő Árukereső kategória', 'woo-arukereso'),
            'placeholder' => __('Terméknek megfelelő Árukereső kategória', 'woo-arukereso'),
            'desc_tip' => 'true',
            'description' => __('Amennyiben eltér weboldalunk kategória megnevezése az Árukeresőjétől, itt írhatjuk felül', 'woo-arukereso'),
			'value'         => get_post_meta($variation->ID, 'woo_prod_category', true) 
        )
    );
	echo "</div>";  
				}
				public function save_fields($post_id) {
				$aruk_hide =$_POST["arukereso_hide"];
												update_post_meta( $post_id, 'arukereso_hide', esc_attr( $aruk_hide ) );
												$aruk_show =$_POST["arukereso_show"];
												update_post_meta( $post_id, 'arukereso_show', esc_attr( $aruk_show ) );
												update_post_meta( $post_id, 'waruk_prod_name', esc_attr( $_POST["waruk_prod_name"] ) );
																								update_post_meta( $post_id, 'manufacturer', esc_attr( $_POST["manufacturer"] ) );
																								update_post_meta( $post_id, 'product_number', esc_attr( $_POST["product_number"] ) );
												update_post_meta( $post_id, 'ean_code', esc_attr( $_POST["ean_code"] ) );
												update_post_meta( $post_id, 'warranty', esc_attr( $_POST["warranty"] ) );
																						update_post_meta( $post_id, 'shipping_cost', esc_attr( $_POST["shipping_cost"] ) );
											update_post_meta( $post_id, 'shipping_time', esc_attr( $_POST["shipping_time"] ) );
											update_post_meta( $post_id, 'woo_prod_category', esc_attr( $_POST["woo_prod_category"] ) );
																											}
										public function save_variation_fields ($variation_id, $i) {
		$aruk_hide =$_POST["arukereso_hide"][$i];
												update_post_meta( $variation_id, 'arukereso_hide', esc_attr( $aruk_hide ) );
												$aruk_show =$_POST["arukereso_show"][$i];
												update_post_meta( $variation_id, 'arukereso_show', esc_attr( $aruk_show ) );
												update_post_meta( $variation_id, 'waruk_prod_name', esc_attr( $_POST["waruk_prod_name"][$i] ) );
																								update_post_meta( $variation_id, 'manufacturer', esc_attr( $_POST["manufacturer"][$i] ) );
																								update_post_meta( $variation_id, 'product_number', esc_attr( $_POST["product_number"][$i] ) );
												update_post_meta( $variation_id, 'ean_code', esc_attr( $_POST["ean_code"][$i] ) );
												update_post_meta( $variation_id, 'warranty', esc_attr( $_POST["warranty"][$i] ) );
																																		update_post_meta( $variation_id, 'shipping_cost', esc_attr( $_POST["shipping_cost"][$i] ) );
											update_post_meta( $variation_id, 'shipping_time', esc_attr( $_POST["shipping_time"][$i] ) );
											update_post_meta( $variation_id, 'woo_prod_category', esc_attr( $_POST["woo_prod_category"][$i] ) );
					}
					public function add_category_field() {
						?>
						    <div class="form-field">
        <label for="term_meta[waruk_category]"><?php _e('Kategória neve az Árukeresőben', 'woo-arukereso'); ?></label>
        <input type="text" name="term_meta[waruk_category]" id="term_meta[waruk_category]">
        <p class="description"><?php _e('Amenyiben kategóriánk neve eltér az Árukeresőben elvárttól, itt adhatunk neki eltérő nevet. Ez csak az Árukereső számára fog megjelenni.', 'woo-arukereso'); ?></p>
    </div>
	<div class="form-field">
        <label for="term_meta[waruk_category_hide]"><?php _e('Kategóriába tartozó termékek elrejtése az Árukereső xml-ből', 'woo-arukereso'); ?></label>
        <input type="checkbox" name="term_meta[waruk_category_hide]" id="term_meta[waruk_category_hide]" value ="1">
        <p class="description"><?php _e('Elrejthetünk a kategóriába tartozó termékeket az Árukereső listájából.', 'woo-arukereso'); ?></p>
    </div>
	<?php

						}
						public function edit_category ($term) {
							    $term_id = $term->term_id;

    // retrieve the existing value(s) for this meta field. This returns an array
    $term_meta = get_option("taxonomy_" . $term_id);
	    ?>
    <tr class="form-field">
        <th scope="row" valign="top"><label for="term_meta[waruk_category]"><?php _e('Kategória neve az Árukeresőben', 'woo-arukereso'); ?></label></th>
        <td>
            <input type="text" name="term_meta[waruk_category]" id="term_meta[waruk_category]" value="<?php echo (isset($term_meta['waruk_category']) ? esc_attr($term_meta['waruk_category']) : ''); ?>">
            <p class="description"><?php _e('Amenyiben kategóriánk neve eltér az Árukeresőben elvárttól, itt adhatunk neki eltérő nevet. Ez csak az Árukereső számára fog megjelenni.', 'woo-arukereso'); ?></p>
        </td>
    </tr>
	
	<tr class="form-field">
        <th scope="row" valign="top"><label for="term_meta[waruk_category_hide]"><?php _e('Kategóriába tartozó termékek elrejtése az Árukereső xml-ből', 'woo-arukereso'); ?></label></th>
        <td>
            <input type="checkbox" name="term_meta[waruk_category_hide]" id="term_meta[waruk_category_hide]" value="1" <?php echo ($term_meta['waruk_category_hide'] =='1' ? 'checked' : ''); ?>>
            <p class="description"><?php _e('Elrejthetünk a kategóriába tartozó termékeket az Árukereső listájából.', 'woo-arukereso'); ?></p>
        </td>
    </tr>
	
	<?php
							}
							function save_category ($term_id) {
    if (isset($_POST['term_meta'])) {
        $term_meta = get_option("taxonomy_" . $term_id);
        $cat_keys = array_keys($_POST['term_meta']);
        foreach ($cat_keys as $key) {
            if (isset($_POST['term_meta'][$key])) {
                $term_meta[$key] = $_POST['term_meta'][$key];
            }
        }
		$term_meta['waruk_category_hide'] =(empty($_POST['term_meta']['waruk_category_hide']) ? "" : $_POST['term_meta']['waruk_category_hide']);
        // Save the option array.
        update_option("taxonomy_" . $term_id, $term_meta);
    }
}
}
new waruk_wcFields();