<?php
/**
 * Template part for displaying single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package rozer
 */
$single_post_design = rdt_get_option('blog_single_design', '1');
$title_align = rdt_get_option('blog_single_title_align', 'left');
//Start demo
if(isset($_GET['ps_title']) && $_GET['ps_title'] != '') {
	$title_align = $_GET['ps_title'];
}
//End demo
$hide_fdimage = rdt_get_option('blog_single_fdimage', '0')
?>
<article class="single-post-content" id="post-<?php the_ID(); ?>">
	<?php if($single_post_design == '1') : ?>
		<header class="entry-header text-<?php echo esc_attr($title_align); ?>">
			<?php
			if ( 'post' === get_post_type() ) :				
			?>				
			<div class="entry-meta">					
			<?php					
			rozer_posted_on();					
			rozer_posted_by();					
			?>				
			</div><!-- .entry-meta -->			
			<?php endif; ?>
			<?php
			if ( 'post' === get_post_type() ) :
				?>
				<div class="post-categories-parent">
					<?php
					echo get_the_category_list( esc_html__( ', ', 'rozer' ) );
					?>
				</div>
			<?php endif; ?>
			<?php
			the_title( '<h1 class="entry-title">', '</h1>' );			?>
		</header><!-- .entry-header -->
		<?php if($hide_fdimage == '0') :
		 	rozer_post_thumbnail(); 
		endif; ?>
		<div class="entry-content">
			<?php 
			the_content();
			wp_link_pages(
				array(
					'before'   => '<nav class="page-links" aria-label="' . esc_attr__( 'Page', 'rozer' ) . '">',
					'after'    => '</nav>',
					/* translators: %: page number. */
					'pagelink' => esc_html__( 'Page %', 'rozer' ),
				)
			);
			?>
		</div><!-- .entry-content -->
	<?php else : ?>
		<?php if($hide_fdimage == '0') :
		 	rozer_post_thumbnail(); 
		endif; ?>
		<div class="entry-content">
			<?php 
			the_content();
			wp_link_pages(
				array(
					'before'   => '<nav class="page-links" aria-label="' . esc_attr__( 'Page', 'rozer' ) . '">',
					'after'    => '</nav>',
					/* translators: %: page number. */
					'pagelink' => esc_html__( 'Page %', 'rozer' ),
				)
			);
			?>
		</div><!-- .entry-content -->
	<?php endif; ?>
	<footer class="entry-footer">
		<?php do_action('single_post_footer'); ?>
	</footer><!-- .entry-footer -->
</article>