<?

/*
Plugin Name: XLSX Exportáló - Becomparts
Description: Kedvezményes termékek listájának exportálása
Author: Richárd
Version: 1.0.0
Author URI: http://pcnerd.hu/
*/





new xlsx_exporter();

class xlsx_exporter {



	// constructor
    function __construct() {
		add_action('admin_menu', [$this,"menu"] );
	}
	
	// admin menu
	function menu() {
		add_submenu_page( 'edit.php?post_type=product', 'Exportáló', 'Excel exportáló', 'manage_options', 'exporter', [$this,"html"] ); 
	}
	
	
	
	// add page content
	function html() {
		
		// disable notices
		error_reporting( E_ALL & ~E_NOTICE );
		ini_set("memory_limit", "512M");
		
		// back-end css
		$dir= plugins_url( 'back', __FILE__ );
		wp_enqueue_style( 'exporter_css', "$dir/form.css" );
		
		// $sup, $disc_min, $disc_rate
		extract( $_POST, EXTR_SKIP );
		
		// file path

		
		// upload
		if( $sup ) {
			$arr[2]= array();

			// query
			$args= array(
			  'parent' => $sup,
			  'status' => 'publish',
			  'stock_status' => 'instock',
			  'meta_key' => '_min_price',
			  'orderby'  => 'name',
			  'order' => 'ASC',
			  'limit'  => -1,
			);
			$query= wc_get_products( $args );

			// organize
			foreach( $query as $prod ) {
			  $id= $prod->get_id();
			  $name= $prod->get_name();
			  $sku= $prod->get_sku();
			  $price= $prod->get_price();
			  $min= get_post_meta( $id, '_min_price', true );
				
			  $diff= $price - $min;
			  $disc= $diff / $price * 100;
			  if( $disc < $disc_min ) { continue; }
			  $price-= $diff * $disc_rate / 100;
			  $price = (int) ( $price / 1.27 );
				
			  $arr[]= [ 1=>$name, 2=>$sku, 3=>$price ];
			}

			$temp= __DIR__ ."/template.xlsx";
			$file= get_temp_dir() ."/export.xlsx";
			
			copy( $temp, $file );
			$this->mod_xlsx( $file, $arr );
			
			// output
			ob_end_clean();
			$date= date("Y-m-d");
			header("Content-Disposition: attachment; filename=b2b.$date.xlsx");
			readfile( $file );
			exit;
		}

		// user interface
		include("back/form.php");
		
	}
	
	

		
	// supplier list
	function supplier() {
		global $wpdb;
		
		// get full list
		$arr= $wpdb->get_results("
		  SELECT * FROM wp_posts
		  WHERE post_type= 'supplier'
		  ORDER BY post_title
		", 'ARRAY_A' );
		$arr= array_column( $arr, 'post_title', 'ID' );
		
		// return array
		return $arr;
	}
	



	// modify xlsx values
	function mod_xlsx( $file, $arr ) {

		// open zip
		$zip= new ZipArchive();
		$zip->open( $file );

		// open sheet1
		$sheet= $zip->getFromName("xl/worksheets/sheet1.xml");
		$sheet= str_replace( "xmlns=", "oldns=", $sheet );
		$sheet= new SimpleXMLElement( $sheet );

		// add data (in order)
		ksort( $arr );
		foreach( $arr as $r=>$row ) {
		 ksort( $row );
		 foreach( $row as $c=>$val ) {

			// missing row
			$rowData= @ $sheet->sheetData->xpath("row[@r='$r']")[0];
			if( !$rowData ) {
			  $rowData= $sheet->sheetData->addChild("row");
			  $rowData['r']= $r;
			}

			// missing cell
			$id= chr( $c+64 ).$r;
			$cellData= @ $rowData->xpath("c[@r='$id']")[0];
			if( !$cellData ) {
			  $cellData= $rowData->addChild("c");
			  $cellData['r']= $id;
			}

			// int or inline-string
			if( is_int($val) ) {
			  $cellData['t']= "n";
			  $cellData->v= $val;
			} else {
			  $cellData['t']= "inlineStr";
			  $cellData->is->t= $val;
			}

		}}
		
		// save
		$sheet= $sheet->asXML();
		$sheet= str_replace( "oldns", "xmlns", $sheet );
		$zip->addFromString( "xl/worksheets/sheet1.xml", $sheet );
		
		$zip->close();
	}



	
	
}

