(function ($) {
    'use strict';
    $(document).ready(function () {

        var throttle = function (fn, threshhold, scope) {
            threshhold || (threshhold = 250);
            var last,
                deferTimer;
            return function () {
                var context = scope || this;

                var now = +new Date,
                    args = arguments;
                if (last && now < last + threshhold) {
                    // hold on to it
                    clearTimeout(deferTimer);
                    deferTimer = setTimeout(function () {
                        last = now;
                        fn.apply(context, args);
                    }, threshhold);
                } else {
                    last = now;
                    fn.apply(context, args);
                }
            };
        };

        var dialogSelector = '#foxpost_woo_parcel_dialog';
        var FoxpostWooParcel = function ($) {
            var shippingMethodFieldSelector = 'input[name="shipping_method[0]"]';
            var $shippingMethodField = $(shippingMethodFieldSelector);
            var mapChooserButtonSelector = '.map-chooser-button';
            var _init = function () {

                if (!$shippingMethodField.length) {
                    return;
                }
                var hasDialog = jQuery.ui && typeof jQuery.ui.dialog !== 'undefined';

                if (hasDialog) {
                    $(dialogSelector).dialog(
                        {
                            autoOpen: false,
                            modal: true,
                            draggable: false,
                            height: 800,
                            width: 'auto',
                            maxWidth: 1000,
                            resizable: false,
                            open: function (ev, ui) {
                                $('#foxpost_woo_parcel_dialog_iframe').attr('src', foxpost_woo_parcel_frontend_messages.iframe_src);
                            }
                        }
                    );
                } else {
                    console.error('jQuery.ui.dialog is not available.');
                }

                $(document).on('click', mapChooserButtonSelector, function (event) {
                    event.preventDefault();
                    if (hasDialog) {
                        $(dialogSelector).dialog('open');
                    } else {
                        console.error('jQuery.ui.dialog is not available.');
                    }
                });

                if ($(document.body).hasClass('woocommerce-checkout')) {
                    initAjaxComplete();
                }
                if (hasDialog) {
                    $(window).resize(throttle(function () {
                        $(dialogSelector).dialog('option', 'position', {my: 'center', at: 'center', of: window});
                    }, 300));
                }
            };
            var initAjaxComplete = function () {
                $(document).ajaxComplete(function (event, request, settings) {

                    if ('foxpost_woo_parcel_apt_shipping' === getSelectedShippingMethod($shippingMethodField)) {
                        $('.foxpost_woo_parcel_apt_select_row').show();
                        $('.foxpost_woo_parcel_delivery_message').hide();
                    } else {
                        $('.foxpost_woo_parcel_apt_select_row').hide();
                        $('.foxpost_woo_parcel_delivery_message').show();
                    }
                })
            };
            var getSelectedShippingMethod = function ($shippingMethodField) {
                var selectedShippingMethod;
                if ($shippingMethodField.is(':radio')) {
                    selectedShippingMethod = $(shippingMethodFieldSelector + ':checked').val();
                } else {
                    selectedShippingMethod = $shippingMethodField.val();
                }
                selectedShippingMethod = selectedShippingMethod.replace(/(^.*?):\d+$/, "$1");

                return selectedShippingMethod;
            };

            return {
                init: function () {

                    _init();
                }
            }
        }($).init();

        $('.closesubmodal').on('click', function () {
            $("#googleMapModal").modal("hide");
        });

        $('#terkep-modal').on('hidden.bs.modal', function () {
            $("#googleMapModal").modal("hide");
        });

        window.foxpost_woo_parcel_close_dialog = function (selectedAptId) {
            $('#foxpost_woo_parcel_apt_id').val(selectedAptId);
            $(dialogSelector).dialog('close');
        }
    });
})(jQuery);
