<?php
/**
 * Plugin hooks
 *
 * @package FBLiveChat
 */

/**
 * Setup client credentials
 */
function fblivechat_setup_client_credentials()
{
    $settings = fblivechat_get_settings();

    $settings['app_id'] = isset($_POST['app_id']) ? sanitize_text_field($_POST['app_id']) : '';;
    $settings['app_secret'] = isset($_POST['app_secret']) ? sanitize_text_field($_POST['app_secret']) : '';
    $settings['client_token'] = isset($_POST['client_token']) ? sanitize_text_field($_POST['client_token']) : '';

    fblivechat_update_settings($settings);

    wp_send_json_success();

    exit;
}
add_action('wp_ajax_setup_client_credentials', 'fblivechat_setup_client_credentials');
add_action('wp_ajax_nopriv_setup_client_credentials', 'fblivechat_setup_client_credentials');

/**
 * Render chatbox
 */
function fblivechat_render_chatbox()
{
    if (!fblivechat_is_show()) {
        return;
    }


    $settings = fblivechat_get_settings();

    if (empty($settings['chat_enabled'])) return;

    $customize_attributes = '';

    if ($settings['logged_in_greeting']) {
        $customize_attributes .= 'logged_in_greeting="' . $settings['logged_in_greeting'] . '"';
    }

    if ($settings['logged_out_greeting']) {
        $customize_attributes .= ' logged_out_greeting="' . $settings['logged_out_greeting'] . '"';
    }

    if (!empty($settings['minimize_on_desktop']) && !wp_is_mobile()) {
        $customize_attributes .= ' greeting_dialog_display="hide"';
    }

    if (!empty($settings['greeting_dialog_delay'])) {
        $customize_attributes .= ' greeting_dialog_delay="'. intval($settings['greeting_dialog_delay']) .'"';
    }

    ?>
    <div id="fb-root"></div>
    <div class="fb-customerchat" page_id="<?php echo $settings['client_page_id']; ?>" theme_color="<?php echo $settings['theme_color']; ?>"<?php echo $customize_attributes; ?>></div>
    <style media="screen">
        #fb-root .fb_dialog {
        <?php
        if (isset($settings['icon_offset_left']) && '' !== $settings['icon_offset_left']) {
            echo 'right:auto !important;left:' . intval($settings['icon_offset_left']) . 'px !important;';
        } elseif (isset($settings['icon_offset_right']) && '' !== $settings['icon_offset_right']) {
            echo 'left:auto !important;right:' . intval($settings['icon_offset_right']) . 'px !important;';
        }
        if (isset($settings['icon_offset_bottom']) && '' !== $settings['icon_offset_bottom']) {
            echo 'bottom:' . intval($settings['icon_offset_bottom']) . 'px !important;';
        }
        ?>
        }
        #fb-root .fb-customerchat iframe {
        <?php
        if (isset($settings['icon_offset_left']) && '' !== $settings['icon_offset_left']) {
            echo 'right:auto !important;left:' . intval($settings['icon_offset_left']/2) . 'px !important;';
        } elseif (isset($settings['icon_offset_right']) && '' !== $settings['icon_offset_right']) {
            echo 'left:auto !important;right:' . intval($settings['icon_offset_right']/2) . 'px !important;';
        }
        if (isset($settings['icon_offset_bottom']) && '' !== $settings['icon_offset_bottom']) {
            echo 'margin-bottom:calc(' . intval($settings['icon_offset_bottom']) . 'px - 10px) !important;';
        }
        ?>
        }
    </style>
    <script async defer src="https://connect.facebook.net/<?php echo $settings['client_locale'] ?>/sdk.js"></script>
    <script>
        window.fbAsyncInit = function() {
            FB.init({
                appId            : <?php echo $settings['app_id'] ?>,
                autoLogAppEvents : true,
                xfbml            : true,
                version          : 'v5.0'
            });
        };

    <?php if (!defined('ICL_SITEPRESS_VERSION')) { ?>
        (function(d, s, id) {
            var js, fjs = d.getElementsByTagName(s)[0];
            if (d.getElementById(id)) return;
            js = d.createElement(s); js.id = id;
            js.src = 'https://connect.facebook.net/<?php echo $settings['client_locale']; ?>/sdk/xfbml.customerchat.js';
            fjs.parentNode.insertBefore(js, fjs);
        }(document, 'script', 'facebook-jssdk'));
    <?php } else {
        foreach (fblivechat_get_locales() as $locale => $lang) {
            if ($locale == ICL_LANGUAGE_CODE) {
                $language = $lang;
                break;
            }
        } ?>
        (function(d, s, id) {
            var js, fjs = d.getElementsByTagName(s)[0];
            if (d.getElementById(id)) return;
            js = d.createElement(s); js.id = id;
            js.src = 'https://connect.facebook.net/<?php echo $settings['client_locale']; ?>/sdk/xfbml.customerchat.js';
            fjs.parentNode.insertBefore(js, fjs);
        }(document, 'script', 'facebook-jssdk'));
    <?php } ?>
    </script>
    <?php
}
add_action('wp_footer', 'fblivechat_render_chatbox');
