<?




// silence errors
libxml_use_internal_errors( true );
error_reporting( E_ALL & ~E_NOTICE );



class arukereso {



	// constructor
    function __construct() {

		// display minimum price
		add_action( 'woocommerce_product_options_pricing', [$this,'add_min_price'] );
		
		// add admin box
		add_action( 'add_meta_boxes', [$this,'add_box'] );
		
		// product save
		add_action( 'save_post', [$this,'save'] );
		
		// extend admin css
		add_action( 'admin_enqueue_scripts', [$this,'add_css'] );
		
	}



	// display minimum price
	function add_min_price() {
		global $post;
		$min= get_post_meta( $post->ID, '_min_price', 1 );
		// add input
		woocommerce_wp_text_input( [
		  'id'        => '_min_price',
		  'value'     => $min,
		  'label'     => 'Lista ár (Ft)',
		  'data_type' => 'price',
		] );
	}



	// add admin box
	function add_box() {
		add_meta_box( 'arukereso', 'Árukereső', [$this,'box_html'], 'product', 'normal', 'high' );
	}



	// box content
	function box_html( $post ) {

		// CSS, Js, Ajax
		$dir= plugins_url( 'assets', __FILE__ );
		wp_enqueue_script( 'kereso_js', "$dir/admin.js" );
		wp_localize_script( 'kereso_js', 'ajax', ["$dir/ajax.php"] );

		// post and meta vars
		$vars= get_object_vars( $post );
		extract( $vars, EXTR_SKIP );
		$meta= get_post_meta( $ID );
		$meta= array_map( 'current', $meta );
		extract( $meta, EXTR_SKIP );

		// get kereso_url
		$new= $post_title && $_sku && $_kereso_url===null;
		if( $new ) {
		  $name= sanitize_title( $post_title );
		  $name= explode( '-', $name )[0];
		  $_kereso_url= $this->search( "$name-$_sku" );
		}

		include('assets/admin.php');

	}




	// product save
	function save( $ID ){

		// unhook, so it doesn't loop infinitely
		remove_action( 'save_post', [$this,'save'] );
		
		// $import, $cb_title, $cb_price, $cb_desc, $cb_attr, $cb_img, $_kereso_url, $_min_price
		extract( $_POST );

		if( $import=="" )
		  return;
	  
	  
		session_id() or session_start();

		// $title, $price, $desc, $attr, $img
		extract( $_SESSION['ak'] );
		
		if( $cb_title and $title )
		  $post_title= $title;
	  
		if( $cb_price and $price and $price > $_min_price )
		  $_regular_price= $_price= $price;
	  
		if( $cb_desc and $desc )
		  $post_content= $desc;
	  
		if( $cb_attr and $attr )
		  list( $_product_attributes, $tax_input )= $this->set_attributes( $attr );
		

		$meta_input= compact( '_regular_price', '_price', '_product_attributes', '_kereso_url', '_min_price' );

		$post= compact( 'ID', 'post_title', 'post_content', 'meta_input', 'tax_input' );
		$post= array_filter( $post );
		
		// Update
		wp_update_post( $post );

		if( $cb_img and $img )
		  $this->upload_img( $img, $ID );

	}



	
	// register and prepare data
	function set_attributes( $attr ) {
		if( !$attr ) { return; }
		
		foreach( $attr as $name=>$value ) {
		  // pa_slug-max-27-long
		  $slug= wc_attribute_taxonomy_name( $name );
		  $slug= trim( substr( $slug,0,27 ), '-' );

		  // create if not exists
		  $id= wc_attribute_taxonomy_id_by_name( $slug );
		  if( $id==0 ) {
		    $id= wc_create_attribute( compact('name','slug') );
			if( $id->errors ) { continue; }
		    register_taxonomy( $slug,'product' );
		  }
		  
		  // meta_input _product_attributes
		  $mipa[]= [
			'name' => $slug,
			'is_visible'  => 1,
			'is_taxonomy' => 1
		  ];
		  
		  // tax_input
		  $taxi[ $slug ]= $value;
		}
		return [ $mipa, $taxi ];
	}
	
	

	// add thumbnail
	function  upload_img( $url, $pid ) {
		if( !$url ) { return; }
		$name= "$pid.jpg";
		// download
		$img= $this->curl( $url, 10 );
		if( !$img ) { return; }
		// save
		$tmp_name= get_temp_dir() . '/imgcopy';
		file_put_contents( $tmp_name, $img );
		// add to post
		$arr= compact('name','tmp_name');
		$mid= media_handle_sideload( $arr, $pid );
		set_post_thumbnail( $pid, $mid );
	}
	
	
	
	// arukereso link
	function search( $key ) {
		
		// download #1
		$url = "https://www.arukereso.hu/CategorySearch.php?st=";
		$file= $this->curl( $url.$key );
		if( !$file ) { return; }
	
		// parse #1
		$doc= new DOMDocument();
		$doc->loadHTML( $file, LIBXML_NOERROR );
		
		// find link
		$xpath= new DOMXpath( $doc );
		$a= $xpath -> query("//*/div[@class='image-link-container']/a")[0];
		// not found
		if( !$a ) { return;	}

		// first link
		return $a -> getAttribute("href");
	}
	


	
	// parse product-page
	static function json( $html ) {
		// check html
		$len= strlen( $html );
		if( $len < 1000 ) { return; }

		// load html
		$doc= new DOMDocument();
		$doc->loadHTML( $html, LIBXML_NOERROR );
		$xml= simplexml_import_dom( $doc );
		
		// test page
		$top= $xml -> xpath("//div[@class='row product-page-top']");
		if( !$top ) { return; }

		// title
		$title= $xml -> xpath("//h1[@class='visible-xs']")[0];	
		$title= trim( $title );

		// image
		$img= $xml -> xpath("//a[@class='product-image-wrapper']")[0];
		$img= (string) $img['href'];

		// price
		$price= $xml -> xpath("//span[@class='price']")[0];
		$price= preg_replace( '/\D/', '', $price );
		
		// attributes
		$table= $xml -> xpath("//table[@class='product-properties']/tr");
		foreach( $table as $tr ) {
		  list( $n,$v )= $tr->td;
		  $n= trim( $n, "\xC2\xA0" );
		  $m= $v -> xpath("div/div[@class='name']");
		  $v= $m ? array_map('trim',$m ) : trim( $v );
		  if( $n and $v ) { $attr[$n]=$v; }
		}
		
		// description
		$desc= $xml -> xpath("//div[@class='text property-sheet']")[0];
		$desc= $desc ? $desc->asXML() : '';
		$desc= strstr( $desc, "<span class=\"gray_te", true ) ?:
			   strstr( $desc, "<p><b>Galéria</b></p>", true );
		$desc= substr( $desc, 33 );
		$desc= preg_replace( '@^(<br/>|\s)+|(<br/>|\s)+$@', '', $desc );

		// store in session
		$arr= $_SESSION['ak']= compact('title','img','price','attr','desc');

		// return json
		$opt= JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT;
		return json_encode( $arr, $opt );
	}
	
	
	
	
	// arukereso price
	static function price( $html ) {
		// check html
		$len= strlen( $html );
		if( $len < 1000 ) { return; }

		// load html
		$doc = new DOMDocument();
		$doc->loadHTML( $html, LIBXML_NOERROR );
		
		// find price
		$xpath= new DOMXpath( $doc );
		$price= $xpath -> query("//span[@class='price']")[0] -> nodeValue;
		$price= preg_replace( '/\D/', '', $price );
		
		return $price;
	}
	
	
	

	// curl request
	static function curl( $url, $to=5, $try=2, $delay=0 ) {
		
		// options
		$opt= array(
		  CURLOPT_RETURNTRANSFER => true,   // return web page
		  CURLOPT_CONNECTTIMEOUT => $to,    // time-out on connect
		  CURLOPT_TIMEOUT        => $to,    // time-out on response
		  CURLOPT_FOLLOWLOCATION => false,  // follow redirects
		  CURLOPT_SSL_VERIFYPEER => false,  // Disabled SSL checks
		  CURLOPT_USERAGENT      => 'Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:47.0) Gecko/20100101 Firefox/47.0',
		  CURLOPT_REFERER        => 'https://www.arukereso.hu/',
		);
		
		// curl init
		$ch= curl_init( $url );
		curl_setopt_array( $ch, $opt );
		
		// try to get
		while( !$out and $try-- ) {
		  $out= curl_exec( $ch );
		  sleep( $delay );
		}
		
		curl_close($ch);
		return $out;
	}
	


	// extend admin css
	function add_css() {
		$dir= plugins_url( 'assets', __FILE__ );
		wp_enqueue_style( 'kereso_css', "$dir/admin.css" );
	}

	

}


	
	

	
	
	
	
	
	

class arukereso_cron {



	// constructor
    function __construct() {

		// add cron event
		register_activation_hook( __FILE__, [$this,'activation'] );

		// remove cron event
		register_deactivation_hook( __FILE__, [$this,'deactivation'] );
		
		// update prices
		add_action( 'kereso_update', [$this,'update'] );
		
		// add column
		add_filter( 'manage_edit-product_columns', [$this,'add_column_mod'] );
		
		// populate column cells
		add_action( 'manage_product_posts_custom_column', [$this,'add_column_mod_value'], 10, 2 );
		
		// make columns sortable
		add_filter( 'manage_edit-product_sortable_columns', [$this,'add_column_mod_sortable'] );
		
		// set query to sort
		add_action( 'pre_get_posts', [$this,'make_column_mod_sortable'] );
		
	}
	
	

	// add cron event
	function activation() {
		if( !wp_next_scheduled('kereso_update') ) {
		  wp_schedule_event( time(), 'daily', 'kereso_update' );
		}
	}

	

	// remove cron event
	function deactivation() {
		wp_clear_scheduled_hook( 'kereso_update' );
	}


	
	// update prices
	function update() {
		global $wpdb;
		
		// php setup
		ini_set( 'memory_limit', '512M' );
		set_time_limit( 20*3600 );
		
		// needs update
		$arr= $wpdb->get_results("
		  SELECT id, url.meta_value AS url
		  FROM wp_posts, wp_postmeta AS url, wp_postmeta AS stock
		  WHERE url.post_id = ID
		  AND stock.post_id = ID
		  AND post_status = 'publish'
		  AND url.meta_key = '_kereso_url'
		  AND stock.meta_key = '_stock_status'
		  AND stock.meta_value = 'instock'
		  AND post_modified < SUBDATE( now(), 1 )
		  ORDER BY post_modified
		", ARRAY_A );
		$arr= array_column( $arr, 'url', 'id' );
		
		foreach( $arr as $id => $url ) {
		  // download page
		  $html= arukereso::curl( $url, 10, 2, 10 );
		  $html ? $err=0 : $err++;
		  if( $err>20 ) { break; }
		  // find price
		  $ar= arukereso::price( $html );
		  if( $ar==0 ) { continue; }
		  // set prices
		  $min= get_post_meta( $id, '_min_price', true );
		  $old= get_post_meta( $id, '_regular_price', true );
		  $ar = max( $ar, $min );
		  update_post_meta( $id, '_regular_price', $ar );
		  update_post_meta( $id, '_price', $ar, $old );
		  // set date
		  $this->post_modified( $id );
		}
		
	}



	// manage columns
	function add_column_mod( $columns ) {
		$columns['mod'] = 'Frissítve';
		return $columns;
	}


	// populate column cells
	function add_column_mod_value( $column, $pid ) {
		if( $column != 'mod' ) { return; }
		$post= get_post( $pid );
		$date= new DateTime( $post->post_modified );
		$diff= $date->diff( new DateTime() );
		echo $diff->format( '%a napja' );
	}


	// make columns sortable
	function add_column_mod_sortable( $columns ){
	   $columns['mod'] = 'mod';
	   return $columns;
	}


	// set query to sort
	function make_column_mod_sortable( $query ) {
		$order = $query->get( 'orderby' );
		if( $order == 'mod' ) {
		  $query->set( 'orderby', 'post_modified' );
		}
	}




	// set post mod-date
	static function post_modified( $id ) {
		global $wpdb;
		
		$sql = $wpdb->prepare("
		  UPDATE wp_posts 
		  SET post_modified = NOW()
		  WHERE ID = %d
		", $id );
		$wpdb->query( $sql );
	}
	
	
	
}
	
	
	
	
	
	
	