


	// input on-click
	ak_select= function() {
		setTimeout( ()=>this.select(), 0 );
	}
	
	// input on-paste
	ak_paste= function() {
		setTimeout( ak_ajax, 100, this );
	}
	
	// input on-keyup
	ak_keyup= function( e ) {
		this.classList.remove( 'red', 'green' );
		this.value || ak_display();
	}

	
	// ajax request
	ak_ajax= async function( inp ) {
		
		// body
		var body= new FormData();
		body.set( 'url', inp.value );
		
		// fetch
		var opt= { method:'POST', body };
		var res= await fetch( ajax, opt );
		
		// parse
		var json= res.headers.get('Content-Type').includes('json');
		res= json ? await res.json() : !res.text();

		ak_display( res );
		
	}
	
	
	// show json
	ak_display= function( obj ) {

		var inp= jQuery('#arukereso input').first();
		var div= jQuery('#arukereso div.inside');

		// effects		
		if( obj ) {
		  inp.addClass('green');
		  div.css( 'max-height', '1500px' );
		} else {
		  div.removeAttr("style");
		  if( obj==null ) { return; }
		  inp.addClass('red');
		  return;
		}
		
		// content
		jQuery('label.akt').html( obj.title );
		jQuery('label.akp').html( obj.price );
		jQuery('label.akd').html( obj.desc );
		
		var par= jQuery('label.aka').html('');
		for( n in obj.attr ) {
		  v= obj.attr[ n ];
		  par.append( '<b>' +n+ '</b><i>' +v+ '</i>' );
		}
		jQuery('label.aki img').attr( 'src', obj.img );
		
	}
	
	
	
	// label on-click
	ak_click= function() {
		var def= 'http://arukereso.hu';
		var url= this.nextElementSibling.value;
		var win= window.open();
		win.opener= null;
		win.location= url || def;
		return false;
	}
	
	
	// remove submit-events
	ak_save= function() {
		jQuery( this.form ).off('submit');
	}

	
	
	// open link
	jQuery('p.url label').click( ak_click );
	
	// input events
	jQuery('p.url input').click( ak_select ).on( 'paste', ak_paste ).keyup( ak_keyup );

	// auto send
	jQuery('p.url input.1').trigger('paste');
	
	// close
	jQuery('input.close').click( e=>ak_display() );
	
	// save
	jQuery('input.import').click( ak_save );
	

	
	
	
	