<?php
/**
 * URL Inspection features.
 *
 * @since      3.0.8
 * @package    RankMathPro
 * @subpackage RankMathPro
 * @author     Rank Math <support@rankmath.com>
 */

namespace RankMathPro\Analytics;

use RankMathPro\Analytics\DB;
use RankMath\Traits\Hooker;

/**
 * Url_Inspection class.
 */
class Url_Inspection {

	use Hooker;

	/**
	 * The Constructor.
	 */
	public function __construct() {
		$this->filter( 'rank_math/analytics/url_inspection_map_properties', 'map_inspection_properties', 10, 2 );
		$this->action( 'rank_math/analytics/get_inspections_query', 'add_filter_params', 10, 2 );
		$this->action( 'rank_math/analytics/get_inspections_count_query', 'add_filter_params', 10, 2 );
	}

	/**
	 * Filter to alter the where clause used in the get_inspections function.
	 *
	 * @param string $where  WHERE clause.
	 * @param array  $params Parameters.
	 *
	 * @return string
	 */
	public function add_filter_params( $query, $params ) {
		if ( empty( $params['indexingFilter'] ) ) {
			return;
		}

		$table = DB::inspections()->table;
		$query->where( "$table.coverage_state", $params['indexingFilter'] );
	}

	/**
	 * Map properties in the API result to columns in the database.
	 *
	 * @param array $normalized Normalized data.
	 * @param array $incoming   Incoming data from the API.
	 *
	 * @return array
	 */
	public function map_inspection_properties( $normalized, $incoming ) {
		$handler = \RankMath\Google\Url_Inspection::get();

		$handler->assign_inspection_value( $incoming, 'richResultsResult.detectedItems', 'rich_results_items', $normalized );
		$handler->assign_inspection_value( $incoming, 'indexStatusResult.lastCrawlTime', 'last_crawl_time', $normalized );

		// Store the raw response, too.
		$normalized['raw_api_response'] = wp_json_encode( $incoming );

		return $normalized;
	}

	/**
	 * Get stats for "Presence on Google" widget.
	 */
	public static function get_presence_stats() {
		return DB::get_presence_stats();
	}

	/**
	 * Get stats for "Top Statuses" widget.
	 */
	public static function get_status_stats() {
		return DB::get_status_stats();
	}
}
