<?php 

Kirki::add_section( 'layout', array(
    'title'       => esc_html__( 'Layout', 'rozer' ),
    'panel'       => 'general'
) );
Kirki::add_field( 'option', [
	'type'        => 'radio-buttonset',
	'settings'    => 'layout_mode',
	'label'       => esc_html__( 'Layout mode', 'rozer' ),
	'section'     => 'layout',
	'default'     => 'fullwidth',
	'choices'     => [
		'fullwidth'   => esc_html__( 'Full width', 'rozer' ),
		'boxed' => esc_html__( 'Boxed', 'rozer' ),
	],
	'transport'   => 'postMessage',
] );
Kirki::add_field( 'option', [
	'type'     => 'text',
	'settings' => 'site_width',
	'label'    => esc_html__( 'Site Content Width (px)', 'rozer' ),
	'section'  => 'layout',
	'description'  => esc_html__( 'Set the default width of content containers.', 'rozer' ),
	'transport'   => 'postMessage',
	'default'   => '1470',
] );
Kirki::add_field( 'option', [
	'type'        => 'background',
	'settings'    => 'layout_background',
	'label'       => esc_html__( 'Background', 'rozer' ),
	'section'     => 'layout',
	'default'     => [
		'background-color'      => '#ffffff',
		'background-image'      => '',
		'background-repeat'     => 'repeat',
		'background-position'   => 'center center',
		'background-size'       => 'cover',
		'background-attachment' => 'scroll',
	],
	'transport'   => 'auto',
	'output'      => [
		[
			'element' => 'body',
		],
	],
] );
Kirki::add_field( 'option', [
	'type'        => 'custom',
	'settings'    => 'layout_boxed',
	'section'     => 'layout',
	'default'         => '<div class="customize-title-divider">' . __( 'Boxed layout', 'rozer' ) . '</div>',
	'active_callback' => [
		[
			'setting'  => 'layout_mode',
			'operator' => '==',
			'value'    => 'boxed',
		]
	],
] );
Kirki::add_field( 'option', [
	'type'     => 'text',
	'settings' => 'boxed_width',
	'label'    => esc_html__( 'Boxed Width (px)', 'rozer' ),
	'section'  => 'layout',
	'description'  => esc_html__( 'Use for boxed layout mode', 'rozer' ),
	'transport'   => 'postMessage',
	'active_callback' => [
		[
			'setting'  => 'layout_mode',
			'operator' => '==',
			'value'    => 'boxed',
		]
	],
] );
Kirki::add_field( 'option', [
	'type'        => 'background',
	'settings'    => 'layout_boxed_background',
	'label'       => esc_html__( 'Boxed Background', 'rozer' ),
	'section'     => 'layout',
	'default'     => [
		'background-color'      => '#ffffff',
		'background-image'      => '',
		'background-repeat'     => 'repeat',
		'background-position'   => 'center center',
		'background-size'       => 'cover',
		'background-attachment' => 'scroll',
	],
	'transport'   => 'auto',
	'output'      => [
		[
			'element' => '#page',
		],
	],
	'active_callback' => [
		[
			'setting'  => 'layout_mode',
			'operator' => '==',
			'value'    => 'boxed',
		]
	],
] );